DROP TABLE IF EXISTS `shd_auth_rule`;
CREATE TABLE `shd_auth_rule`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否有效(0:无效,1:有效)',
  `app` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则所属app',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '权限规则分类，请加应用前缀,如admin_',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则唯一英文标识,全小写',
  `param` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '额外url参数',
  `title` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '规则描述',
  `condition` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则附加条件',
  `pid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级权限id',
  `is_display` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否显示1=是 0=否',
  `url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '跳转地址',
  `order` int(10) NOT NULL DEFAULT 1 COMMENT '排序',
  `language_map` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '多语言列表',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `module`(`app`, `status`, `type`) USING BTREE,
  INDEX `name`(`name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2192 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '权限规则表' ROW_FORMAT = Compact;
INSERT INTO `shd_auth_rule` VALUES (1, 1, 'admin', 'admin_url', 'client', '', '客户', '', 0, 1, '/customer-list', 1, '{\"CN\":\"客户\",\"HK\":\"客戶\",\"US\":\"Customer\"}');
INSERT INTO `shd_auth_rule` VALUES (2, 1, 'admin', 'admin_url', 'order', '', '业务', '', 0, 1, '/order-list', 122, '{\"CN\":\"业务\",\"HK\":\"業務\",\"US\":\"Business\"}');
INSERT INTO `shd_auth_rule` VALUES (3, 1, 'admun', 'admin_url', 'Financial', '', '财务', '', 0, 1, '/business-statement', 188, '{\"CN\":\"财务\",\"HK\":\"財務\",\"US\":\"Finance\"}');
INSERT INTO `shd_auth_rule` VALUES (4, 1, 'admin', 'admin_url', 'Support options', '', '工单', '', 0, 1, '/support-ticket', 289, '{\"CN\":\"工单\",\"HK\":\"工單\",\"US\":\"Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (11, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plIndex', '', '支付接口', '', 1902, 1, '/payment-interface', 259, '{\"CN\":\"支付接口\",\"HK\":\"支付接口\",\"US\":\"Payment Interface\"}');
INSERT INTO `shd_auth_rule` VALUES (12, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::createClientPost', '', '添加客户', '', 1, 0, '/customer-add', 3, '{\"CN\":\"添加客户\",\"HK\":\"添加客戶\",\"US\":\"Add Customer\"}');
INSERT INTO `shd_auth_rule` VALUES (13, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController', '', '客户列表', '', 1860, 1, '/customer-list', 5, '{\"CN\":\"客户列表\",\"HK\":\"客戶列表\",\"US\":\"Customer List\"}');
INSERT INTO `shd_auth_rule` VALUES (14, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::createPage', '', '添加订单', '', 1866, 0, '/add-order', 124, '{\"CN\":\"添加订单\",\"HK\":\"添加訂單\",\"US\":\"Add Order\"}');
INSERT INTO `shd_auth_rule` VALUES (15, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController', '', '产品订单', '', 1866, 1, '/order-list', 131, '{\"CN\":\"产品订单\",\"HK\":\"產品訂單\",\"US\":\"Product Order\"}');
INSERT INTO `shd_auth_rule` VALUES (16, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperList', '', '开发者列表', '', 0, 0, '/customer-developer', 812, '{\"CN\":\"开发者列表\",\"HK\":\"開發者列表\",\"US\":\"Developer List\"}');
INSERT INTO `shd_auth_rule` VALUES (17, 1, 'admin', 'admin_url', '', '', '续费订单', '', 1866, 1, '/renewal-order', 142, '{\"CN\":\"续费订单\",\"HK\":\"續費訂單\",\"US\":\"Renewal Order\"}');
INSERT INTO `shd_auth_rule` VALUES (18, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController', '', '商品管理', '', 1875, 1, '/product-server', 361, '{\"CN\":\"商品管理\",\"HK\":\"商品管理\",\"US\":\"Commodity Management\"}');
INSERT INTO `shd_auth_rule` VALUES (19, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::listFlowPacket', '', '流量包管理', '', 1875, 1, '/dcim-traffic', 391, '{\"CN\":\"流量包管理\",\"HK\":\"流量包管理\",\"US\":\"Traffic Package Management\"}');
INSERT INTO `shd_auth_rule` VALUES (21, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController', '', '魔方云', '', 5, 0, '', 431, '{\"CN\":\"魔方云\",\"HK\":\"魔方雲\",\"US\":\"Magic Cube Cloud\"}');
INSERT INTO `shd_auth_rule` VALUES (22, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController', '', '裸金属', '', 5, 0, '', 442, '{\"CN\":\"裸金属\",\"HK\":\"裸金屬\",\"US\":\"Bare Metal\"}');
INSERT INTO `shd_auth_rule` VALUES (25, 1, 'admin', 'admin_url', 'hook', '', '插件安装', '', 0, 0, '', 814, '{\"CN\":\"插件安装\",\"HK\":\"插件安裝\",\"US\":\"Plugin Installation\"}');
INSERT INTO `shd_auth_rule` VALUES (27, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::listBuyRecord', '', '流量包订单', '', 1866, 1, '/dcim-traffic-log', 144, '{\"CN\":\"流量包订单\",\"HK\":\"流量包訂單\",\"US\":\"Traffic Package Order\"}');
INSERT INTO `shd_auth_rule` VALUES (28, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController', '', '业务列表', '', 1867, 1, '/customer-product', 148, '{\"CN\":\"业务列表\",\"HK\":\"業務列表\",\"US\":\"Business List\"}');
INSERT INTO `shd_auth_rule` VALUES (29, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getProuductlistPage', '', '商品设置', '', 22, 0, '/dcim-product', 443, '{\"CN\":\"商品设置\",\"HK\":\"商品設置\",\"US\":\"Commodity Setting\"}');
INSERT INTO `shd_auth_rule` VALUES (30, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '可配置选项', '', 22, 0, '/configurable-option?type=dcim', 462, '{\"CN\":\"可配置选项\",\"HK\":\"可配置選項\",\"US\":\"Configurable Options\"}');
INSERT INTO `shd_auth_rule` VALUES (157, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PublicController', '', '后台登录', '', 590, 0, '', 886, '{\"CN\":\"后台登录\",\"HK\":\"後台登錄\",\"US\":\"Background login\"}');
INSERT INTO `shd_auth_rule` VALUES (158, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PublicController::ad_login', '', '登录', '', 157, 0, '', 889, '{\"CN\":\"登录\",\"HK\":\"登錄\",\"US\":\"Login\"}');
INSERT INTO `shd_auth_rule` VALUES (159, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PublicController::ad_logout', '', '后台管理员退出', '', 157, 0, '', 890, '{\"CN\":\"后台管理员退出\",\"HK\":\"後台管理員退出\",\"US\":\"Back-office administrator exit\"}');
INSERT INTO `shd_auth_rule` VALUES (160, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController', '', '后台设置', '', 590, 0, '', 891, '{\"CN\":\"后台设置\",\"HK\":\"後台設置\",\"US\":\"Background Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (164, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController::postCustomFields', '', '保存用户自定义字段', '', 160, 0, '', 892, '{\"CN\":\"保存用户自定义字段\",\"HK\":\"保存用戶自定義字段\",\"US\":\"Save user-defined fields\"}');
INSERT INTO `shd_auth_rule` VALUES (165, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController::delCustomFields', '', '删除用户自定义字段配置', '', 160, 0, '', 893, '{\"CN\":\"删除用户自定义字段配置\",\"HK\":\"刪除用戶自定義字段配置\",\"US\":\"Delete user-defined field configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (189, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::addRolePage', '', '添加角色（添加管理员分组）', '', 588, 0, '', 594, '{\"CN\":\"添加角色（添加管理员分组）\",\"HK\":\"添加角色（添加管理員分組）\",\"US\":\"Add role (add administrator group)\"}');
INSERT INTO `shd_auth_rule` VALUES (190, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::addRole', '', '添加角色（添加管理员分组）', '', 189, 0, '', 595, '{\"CN\":\"添加角色（添加管理员分组）\",\"HK\":\"添加角色（添加管理員分組）\",\"US\":\"Add role (add administrator group)\"}');
INSERT INTO `shd_auth_rule` VALUES (191, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::editRolePage', '', '编辑角色（编辑管理员分组）', '', 588, 0, '', 596, '{\"CN\":\"编辑角色（编辑管理员分组）\",\"HK\":\"編輯角色（編輯管理員分組）\",\"US\":\"Edit role (edit administrator group)\"}');
INSERT INTO `shd_auth_rule` VALUES (192, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::editRole', '', '编辑角色（编辑管理员分组）', '', 191, 0, '', 597, '{\"CN\":\"编辑角色（编辑管理员分组）\",\"HK\":\"編輯角色（編輯管理員分組）\",\"US\":\"Edit role (edit administrator group)\"}');
INSERT INTO `shd_auth_rule` VALUES (193, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::delete', '', '删除角色(删除管理员组)', '', 588, 0, '', 598, '{\"CN\":\"删除角色(删除管理员组)\",\"HK\":\"刪除角色(刪除管理員組)\",\"US\":\"Delete role (delete administrator group)\"}');
INSERT INTO `shd_auth_rule` VALUES (195, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::adminList', '', '员工管理', '', 1912, 1, '/admin-management', 615, '{\"CN\":\"员工管理\",\"HK\":\"員工管理\",\"US\":\"Staff Management\"}');
INSERT INTO `shd_auth_rule` VALUES (196, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::createPage', '', '管理员添加', '', 195, 0, '', 619, '{\"CN\":\"管理员添加\",\"HK\":\"管理員添加\",\"US\":\"Added by Administrator\"}');
INSERT INTO `shd_auth_rule` VALUES (197, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::create', '', '管理员添加', '', 196, 0, '', 620, '{\"CN\":\"管理员添加\",\"HK\":\"管理員添加\",\"US\":\"Added by Administrator\"}');
INSERT INTO `shd_auth_rule` VALUES (198, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::updatePage', '', '管理员编辑显示', '', 195, 0, '', 621, '{\"CN\":\"管理员编辑显示\",\"HK\":\"管理員編輯顯示\",\"US\":\"Administrator edit display\"}');
INSERT INTO `shd_auth_rule` VALUES (199, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::update', '', '管理员编辑', '', 198, 0, '', 622, '{\"CN\":\"管理员编辑\",\"HK\":\"管理員編輯\",\"US\":\"Administrator Edit\"}');
INSERT INTO `shd_auth_rule` VALUES (200, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::delete', '', '管理员删除', '', 195, 0, '', 623, '{\"CN\":\"管理员删除\",\"HK\":\"管理員刪除\",\"US\":\"Administrator delete\"}');
INSERT INTO `shd_auth_rule` VALUES (201, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::ban', '', '停用管理员', '', 195, 0, '', 624, '{\"CN\":\"停用管理员\",\"HK\":\"停用管理員\",\"US\":\"Disable Administrator\"}');
INSERT INTO `shd_auth_rule` VALUES (202, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::cancelBan', '', '启用管理员', '', 195, 0, '', 625, '{\"CN\":\"启用管理员\",\"HK\":\"啟用管理員\",\"US\":\"Enable Administrator\"}');
INSERT INTO `shd_auth_rule` VALUES (203, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::getList', '', '优惠码', '', 1902, 1, '/promo-code', 271, '{\"CN\":\"优惠码\",\"HK\":\"優惠碼\",\"US\":\"Promotion Code\"}');
INSERT INTO `shd_auth_rule` VALUES (204, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::addPage', '', '添加优惠码', '', 203, 0, '', 273, '{\"CN\":\"添加优惠码\",\"HK\":\"添加優惠碼\",\"US\":\"Add coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (205, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::add', '', '添加优惠码提交', '', 204, 0, '', 275, '{\"CN\":\"添加优惠码提交\",\"HK\":\"添加優惠碼提交\",\"US\":\"Add coupon code to submit\"}');
INSERT INTO `shd_auth_rule` VALUES (206, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::savePage', '', '编辑优惠码', '', 203, 0, '', 276, '{\"CN\":\"编辑优惠码\",\"HK\":\"編輯優惠碼\",\"US\":\"Edit Promo Code\"}');
INSERT INTO `shd_auth_rule` VALUES (207, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::save', '', '编辑优惠码提交', '', 206, 0, '', 278, '{\"CN\":\"编辑优惠码提交\",\"HK\":\"編輯優惠碼提交\",\"US\":\"Edit coupon code submission\"}');
INSERT INTO `shd_auth_rule` VALUES (208, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::delete', '', '删除优惠码', '', 203, 0, '', 281, '{\"CN\":\"删除优惠码\",\"HK\":\"刪除優惠碼\",\"US\":\"Delete coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (209, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::expireImmediately', '', '优惠码立即过期', '', 206, 0, '', 279, '{\"CN\":\"优惠码立即过期\",\"HK\":\"優惠碼立即過期\",\"US\":\"The coupon code expires immediately\"}');
INSERT INTO `shd_auth_rule` VALUES (211, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::autoPromoCode', '', '自动生成优惠码', '', 206, 0, '', 280, '{\"CN\":\"自动生成优惠码\",\"HK\":\"自動生成優惠碼\",\"US\":\"Automatically generate coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (212, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController', '', '后台服务器配置', '', 0, 0, '/server-settings', 937, '{\"CN\":\"后台服务器配置\",\"HK\":\"後台服務器配置\",\"US\":\"Background server configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (214, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::addServers', '', '添加服务器', '', 528, 0, '', 402, '{\"CN\":\"添加服务器\",\"HK\":\"添加服務器\",\"US\":\"Add Server\"}');
INSERT INTO `shd_auth_rule` VALUES (215, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::addServersPost', '', '添加服务器提交', '', 214, 0, '', 403, '{\"CN\":\"添加服务器提交\",\"HK\":\"添加服務器提交\",\"US\":\"Add server submission\"}');
INSERT INTO `shd_auth_rule` VALUES (216, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::editServers', '', '编辑服务器', '', 528, 0, '', 404, '{\"CN\":\"编辑服务器\",\"HK\":\"編輯服務器\",\"US\":\"Edit Server\"}');
INSERT INTO `shd_auth_rule` VALUES (217, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::editServersPost', '', '编辑服务器提交', '', 216, 0, '', 405, '{\"CN\":\"编辑服务器提交\",\"HK\":\"編輯服務器提交\",\"US\":\"Edit server submission\"}');
INSERT INTO `shd_auth_rule` VALUES (218, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::deleteServers', '', '删除服务器', '', 528, 0, '', 406, '{\"CN\":\"删除服务器\",\"HK\":\"刪除服務器\",\"US\":\"Delete Server\"}');
INSERT INTO `shd_auth_rule` VALUES (219, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::createGroups', '', '创建服务器组', '', 528, 0, '', 407, '{\"CN\":\"创建服务器组\",\"HK\":\"創建服務器組\",\"US\":\"Create Server Group\"}');
INSERT INTO `shd_auth_rule` VALUES (220, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::createGroupsPost', '', '创建服务器组提交', '', 219, 0, '', 408, '{\"CN\":\"创建服务器组提交\",\"HK\":\"創建服務器組提交\",\"US\":\"Create server group submission\"}');
INSERT INTO `shd_auth_rule` VALUES (221, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::editServerGroups', '', '编辑服务器组', '', 528, 0, '', 409, '{\"CN\":\"编辑服务器组\",\"HK\":\"編輯服務器組\",\"US\":\"Edit Server Group\"}');
INSERT INTO `shd_auth_rule` VALUES (222, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::editServerGroupsPost', '', '编辑服务器组页面提交', '', 221, 0, '', 410, '{\"CN\":\"编辑服务器组页面提交\",\"HK\":\"編輯服務器組頁面提交\",\"US\":\"Edit server group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (223, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::deleteServerGroups', '', '删除服务器组', '', 528, 0, '', 411, '{\"CN\":\"删除服务器组\",\"HK\":\"刪除服務器組\",\"US\":\"Delete Server Group\"}');
INSERT INTO `shd_auth_rule` VALUES (224, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController', '', '可配置选项组', '', 0, 0, '/configurable-option', 945, '{\"CN\":\"可配置选项组\",\"HK\":\"可配置選項組\",\"US\":\"Configurable Option Group\"}');
INSERT INTO `shd_auth_rule` VALUES (226, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::createGroups', '', '创建可选项配置组', '', 30, 0, '', 464, '{\"CN\":\"创建可选项配置组\",\"HK\":\"創建可選項配置組\",\"US\":\"Create optional configuration group\"}');
INSERT INTO `shd_auth_rule` VALUES (227, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::createGroupsPost', '', '创建可选项配置组页面提交', '', 226, 0, '', 465, '{\"CN\":\"创建可选项配置组页面提交\",\"HK\":\"創建可選項配置組頁面提交\",\"US\":\"Create optional configuration group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (228, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editGroups', '', '编辑可配置选项组', '', 30, 0, '', 466, '{\"CN\":\"编辑可配置选项组\",\"HK\":\"編輯可配置選項組\",\"US\":\"Edit configurable option group\"}');
INSERT INTO `shd_auth_rule` VALUES (229, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editGroupsPost', '', '编辑可配置选项组页面提交', '', 228, 0, '', 467, '{\"CN\":\"编辑可配置选项组页面提交\",\"HK\":\"編輯可配置選項組頁面提交\",\"US\":\"Edit configurable option group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (230, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::addOptions', '', '添加可配置选项', '', 228, 0, '', 468, '{\"CN\":\"添加可配置选项\",\"HK\":\"添加可配置選項\",\"US\":\"Add configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (231, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteSubOptions', '', '删除可配置选项的子选项', '', 232, 0, '', 470, '{\"CN\":\"删除可配置选项的子选项\",\"HK\":\"刪除可配置選項的子選項\",\"US\":\"Delete sub-options of configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (232, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteOptions', '', '删除可配置选项', '', 228, 0, '', 469, '{\"CN\":\"删除可配置选项\",\"HK\":\"刪除可配置選項\",\"US\":\"Delete configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (233, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteGroups', '', '删除可配置选项组', '', 30, 0, '', 473, '{\"CN\":\"删除可配置选项组\",\"HK\":\"刪除可配置選項組\",\"US\":\"Delete configurable option group\"}');
INSERT INTO `shd_auth_rule` VALUES (234, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::duplicateGroups', '', '复制可配置选项组', '', 30, 0, '', 474, '{\"CN\":\"复制可配置选项组\",\"HK\":\"複製可配置選項組\",\"US\":\"Copy Configurable Option Group\"}');
INSERT INTO `shd_auth_rule` VALUES (235, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::duplicateGroupsPost', '', '复制可配置选项组页面提交', '', 234, 0, '', 475, '{\"CN\":\"复制可配置选项组页面提交\",\"HK\":\"複製可配置選項組頁面提交\",\"US\":\"Copy configurable option group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (236, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editConfig', '', '编辑可配置项', '', 228, 0, '', 471, '{\"CN\":\"编辑可配置项\",\"HK\":\"編輯可配置項\",\"US\":\"Edit configurable items\"}');
INSERT INTO `shd_auth_rule` VALUES (237, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editConfigPost', '', '编辑可配置项页面提交', '', 236, 0, '', 472, '{\"CN\":\"编辑可配置项页面提交\",\"HK\":\"編輯可配置項頁面提交\",\"US\":\"Edit configurable item page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (238, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getGeneral', '', '显示设置', '', 8, 1, '/base-info', 498, '{\"CN\":\"显示设置\",\"HK\":\"顯示設置\",\"US\":\"Display Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (240, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::configMobile', '', '短信设置详情', '', 1359, 0, '', 630, '{\"CN\":\"短信设置详情\",\"HK\":\"短信設置詳情\",\"US\":\"SMS setting details\"}');
INSERT INTO `shd_auth_rule` VALUES (242, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::createTemplatePage', '', '创建模板', '', 533, 0, '', 653, '{\"CN\":\"创建模板\",\"HK\":\"創建模板\",\"US\":\"Create Template\"}');
INSERT INTO `shd_auth_rule` VALUES (243, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::createTemplate', '', '创建模板并提交审核', '', 242, 0, '', 654, '{\"CN\":\"创建模板并提交审核\",\"HK\":\"創建模板並提交審核\",\"US\":\"Create a template and submit it for review\"}');
INSERT INTO `shd_auth_rule` VALUES (244, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::updateTemplate', '', '更新模板', '', 533, 0, '', 655, '{\"CN\":\"更新模板\",\"HK\":\"更新模板\",\"US\":\"Update Template\"}');
INSERT INTO `shd_auth_rule` VALUES (245, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::updateTemplatePost', '', '更新模板页面提交并审核', '', 244, 0, '', 656, '{\"CN\":\"更新模板页面提交并审核\",\"HK\":\"更新模板頁面提交並審核\",\"US\":\"Submit and review the updated template page\"}');
INSERT INTO `shd_auth_rule` VALUES (246, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::deleteTemplate', '', '删除模板', '', 533, 0, '', 657, '{\"CN\":\"删除模板\",\"HK\":\"刪除模板\",\"US\":\"Delete Template\"}');
INSERT INTO `shd_auth_rule` VALUES (248, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::SetSmsTemplate', '', '发送设置详情', '', 536, 0, '', 662, '{\"CN\":\"发送设置详情\",\"HK\":\"發送設置詳情\",\"US\":\"Send setting details\"}');
INSERT INTO `shd_auth_rule` VALUES (249, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::testMessageTemplatePage', '', '测试短信模板', '', 533, 0, '/sms-template-index', 658, '{\"CN\":\"测试短信模板\",\"HK\":\"測試短信模板\",\"US\":\"Test SMS template\"}');
INSERT INTO `shd_auth_rule` VALUES (250, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::testMessageTemplate', '', '测试短信模板', '', 249, 0, '', 659, '{\"CN\":\"测试短信模板\",\"HK\":\"測試短信模板\",\"US\":\"Test SMS template\"}');
INSERT INTO `shd_auth_rule` VALUES (251, 1, 'admin', 'admin_url', '', '', '会员中心与购物', '', 8, 0, '', 521, '{\"CN\":\"会员中心与购物\",\"HK\":\"會員中心與購物\",\"US\":\"Member Center and Shopping\"}');
INSERT INTO `shd_auth_rule` VALUES (252, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getGetCustomParam', '', '自定义模板字段', '', 8, 0, '/custom-template-fields', 562, '{\"CN\":\"自定义模板字段\",\"HK\":\"自定義模板字段\",\"US\":\"Customize template fields\"}');
INSERT INTO `shd_auth_rule` VALUES (253, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::addCurrency', '', '添加货币种类', '', 260, 0, '', 255, '{\"CN\":\"添加货币种类\",\"HK\":\"添加貨幣種類\",\"US\":\"Add currency type\"}');
INSERT INTO `shd_auth_rule` VALUES (254, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::editCurrency', '', '编辑货币种类', '', 260, 0, '', 256, '{\"CN\":\"编辑货币种类\",\"HK\":\"編輯貨幣種類\",\"US\":\"Edit currency type\"}');
INSERT INTO `shd_auth_rule` VALUES (255, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::editCurrencyPost', '', '编辑货币种类页面提交', '', 254, 0, '', 258, '{\"CN\":\"编辑货币种类页面提交\",\"HK\":\"編輯貨幣種類頁面提交\",\"US\":\"Edit currency type page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (256, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::deleteCurrency', '', '删除货币种类', '', 260, 0, '', 251, '{\"CN\":\"删除货币种类\",\"HK\":\"刪除貨幣種類\",\"US\":\"Delete currency type\"}');
INSERT INTO `shd_auth_rule` VALUES (257, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::updateRate', '', '更新汇率', '', 260, 0, '', 252, '{\"CN\":\"更新汇率\",\"HK\":\"更新匯率\",\"US\":\"Update exchange rate\"}');
INSERT INTO `shd_auth_rule` VALUES (258, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::defaultCurrency', '', '选择默认货币', '', 0, 0, '', 803, '{\"CN\":\"选择默认货币\",\"HK\":\"選擇默認貨幣\",\"US\":\"Select the default currency\"}');
INSERT INTO `shd_auth_rule` VALUES (259, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::updatePrice', '', '更新价格', '', 260, 0, '', 253, '{\"CN\":\"更新价格\",\"HK\":\"更新價格\",\"US\":\"Update price\"}');
INSERT INTO `shd_auth_rule` VALUES (260, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::currencyList', '', '货币配置', '', 1902, 1, '/currency-settings', 250, '{\"CN\":\"货币配置\",\"HK\":\"貨幣配置\",\"US\":\"Currency Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (261, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::uploadLogo', '', '设置上传合同logo', '', 922, 0, '', 872, '{\"CN\":\"设置上传合同logo\",\"HK\":\"設置上傳合同logo\",\"US\":\"Set upload contract logo\"}');
INSERT INTO `shd_auth_rule` VALUES (262, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::uploadLogoPost', '', '设置上传合同logo提交', '', 922, 0, '', 873, '{\"CN\":\"设置上传合同logo提交\",\"HK\":\"設置上傳合同logo提交\",\"US\":\"Set upload contract logo submission\"}');
INSERT INTO `shd_auth_rule` VALUES (263, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractList', '', '合同列表', '', 922, 0, '', 874, '{\"CN\":\"合同列表\",\"HK\":\"合同列表\",\"US\":\"Contract List\"}');
INSERT INTO `shd_auth_rule` VALUES (264, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractDetail', '', '查看合同详情', '', 922, 0, '', 875, '{\"CN\":\"查看合同详情\",\"HK\":\"查看合同詳情\",\"US\":\"View contract details\"}');
INSERT INTO `shd_auth_rule` VALUES (265, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::downloadContract', '', '查看下载', '', 922, 0, '', 876, '{\"CN\":\"查看下载\",\"HK\":\"查看下載\",\"US\":\"View Download\"}');
INSERT INTO `shd_auth_rule` VALUES (266, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::checkContract', '', '审核通过', '', 922, 0, '', 877, '{\"CN\":\"审核通过\",\"HK\":\"審核通過\",\"US\":\"Approved\"}');
INSERT INTO `shd_auth_rule` VALUES (267, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::cancelContract', '', '合同作废', '', 922, 0, '', 878, '{\"CN\":\"合同作废\",\"HK\":\"合同作廢\",\"US\":\"Contract voided\"}');
INSERT INTO `shd_auth_rule` VALUES (268, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::deleteContract', '', '删除合同', '', 922, 0, '', 879, '{\"CN\":\"删除合同\",\"HK\":\"刪除合同\",\"US\":\"Delete Contract\"}');
INSERT INTO `shd_auth_rule` VALUES (269, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractTemplateList', '', '合同模块列表', '', 922, 0, '', 880, '{\"CN\":\"合同模块列表\",\"HK\":\"合同模塊列表\",\"US\":\"Contract Module List\"}');
INSERT INTO `shd_auth_rule` VALUES (270, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::createContract', '', '创建合同', '', 922, 0, '', 881, '{\"CN\":\"创建合同\",\"HK\":\"創建合同\",\"US\":\"Create Contract\"}');
INSERT INTO `shd_auth_rule` VALUES (271, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::createContractPost', '', '创建合同页面提交', '', 922, 0, '', 882, '{\"CN\":\"创建合同页面提交\",\"HK\":\"創建合同頁面提交\",\"US\":\"Submit to create contract page\"}');
INSERT INTO `shd_auth_rule` VALUES (272, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::editContract', '', '编辑合同', '', 922, 0, '', 883, '{\"CN\":\"编辑合同\",\"HK\":\"編輯合同\",\"US\":\"Edit Contract\"}');
INSERT INTO `shd_auth_rule` VALUES (273, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::editContractPost', '', '编辑合同页面提交', '', 922, 0, '', 884, '{\"CN\":\"编辑合同页面提交\",\"HK\":\"編輯合同頁面提交\",\"US\":\"Edit contract page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (274, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::deleteContractTemplate', '', '删除合同模板', '', 922, 0, '', 885, '{\"CN\":\"删除合同模板\",\"HK\":\"刪除合同模板\",\"US\":\"Delete contract template\"}');
INSERT INTO `shd_auth_rule` VALUES (284, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::emailList', '', '邮件模板列表', '', 531, 0, '', 635, '{\"CN\":\"邮件模板列表\",\"HK\":\"郵件模板列表\",\"US\":\"Mail template list\"}');
INSERT INTO `shd_auth_rule` VALUES (285, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::createTemplate', '', '创建邮件模板', '', 531, 0, '', 636, '{\"CN\":\"创建邮件模板\",\"HK\":\"創建郵件模板\",\"US\":\"Create Email Template\"}');
INSERT INTO `shd_auth_rule` VALUES (286, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::createTemplatePost', '', '创建邮件模板提交', '', 285, 0, '', 637, '{\"CN\":\"创建邮件模板提交\",\"HK\":\"創建郵件模板提交\",\"US\":\"Create email template submission\"}');
INSERT INTO `shd_auth_rule` VALUES (287, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::manageLanguages', '', '管理邮件模板语言', '', 531, 0, '', 638, '{\"CN\":\"管理邮件模板语言\",\"HK\":\"管理郵件模板語言\",\"US\":\"Manage Mail Template Language\"}');
INSERT INTO `shd_auth_rule` VALUES (288, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::manageLanguagesPost', '', '管理邮件模板语言页面提交', '', 287, 0, '', 639, '{\"CN\":\"管理邮件模板语言页面提交\",\"HK\":\"管理郵件模板語言頁面提交\",\"US\":\"Manage mail template language page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (289, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::disabled', '', '禁用语言', '', 287, 0, '', 640, '{\"CN\":\"禁用语言\",\"HK\":\"禁用語言\",\"US\":\"Forbidden language\"}');
INSERT INTO `shd_auth_rule` VALUES (290, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::deleteTemplate', '', '删除模板', '', 531, 0, '', 641, '{\"CN\":\"删除模板\",\"HK\":\"刪除模板\",\"US\":\"Delete template\"}');
INSERT INTO `shd_auth_rule` VALUES (291, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::editTemplate', '', '编辑邮件模板', '', 531, 0, '', 642, '{\"CN\":\"编辑邮件模板\",\"HK\":\"編輯郵件模板\",\"US\":\"Edit Email Template\"}');
INSERT INTO `shd_auth_rule` VALUES (292, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::editTemplatePost', '', '编辑邮件模板页面提交', '', 291, 0, '', 643, '{\"CN\":\"编辑邮件模板页面提交\",\"HK\":\"編輯郵件模板頁面提交\",\"US\":\"Edit email template page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (306, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController', '', '基础统计信息', '', 1329, 0, '', 821, '{\"CN\":\"基础统计信息\",\"HK\":\"基礎統計信息\",\"US\":\"Basic Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (307, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::baseInfo', '', '基础信息', '', 306, 0, '', 822, '{\"CN\":\"基础信息\",\"HK\":\"基礎信息\",\"US\":\"Basic Information\"}');
INSERT INTO `shd_auth_rule` VALUES (308, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getList', '', '工单部门', '', 1320, 1, '/work-order-dept', 322, '{\"CN\":\"工单部门\",\"HK\":\"工單部門\",\"US\":\"Ticket Department\"}');
INSERT INTO `shd_auth_rule` VALUES (309, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::addPage', '', '添加新部门', '', 308, 0, '', 328, '{\"CN\":\"添加新部门\",\"HK\":\"添加新部門\",\"US\":\"Add new department\"}');
INSERT INTO `shd_auth_rule` VALUES (310, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::add', '', '添加新部门', '', 309, 0, '', 329, '{\"CN\":\"添加新部门\",\"HK\":\"添加新部門\",\"US\":\"Add new department\"}');
INSERT INTO `shd_auth_rule` VALUES (311, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::save', '', '修改工单部门', '', 308, 0, '', 330, '{\"CN\":\"修改工单部门\",\"HK\":\"修改工單部門\",\"US\":\"Modify Ticket Department\"}');
INSERT INTO `shd_auth_rule` VALUES (312, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::delete', '', '删除工单部门', '', 308, 0, '', 333, '{\"CN\":\"删除工单部门\",\"HK\":\"刪除工單部門\",\"US\":\"Delete Ticket Department\"}');
INSERT INTO `shd_auth_rule` VALUES (313, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::moveDown', '', '向后排序', '', 311, 0, '', 331, '{\"CN\":\"向后排序\",\"HK\":\"向後排序\",\"US\":\"Sort Backward\"}');
INSERT INTO `shd_auth_rule` VALUES (314, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::moveUp', '', '向前排序', '', 311, 0, '', 332, '{\"CN\":\"向前排序\",\"HK\":\"向前排序\",\"US\":\"Sort Forward\"}');
INSERT INTO `shd_auth_rule` VALUES (315, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getList', '', '工单部门列表', '', 338, 0, '', 296, '{\"CN\":\"工单部门列表\",\"HK\":\"工單部門列表\",\"US\":\"Ticket Department List\"}');
INSERT INTO `shd_auth_rule` VALUES (316, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getDetail', '', '部门详情', '', 308, 0, '', 334, '{\"CN\":\"部门详情\",\"HK\":\"部門詳情\",\"US\":\"Department Details\"}');
INSERT INTO `shd_auth_rule` VALUES (317, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController', '', '工单状态', '', 1320, 1, '/work-order-status', 336, '{\"CN\":\"工单状态\",\"HK\":\"工單狀態\",\"US\":\"Ticket Status\"}');
INSERT INTO `shd_auth_rule` VALUES (318, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::add', '', '添加工单状态', '', 317, 0, '', 337, '{\"CN\":\"添加工单状态\",\"HK\":\"添加工單狀態\",\"US\":\"Add Ticket Status\"}');
INSERT INTO `shd_auth_rule` VALUES (319, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::save', '', '修改工单状态', '', 317, 0, '', 338, '{\"CN\":\"修改工单状态\",\"HK\":\"修改工單狀態\",\"US\":\"Modify Ticket Status\"}');
INSERT INTO `shd_auth_rule` VALUES (320, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::delete', '', '删除工单状态', '', 317, 0, '', 339, '{\"CN\":\"删除工单状态\",\"HK\":\"刪除工單狀態\",\"US\":\"Delete Ticket Status\"}');
INSERT INTO `shd_auth_rule` VALUES (321, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::getList', '', '工单状态列表', '', 0, 0, '', 850, '{\"CN\":\"工单状态列表\",\"HK\":\"工單狀態列表\",\"US\":\"Ticket Status List\"}');
INSERT INTO `shd_auth_rule` VALUES (322, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::getDetail', '', '工单状态详情', '', 317, 0, '', 340, '{\"CN\":\"工单状态详情\",\"HK\":\"工單狀態詳情\",\"US\":\"Ticket Status Details\"}');
INSERT INTO `shd_auth_rule` VALUES (323, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController', '', '预设回复', '', 1320, 0, '/preset-reply', 341, '{\"CN\":\"预设回复\",\"HK\":\"預設回复\",\"US\":\"Preset Reply\"}');
INSERT INTO `shd_auth_rule` VALUES (324, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::replyList', '', '预设回复列表', '', 323, 0, '', 342, '{\"CN\":\"预设回复列表\",\"HK\":\"預設回复列表\",\"US\":\"Preset Reply List\"}');
INSERT INTO `shd_auth_rule` VALUES (325, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::addCategory', '', '添加预设回复分类', '', 323, 0, '', 343, '{\"CN\":\"添加预设回复分类\",\"HK\":\"添加預設回複分類\",\"US\":\"Add preset reply category\"}');
INSERT INTO `shd_auth_rule` VALUES (326, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::editCategoryPage', '', '编辑预设回复分类', '', 323, 0, '', 344, '{\"CN\":\"编辑预设回复分类\",\"HK\":\"編輯預設回複分類\",\"US\":\"Edit preset reply category\"}');
INSERT INTO `shd_auth_rule` VALUES (327, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::editCategory', '', '编辑预设回复分类提交', '', 326, 0, '', 345, '{\"CN\":\"编辑预设回复分类提交\",\"HK\":\"編輯預設回複分類提交\",\"US\":\"Edit preset reply category submission\"}');
INSERT INTO `shd_auth_rule` VALUES (328, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::deleteCategory', '', '删除预设回复分类', '', 323, 0, '', 346, '{\"CN\":\"删除预设回复分类\",\"HK\":\"刪除預設回複分類\",\"US\":\"Delete preset reply category\"}');
INSERT INTO `shd_auth_rule` VALUES (329, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::addPrereplyPage', '', '添加预设回复', '', 323, 0, '', 347, '{\"CN\":\"添加预设回复\",\"HK\":\"添加預設回复\",\"US\":\"Add Canned Reply\"}');
INSERT INTO `shd_auth_rule` VALUES (330, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::addPrereply', '', '添加预设回复提交', '', 329, 0, '', 348, '{\"CN\":\"添加预设回复提交\",\"HK\":\"添加預設回复提交\",\"US\":\"Add canned response to submit\"}');
INSERT INTO `shd_auth_rule` VALUES (331, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::savePrereplyPage', '', '编辑预设回复', '', 323, 0, '', 349, '{\"CN\":\"编辑预设回复\",\"HK\":\"編輯預設回复\",\"US\":\"Edit preset reply\"}');
INSERT INTO `shd_auth_rule` VALUES (332, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::savePrereply', '', '编辑预设回复提交', '', 331, 0, '', 350, '{\"CN\":\"编辑预设回复提交\",\"HK\":\"編輯預設回复提交\",\"US\":\"Edit preset reply submission\"}');
INSERT INTO `shd_auth_rule` VALUES (333, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::searchPrereply', '', '搜索预设回复', '', 323, 0, '', 351, '{\"CN\":\"搜索预设回复\",\"HK\":\"搜索預設回复\",\"US\":\"Search for preset responses\"}');
INSERT INTO `shd_auth_rule` VALUES (334, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketPrereplyController::deletePrereply', '', '删除预设回复', '', 323, 0, '', 352, '{\"CN\":\"删除预设回复\",\"HK\":\"刪除預設回复\",\"US\":\"Delete Canned Reply\"}');
INSERT INTO `shd_auth_rule` VALUES (335, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController', '', '工单', '', 4, 1, '/support-ticket', 290, '{\"CN\":\"工单\",\"HK\":\"工單\",\"US\":\"Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (336, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::createPage', '', '新建工单', '', 335, 0, '', 292, '{\"CN\":\"新建工单\",\"HK\":\"新建工單\",\"US\":\"New Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (337, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::add', '', '新建工单提交', '', 336, 0, '', 293, '{\"CN\":\"新建工单提交\",\"HK\":\"新建工單提交\",\"US\":\"New Ticket Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (338, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::getList', '', '工单列表', '', 335, 1, '/support-ticket', 295, '{\"CN\":\"工单列表\",\"HK\":\"工單列表\",\"US\":\"Ticket List\"}');
INSERT INTO `shd_auth_rule` VALUES (339, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::getClientTicketPage', '', '获取客户工单列表', '', 338, 0, '', 298, '{\"CN\":\"获取客户工单列表\",\"HK\":\"獲取客戶工單列表\",\"US\":\"Get a list of customer tickets\"}');
INSERT INTO `shd_auth_rule` VALUES (340, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::reply', '', '回复工单', '', 351, 0, '', 303, '{\"CN\":\"回复工单\",\"HK\":\"回復工單\",\"US\":\"Respond to Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (341, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::saveReply', '', '编辑工单回复', '', 351, 0, '', 304, '{\"CN\":\"编辑工单回复\",\"HK\":\"編輯工單回复\",\"US\":\"Edit Ticket Reply\"}');
INSERT INTO `shd_auth_rule` VALUES (342, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::mergeTicket', '', '合并工单', '', 351, 0, '', 305, '{\"CN\":\"合并工单\",\"HK\":\"合併工單\",\"US\":\"Merge Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (343, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::closeTicket', '', '修改工单状态', '', 351, 0, '', 306, '{\"CN\":\"修改工单状态\",\"HK\":\"修改工單狀態\",\"US\":\"Modify Ticket Status\"}');
INSERT INTO `shd_auth_rule` VALUES (344, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::deleteTicket', '', '删除工单', '', 351, 0, '', 307, '{\"CN\":\"删除工单\",\"HK\":\"刪除工單\",\"US\":\"Delete Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (345, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::addNote', '', '添加工单备注', '', 351, 0, '', 308, '{\"CN\":\"添加工单备注\",\"HK\":\"添加工單備註\",\"US\":\"Add Ticket Remarks\"}');
INSERT INTO `shd_auth_rule` VALUES (346, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::deleteNote', '', '删除工单备注', '', 351, 0, '', 309, '{\"CN\":\"删除工单备注\",\"HK\":\"刪除工單備註\",\"US\":\"Delete Ticket Remarks\"}');
INSERT INTO `shd_auth_rule` VALUES (347, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::deleteReply', '', '删除工单回复', '', 351, 0, '', 310, '{\"CN\":\"删除工单回复\",\"HK\":\"刪除工單回复\",\"US\":\"Delete Ticket Reply\"}');
INSERT INTO `shd_auth_rule` VALUES (348, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::deleteAttachment', '', '删除附件', '', 351, 0, '', 311, '{\"CN\":\"删除附件\",\"HK\":\"刪除附件\",\"US\":\"Delete attachment\"}');
INSERT INTO `shd_auth_rule` VALUES (349, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::downloadAttachment', '', '下载附件', '', 351, 0, '', 312, '{\"CN\":\"下载附件\",\"HK\":\"下載附件\",\"US\":\"Download attachment\"}');
INSERT INTO `shd_auth_rule` VALUES (350, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketDetail', '', '工单详情', '', 335, 0, '', 301, '{\"CN\":\"工单详情\",\"HK\":\"工單詳情\",\"US\":\"Ticket Details\"}');
INSERT INTO `shd_auth_rule` VALUES (351, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::saveTicket', '', '编辑工单', '', 350, 0, '', 302, '{\"CN\":\"编辑工单\",\"HK\":\"編輯工單\",\"US\":\"Edit Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (354, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateGroupsort', '', '产品分组排序修改', '', 0, 0, '', 909, '{\"CN\":\"产品分组排序修改\",\"HK\":\"產品分組排序修改\",\"US\":\"Product grouping and sorting modification\"}');
INSERT INTO `shd_auth_rule` VALUES (355, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateProductsort', '', '产品排序修改', '', 0, 0, '', 910, '{\"CN\":\"产品排序修改\",\"HK\":\"產品排序修改\",\"US\":\"Product Sorting Modification\"}');
INSERT INTO `shd_auth_rule` VALUES (356, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editGroupPage', '', '产品分组添加/编辑', '', 1353, 0, '', 445, '{\"CN\":\"产品分组添加\\/编辑\",\"HK\":\"產品分組添加\\/編輯\",\"US\":\"Product Group Add\\/Edit\"}');
INSERT INTO `shd_auth_rule` VALUES (357, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::saveProductGroup', '', '保存产品分组信息', '', 356, 0, '', 446, '{\"CN\":\"保存产品分组信息\",\"HK\":\"保存產品分組信息\",\"US\":\"Save product group information\"}');
INSERT INTO `shd_auth_rule` VALUES (358, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::delete', '', '删除产品', '', 29, 0, '', 448, '{\"CN\":\"删除产品\",\"HK\":\"刪除產品\",\"US\":\"Delete product\"}');
INSERT INTO `shd_auth_rule` VALUES (359, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::deleteGroup', '', '删除产品组', '', 1353, 0, '', 447, '{\"CN\":\"删除产品组\",\"HK\":\"刪除產品組\",\"US\":\"Delete product group\"}');
INSERT INTO `shd_auth_rule` VALUES (360, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::duplicatePage', '', '复制产品', '', 29, 0, '', 449, '{\"CN\":\"复制产品\",\"HK\":\"複製產品\",\"US\":\"Copy product\"}');
INSERT INTO `shd_auth_rule` VALUES (361, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::duplicate', '', '复制产品', '', 360, 0, '', 450, '{\"CN\":\"复制产品\",\"HK\":\"複製產品\",\"US\":\"Copy product\"}');
INSERT INTO `shd_auth_rule` VALUES (362, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addPage', '', '产品添加', '', 29, 0, '', 451, '{\"CN\":\"产品添加\",\"HK\":\"產品添加\",\"US\":\"Product Added\"}');
INSERT INTO `shd_auth_rule` VALUES (363, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::create', '', '创建产品', '', 362, 0, '', 452, '{\"CN\":\"创建产品\",\"HK\":\"創建產品\",\"US\":\"Create Product\"}');
INSERT INTO `shd_auth_rule` VALUES (364, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editPage', '', '产品编辑', '', 29, 0, '', 453, '{\"CN\":\"产品编辑\",\"HK\":\"產品編輯\",\"US\":\"Product Editor\"}');
INSERT INTO `shd_auth_rule` VALUES (365, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::edit', '', '保存产品信息', '', 364, 0, '', 455, '{\"CN\":\"保存产品信息\",\"HK\":\"保存產品信息\",\"US\":\"Save product information\"}');
INSERT INTO `shd_auth_rule` VALUES (366, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::delCustomField', '', '删除自定义字段', '', 0, 0, '', 911, '{\"CN\":\"删除自定义字段\",\"HK\":\"刪除自定義字段\",\"US\":\"Delete custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (367, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::managedownloads', '', '关联相关下载', '', 364, 0, '', 456, '{\"CN\":\"关联相关下载\",\"HK\":\"關聯相關下載\",\"US\":\"Related Downloads\"}');
INSERT INTO `shd_auth_rule` VALUES (368, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addDownloadcats', '', '添加分类', '', 0, 0, '', 912, '{\"CN\":\"添加分类\",\"HK\":\"添加分類\",\"US\":\"Add Category\"}');
INSERT INTO `shd_auth_rule` VALUES (369, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addDownloadFlie', '', '添加文件,同时关联到产品中', '', 0, 0, '', 913, '{\"CN\":\"添加文件,同时关联到产品中\",\"HK\":\"添加文件,同時關聯到產品中\",\"US\":\"Add a file and associate it to the product at the same time\"}');
INSERT INTO `shd_auth_rule` VALUES (371, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CronController::detail', '', '自动任务详情', '', 1894, 0, '', 578, '{\"CN\":\"自动任务详情\",\"HK\":\"自動任務詳情\",\"US\":\"Automatic task details\"}');
INSERT INTO `shd_auth_rule` VALUES (372, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CronController::saveCron', '', '编辑自动任务', '', 1894, 0, '', 579, '{\"CN\":\"编辑自动任务\",\"HK\":\"編輯自動任務\",\"US\":\"Edit Auto Task\"}');
INSERT INTO `shd_auth_rule` VALUES (389, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::searchPage', '', '搜索', '', 390, 0, '', 135, '{\"CN\":\"搜索\",\"HK\":\"搜索\",\"US\":\"Search\"}');
INSERT INTO `shd_auth_rule` VALUES (390, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::index', '', '订单列表', '', 15, 0, '', 132, '{\"CN\":\"订单列表\",\"HK\":\"訂單列表\",\"US\":\"Order List\"}');
INSERT INTO `shd_auth_rule` VALUES (391, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::check', '', '订单审核', '', 398, 0, '', 140, '{\"CN\":\"订单审核\",\"HK\":\"訂單審核\",\"US\":\"Order Review\"}');
INSERT INTO `shd_auth_rule` VALUES (392, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::cancel', '', '取消订单', '', 398, 0, '', 141, '{\"CN\":\"取消订单\",\"HK\":\"取消訂單\",\"US\":\"Cancel order\"}');
INSERT INTO `shd_auth_rule` VALUES (393, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::delete', '', '删除订单', '', 15, 0, '', 136, '{\"CN\":\"删除订单\",\"HK\":\"刪除訂單\",\"US\":\"Delete Order\"}');
INSERT INTO `shd_auth_rule` VALUES (395, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::setConfig', '', '选择配置', '', 14, 0, '', 127, '{\"CN\":\"选择配置\",\"HK\":\"選擇配置\",\"US\":\"Select Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (396, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::getMultiTotal', '', '多产品--异步请求计算总价', '', 14, 0, '', 128, '{\"CN\":\"多产品--异步请求计算总价\",\"HK\":\"多產品--異步請求計算總價\",\"US\":\"Multi-product-asynchronous request to calculate total price\"}');
INSERT INTO `shd_auth_rule` VALUES (398, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::read', '', '订单详情', '', 15, 0, '', 137, '{\"CN\":\"订单详情\",\"HK\":\"訂單詳情\",\"US\":\"Order Details\"}');
INSERT INTO `shd_auth_rule` VALUES (399, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::notes', '', '添加备注', '', 0, 0, '', 914, '{\"CN\":\"添加备注\",\"HK\":\"添加備註\",\"US\":\"Add Remarks\"}');
INSERT INTO `shd_auth_rule` VALUES (400, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::active', '', '审核通过', '', 0, 0, '', 915, '{\"CN\":\"审核通过\",\"HK\":\"審核通過\",\"US\":\"Approved\"}');
INSERT INTO `shd_auth_rule` VALUES (401, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::customPromoPage', '', '创建定制优惠码', '', 14, 0, '', 129, '{\"CN\":\"创建定制优惠码\",\"HK\":\"創建定制優惠碼\",\"US\":\"Create a custom coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (402, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::customPromo', '', '创建定制优惠码', '', 401, 0, '', 130, '{\"CN\":\"创建定制优惠码\",\"HK\":\"創建定制優惠碼\",\"US\":\"Create a custom coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (404, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController', '', '账单列表', '', 408, 0, '', 230, '{\"CN\":\"账单列表\",\"HK\":\"賬單列表\",\"US\":\"Bill List\"}');
INSERT INTO `shd_auth_rule` VALUES (405, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController', '', '交易流水', '', 1868, 1, '/business-statement', 192, '{\"CN\":\"交易流水\",\"HK\":\"交易流水\",\"US\":\"Trading Flow\"}');
INSERT INTO `shd_auth_rule` VALUES (406, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::searchPage', '', '交易流水列表搜索', '', 1344, 0, '', 194, '{\"CN\":\"交易流水列表搜索\",\"HK\":\"交易流水列表搜索\",\"US\":\"Search for Transaction Flow List\"}');
INSERT INTO `shd_auth_rule` VALUES (407, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::index', '', '交易流水列表', '', 1344, 0, '', 195, '{\"CN\":\"交易流水列表\",\"HK\":\"交易流水列表\",\"US\":\"Transaction Flow List\"}');
INSERT INTO `shd_auth_rule` VALUES (408, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController', '', '账单管理', '', 1868, 1, '/bill-management', 204, '{\"CN\":\"账单管理\",\"HK\":\"賬單管理\",\"US\":\"Bill Management\"}');
INSERT INTO `shd_auth_rule` VALUES (409, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::save', '', '添加交易流水', '', 1453, 0, '', 202, '{\"CN\":\"添加交易流水\",\"HK\":\"添加交易流水\",\"US\":\"Add transaction flow\"}');
INSERT INTO `shd_auth_rule` VALUES (410, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::read', '', '交易流水详情', '', 405, 0, '', 196, '{\"CN\":\"交易流水详情\",\"HK\":\"交易流水詳情\",\"US\":\"Transaction Flow Details\"}');
INSERT INTO `shd_auth_rule` VALUES (411, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController', '', '编辑交易流水', '', 405, 0, '', 197, '{\"CN\":\"编辑交易流水\",\"HK\":\"編輯交易流水\",\"US\":\"Edit transaction flow\"}');
INSERT INTO `shd_auth_rule` VALUES (412, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::delete', '', '删除交易流水', '', 405, 0, '', 200, '{\"CN\":\"删除交易流水\",\"HK\":\"刪除交易流水\",\"US\":\"Delete transaction flow\"}');
INSERT INTO `shd_auth_rule` VALUES (413, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::index', '', '余额管理', '', 1332, 0, '', 18, '{\"CN\":\"余额管理\",\"HK\":\"餘額管理\",\"US\":\"Balance Management\"}');
INSERT INTO `shd_auth_rule` VALUES (414, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::index', '', '用户余额列表', '', 413, 0, '', 19, '{\"CN\":\"用户余额列表\",\"HK\":\"用戶餘額列表\",\"US\":\"User Balance List\"}');
INSERT INTO `shd_auth_rule` VALUES (415, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::save', '', '添加编辑余额', '', 413, 0, '', 20, '{\"CN\":\"添加编辑余额\",\"HK\":\"添加編輯餘額\",\"US\":\"Add Edit Balance\"}');
INSERT INTO `shd_auth_rule` VALUES (416, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::read', '', '余额详情', '', 413, 0, '', 21, '{\"CN\":\"余额详情\",\"HK\":\"餘額詳情\",\"US\":\"Balance Details\"}');
INSERT INTO `shd_auth_rule` VALUES (417, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::update', '', '更新余额', '', 413, 0, '', 22, '{\"CN\":\"更新余额\",\"HK\":\"更新余額\",\"US\":\"Update balance\"}');
INSERT INTO `shd_auth_rule` VALUES (418, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::reduce', '', '减少余额', '', 413, 0, '', 23, '{\"CN\":\"减少余额\",\"HK\":\"減少餘額\",\"US\":\"Decrease balance\"}');
INSERT INTO `shd_auth_rule` VALUES (419, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditController::delete', '', '删除余额', '', 413, 0, '', 24, '{\"CN\":\"删除余额\",\"HK\":\"刪除餘額\",\"US\":\"Delete balance\"}');
INSERT INTO `shd_auth_rule` VALUES (420, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller', '', '文件下载', '', 8, 1, '/service-support', 524, '{\"CN\":\"文件下载\",\"HK\":\"文件下載\",\"US\":\"File Download\"}');
INSERT INTO `shd_auth_rule` VALUES (423, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getCatData', '', '获取分类id数据', '', 519, 0, '', 555, '{\"CN\":\"获取分类id数据\",\"HK\":\"獲取分類id數據\",\"US\":\"Get classification id data\"}');
INSERT INTO `shd_auth_rule` VALUES (424, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::postEditCat', '', '添加/编辑分类', '', 519, 0, '', 556, '{\"CN\":\"添加\\/编辑分类\",\"HK\":\"添加\\/編輯分類\",\"US\":\"Add\\/Edit Category\"}');
INSERT INTO `shd_auth_rule` VALUES (425, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::deleteCat', '', '删除分类', '', 519, 0, '', 557, '{\"CN\":\"删除分类\",\"HK\":\"刪除分類\",\"US\":\"Delete category\"}');
INSERT INTO `shd_auth_rule` VALUES (426, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getContent', '', '编辑新闻页面数据', '', 518, 0, '', 549, '{\"CN\":\"编辑新闻页面数据\",\"HK\":\"編輯新聞頁面數據\",\"US\":\"Edit news page data\"}');
INSERT INTO `shd_auth_rule` VALUES (427, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::postEditContent', '', '添加/编辑新闻', '', 518, 0, '', 551, '{\"CN\":\"添加\\/编辑新闻\",\"HK\":\"添加\\/編輯新聞\",\"US\":\"Add\\/Edit News\"}');
INSERT INTO `shd_auth_rule` VALUES (428, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::deleteContent', '', '删除新闻', '', 518, 0, '', 552, '{\"CN\":\"删除新闻\",\"HK\":\"刪除新聞\",\"US\":\"Delete News\"}');
INSERT INTO `shd_auth_rule` VALUES (429, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController', '', '后台产品', '', 0, 0, '', 918, '{\"CN\":\"后台产品\",\"HK\":\"後台產品\",\"US\":\"Background Product\"}');
INSERT INTO `shd_auth_rule` VALUES (430, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::index', '', '查看产品/服务详情页', '', 28, 0, '', 168, '{\"CN\":\"查看产品\\/服务详情页\",\"HK\":\"查看產品\\/服務詳情頁\",\"US\":\"View product\\/service details page\"}');
INSERT INTO `shd_auth_rule` VALUES (431, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::postInfo', '', '编辑产品/服务', '', 28, 0, '', 171, '{\"CN\":\"编辑产品\\/服务\",\"HK\":\"編輯產品\\/服務\",\"US\":\"Edit product\\/service\"}');
INSERT INTO `shd_auth_rule` VALUES (432, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::postTransfer', '', '转移产品/服务', '', 28, 0, '', 172, '{\"CN\":\"转移产品\\/服务\",\"HK\":\"轉移產品\\/服務\",\"US\":\"Transfer Products\\/Services\"}');
INSERT INTO `shd_auth_rule` VALUES (433, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::deleteHost', '', '删除产品/服务', '', 28, 0, '', 173, '{\"CN\":\"删除产品\\/服务\",\"HK\":\"刪除產品\\/服務\",\"US\":\"Delete product\\/service\"}');
INSERT INTO `shd_auth_rule` VALUES (434, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::postSearchClient', '', '搜索用户', '', 0, 0, '', 919, '{\"CN\":\"搜索用户\",\"HK\":\"搜索用戶\",\"US\":\"Search User\"}');
INSERT INTO `shd_auth_rule` VALUES (435, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::upgradeconfig', '', '升降级配置', '', 28, 0, '', 176, '{\"CN\":\"升降级配置\",\"HK\":\"升降級配置\",\"US\":\"Upgrade and Downgrade Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (439, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plIndex', '', '模块插件', '', 1898, 0, '/module-plugin', 795, '{\"CN\":\"模块插件\",\"HK\":\"模塊插件\",\"US\":\"Module Plug-in\"}');
INSERT INTO `shd_auth_rule` VALUES (440, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController::getList', '', '产品/服务', '', 0, 0, '', 928, '{\"CN\":\"产品\\/服务\",\"HK\":\"產品\\/服務\",\"US\":\"Product\\/Service\"}');
INSERT INTO `shd_auth_rule` VALUES (441, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageController', '', '批量发送邮件', '', 590, 0, '', 894, '{\"CN\":\"批量发送邮件\",\"HK\":\"批量發送郵件\",\"US\":\"Send emails in bulk\"}');
INSERT INTO `shd_auth_rule` VALUES (442, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageController::postEmailPage', '', '发送邮件页面数据', '', 441, 0, '', 895, '{\"CN\":\"发送邮件页面数据\",\"HK\":\"發送郵件頁面數據\",\"US\":\"Send mail page data\"}');
INSERT INTO `shd_auth_rule` VALUES (443, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageController::postSendEmail', '', '发送邮件接口', '', 441, 0, '', 896, '{\"CN\":\"发送邮件接口\",\"HK\":\"發送郵件接口\",\"US\":\"Send Mail Interface\"}');
INSERT INTO `shd_auth_rule` VALUES (446, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getSecondVerify', '', '二次验证', '', 1914, 0, '/second', 667, '{\"CN\":\"二次验证\",\"HK\":\"二次驗證\",\"US\":\"Secondary Verification\"}');
INSERT INTO `shd_auth_rule` VALUES (447, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postSecondVerify', '', '二次验证设置', '', 446, 0, '', 668, '{\"CN\":\"二次验证设置\",\"HK\":\"二次驗證設置\",\"US\":\"Secondary Verification Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (448, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController', '', '客户分组与折扣', '', 1901, 1, '/customer-group', 100, '{\"CN\":\"客户分组与折扣\",\"HK\":\"客戶分組與折扣\",\"US\":\"Customer Grouping and Discount\"}');
INSERT INTO `shd_auth_rule` VALUES (450, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController::save', '', '添加客户分组', '', 448, 0, '', 102, '{\"CN\":\"添加客户分组\",\"HK\":\"添加客戶分組\",\"US\":\"Add customer group\"}');
INSERT INTO `shd_auth_rule` VALUES (451, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController::read', '', '组详情', '', 0, 0, '', 929, '{\"CN\":\"组详情\",\"HK\":\"組詳情\",\"US\":\"Group Details\"}');
INSERT INTO `shd_auth_rule` VALUES (452, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController::update', '', '编辑客户分组', '', 448, 0, '', 103, '{\"CN\":\"编辑客户分组\",\"HK\":\"編輯客戶分組\",\"US\":\"Edit Customer Group\"}');
INSERT INTO `shd_auth_rule` VALUES (453, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController::delete', '', '删除客户分组', '', 448, 0, '', 104, '{\"CN\":\"删除客户分组\",\"HK\":\"刪除客戶分組\",\"US\":\"Delete Customer Group\"}');
INSERT INTO `shd_auth_rule` VALUES (454, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller', '', '实名设置', '', 1901, 1, '/authentication-setting', 105, '{\"CN\":\"实名设置\",\"HK\":\"實名設置\",\"US\":\"Identity verification\"}');
INSERT INTO `shd_auth_rule` VALUES (457, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::certifiIndex', '', '实名认证配置', '', 0, 0, '', 932, '{\"CN\":\"实名认证配置\",\"HK\":\"實名認證配置\",\"US\":\"Real-name authentication configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (458, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::certifiIndexPost', '', '实名认证配置页面提交', '', 0, 0, '', 933, '{\"CN\":\"实名认证配置页面提交\",\"HK\":\"實名認證配置頁面提交\",\"US\":\"Submit the real-name authentication configuration page\"}');
INSERT INTO `shd_auth_rule` VALUES (462, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getGeneral', '', '常规设置', '', 1910, 1, '/general-settings/general', 573, '{\"CN\":\"常规设置\",\"HK\":\"常規設置\",\"US\":\"General Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (463, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postGeneral', '', '常规设置页面提交', '', 462, 0, '', 575, '{\"CN\":\"常规设置页面提交\",\"HK\":\"常規設置頁面提交\",\"US\":\"General settings page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (465, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postLocal', '', '常规设置-本地化页面提交', '', 0, 0, '', 934, '{\"CN\":\"常规设置-本地化页面提交\",\"HK\":\"常規設置-本地化頁面提交\",\"US\":\"General Settings-Localized Page Submission\"}');
INSERT INTO `shd_auth_rule` VALUES (466, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getSupport', '', '常规设置页面-支持', '', 0, 0, '', 935, '{\"CN\":\"常规设置页面-支持\",\"HK\":\"常規設置頁面-支持\",\"US\":\"General Settings Page-Support\"}');
INSERT INTO `shd_auth_rule` VALUES (467, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postSupport', '', '常规设置-支持页面提交', '', 0, 0, '', 936, '{\"CN\":\"常规设置-支持页面提交\",\"HK\":\"常規設置-支持頁面提交\",\"US\":\"General Settings-Support Page Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (469, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postAffiliate', '', '常规设置-推介页面提交', '', 1680, 0, '', 94, '{\"CN\":\"常规设置-推介页面提交\",\"HK\":\"常規設置-推介頁面提交\",\"US\":\"General Settings-Referral Page Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (470, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getSafe', '', '常规设置页面-安全', '', 0, 0, '', 938, '{\"CN\":\"常规设置页面-安全\",\"HK\":\"常規設置頁面-安全\",\"US\":\"General Settings Page-Security\"}');
INSERT INTO `shd_auth_rule` VALUES (471, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postSafe', '', '常规设置-安全页面提交', '', 0, 0, '', 939, '{\"CN\":\"常规设置-安全页面提交\",\"HK\":\"常規設置-安全頁面提交\",\"US\":\"General Settings-Secure Page Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (472, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getOther', '', '常规设置页面-其他', '', 0, 0, '', 940, '{\"CN\":\"常规设置页面-其他\",\"HK\":\"常規設置頁面-其他\",\"US\":\"General Settings Page-Other\"}');
INSERT INTO `shd_auth_rule` VALUES (473, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postOther', '', '常规设置-其他页面提交', '', 0, 0, '', 941, '{\"CN\":\"常规设置-其他页面提交\",\"HK\":\"常規設置-其他頁面提交\",\"US\":\"General Settings-Other Page Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (476, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getInvoice', '', '常规设置-账单', '', 0, 0, '', 942, '{\"CN\":\"常规设置-账单\",\"HK\":\"常規設置-賬單\",\"US\":\"General Settings-Billing\"}');
INSERT INTO `shd_auth_rule` VALUES (479, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getInfo', '', '系统升级', '', 1915, 1, '/system-message', 676, '{\"CN\":\"系统升级\",\"HK\":\"系統升級\",\"US\":\"System Upgrade\"}');
INSERT INTO `shd_auth_rule` VALUES (480, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getPhpInfo', '', 'php信息', '', 1915, 1, '/php-message', 677, '{\"CN\":\"php信息\",\"HK\":\"php信息\",\"US\":\"php information\"}');
INSERT INTO `shd_auth_rule` VALUES (481, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController', '', '数据库状态', '', 2102, 1, '/database-message', 702, '{\"CN\":\"数据库状态\",\"HK\":\"數據庫狀態\",\"US\":\"Database Status\"}');
INSERT INTO `shd_auth_rule` VALUES (482, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::postOptimizeTables', '', '优化数据表', '', 481, 0, '', 704, '{\"CN\":\"优化数据表\",\"HK\":\"優化數據表\",\"US\":\"Optimized Data Table\"}');
INSERT INTO `shd_auth_rule` VALUES (483, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::postDownDataBackup', '', '下载数据库备份', '', 481, 0, '', 705, '{\"CN\":\"下载数据库备份\",\"HK\":\"下載數據庫備份\",\"US\":\"Download database backup\"}');
INSERT INTO `shd_auth_rule` VALUES (485, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getSystemLog', '', '系统日志', '', 1916, 1, '/system-log', 689, '{\"CN\":\"系统日志\",\"HK\":\"系統日誌\",\"US\":\"System Log\"}');
INSERT INTO `shd_auth_rule` VALUES (486, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getAdminLog', '', '管理员登录日志', '', 1916, 1, '/system-admin-log', 690, '{\"CN\":\"管理员登录日志\",\"HK\":\"管理員登錄日誌\",\"US\":\"Administrator Login Log\"}');
INSERT INTO `shd_auth_rule` VALUES (488, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getEmailLog', '', '邮件日志', '', 1916, 1, '/email-log', 691, '{\"CN\":\"邮件日志\",\"HK\":\"郵件日誌\",\"US\":\"Mail Log\"}');
INSERT INTO `shd_auth_rule` VALUES (489, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getEmailDetail', '', '查看邮件信息', '', 488, 0, '', 692, '{\"CN\":\"查看邮件信息\",\"HK\":\"查看郵件信息\",\"US\":\"View Mail Information\"}');
INSERT INTO `shd_auth_rule` VALUES (495, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plIndex', '', '插件列表', '', 439, 0, '', 796, '{\"CN\":\"插件列表\",\"HK\":\"插件列表\",\"US\":\"Plugin List\"}');
INSERT INTO `shd_auth_rule` VALUES (496, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plInstall', '', '插件安装', '', 439, 0, '', 797, '{\"CN\":\"插件安装\",\"HK\":\"插件安裝\",\"US\":\"Plugin Installation\"}');
INSERT INTO `shd_auth_rule` VALUES (497, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plUninstall', '', '插件卸载', '', 439, 0, '', 798, '{\"CN\":\"插件卸载\",\"HK\":\"插件卸載\",\"US\":\"Plugin Uninstallation\"}');
INSERT INTO `shd_auth_rule` VALUES (498, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plToggle', '', '禁用(启用)插件', '', 439, 0, '', 799, '{\"CN\":\"禁用(启用)插件\",\"HK\":\"禁用(啟用)插件\",\"US\":\"Disable (enable) plugins\"}');
INSERT INTO `shd_auth_rule` VALUES (499, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSetting', '', '配置插件', '', 439, 0, '', 800, '{\"CN\":\"配置插件\",\"HK\":\"配置插件\",\"US\":\"Configure Plugin\"}');
INSERT INTO `shd_auth_rule` VALUES (500, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSettingPost', '', '保存插件配置', '', 499, 0, '', 801, '{\"CN\":\"保存插件配置\",\"HK\":\"保存插件配置\",\"US\":\"Save plugin configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (501, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plUpdate', '', '插件更新', '', 439, 0, '', 802, '{\"CN\":\"插件更新\",\"HK\":\"插件更新\",\"US\":\"Plugin Update\"}');
INSERT INTO `shd_auth_rule` VALUES (502, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController', '', '后台服务模块', '', 590, 0, '', 900, '{\"CN\":\"后台服务模块\",\"HK\":\"後台服務模塊\",\"US\":\"Background Service Module\"}');
INSERT INTO `shd_auth_rule` VALUES (503, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::getModules', '', '获取所有模块', '', 502, 0, '', 901, '{\"CN\":\"获取所有模块\",\"HK\":\"獲取所有模塊\",\"US\":\"Get all modules\"}');
INSERT INTO `shd_auth_rule` VALUES (504, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::getMetaData', '', '获取模块metadata', '', 502, 0, '', 902, '{\"CN\":\"获取模块metadata\",\"HK\":\"獲取模塊metadata\",\"US\":\"Get module metadata\"}');
INSERT INTO `shd_auth_rule` VALUES (505, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::getModuleConfig', '', '获取模块设置', '', 502, 0, '', 903, '{\"CN\":\"获取模块设置\",\"HK\":\"獲取模塊設置\",\"US\":\"Get Module Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (506, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::execute', '', '执行开通,暂停,解除暂停,删除,修改密码', '', 502, 0, '', 904, '{\"CN\":\"执行开通,暂停,解除暂停,删除,修改密码\",\"HK\":\"執行開通,暫停,解除暫停,刪除,修改密碼\",\"US\":\"Execute activation, suspension, release suspension, delete, change password\"}');
INSERT INTO `shd_auth_rule` VALUES (507, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::execAdmin', '', '执行模块自定义方法', '', 502, 0, '', 905, '{\"CN\":\"执行模块自定义方法\",\"HK\":\"執行模塊自定義方法\",\"US\":\"Execute module custom method\"}');
INSERT INTO `shd_auth_rule` VALUES (512, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController', '', '自定义客户字段', '', 1901, 1, '/customer-custom', 88, '{\"CN\":\"自定义客户字段\",\"HK\":\"自定義客戶字段\",\"US\":\"Custom Customer Field\"}');
INSERT INTO `shd_auth_rule` VALUES (516, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CancelRequestController', '', '取消续费', '', 0, 0, '/cancel-request', 804, '{\"CN\":\"取消续费\",\"HK\":\"取消續費\",\"US\":\"Cancel renewal\"}');
INSERT INTO `shd_auth_rule` VALUES (518, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getList', '', '新闻列表', '', 1316, 1, '/news-list', 547, '{\"CN\":\"新闻列表\",\"HK\":\"新聞列表\",\"US\":\"News List\"}');
INSERT INTO `shd_auth_rule` VALUES (519, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getCatsPage', '', '新闻分类', '', 1316, 1, '/news-category', 553, '{\"CN\":\"新闻分类\",\"HK\":\"新聞分類\",\"US\":\"News Category\"}');
INSERT INTO `shd_auth_rule` VALUES (524, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getProuductlistPage', '', '商品设置', '', 18, 0, '/product-server', 362, '{\"CN\":\"商品设置\",\"HK\":\"商品設置\",\"US\":\"Commodity Setting\"}');
INSERT INTO `shd_auth_rule` VALUES (525, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '全局产品配置', '', 18, 0, '/configurable-option', 376, '{\"CN\":\"全局产品配置\",\"HK\":\"全局產品配置\",\"US\":\"Global Product Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (526, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '可配置选项', '', 18, 0, '/configurable-option', 377, '{\"CN\":\"可配置选项\",\"HK\":\"可配置選項\",\"US\":\"Configurable Options\"}');
INSERT INTO `shd_auth_rule` VALUES (527, 1, 'admin', 'admin_url', '', '', '接口设置', '', 5, 0, '', 430, '{\"CN\":\"接口设置\",\"HK\":\"接口設置\",\"US\":\"Interface Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (528, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::serverList', '', '通用接口', '', 1876, 1, '/server-settings', 399, '{\"CN\":\"通用接口\",\"HK\":\"通用接口\",\"US\":\"Universal Interface\"}');
INSERT INTO `shd_auth_rule` VALUES (530, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::configMobile', '', '接口设置', '', 1913, 1, '/sms-template/sms', 627, '{\"CN\":\"接口设置\",\"HK\":\"接口設置\",\"US\":\"Interface Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (531, 1, 'admin', 'admin_url', 'app\\admin\\controller\\EmailTemplateController::emailList', '', '邮件模板', '', 1913, 1, '/email-list', 634, '{\"CN\":\"邮件模板\",\"HK\":\"郵件模板\",\"US\":\"Mail Template\"}');
INSERT INTO `shd_auth_rule` VALUES (533, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::templateList', '', '短信模板', '', 1913, 1, '/sms-template-index', 647, '{\"CN\":\"短信模板\",\"HK\":\"短信模板\",\"US\":\"SMS template\"}');
INSERT INTO `shd_auth_rule` VALUES (536, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::SetSmsTemplate', '', '发送设置', '', 1913, 1, '/sms-send-settings', 660, '{\"CN\":\"发送设置\",\"HK\":\"發送設置\",\"US\":\"Send Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (542, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller', '', '实名认证', '', 1860, 1, '/customer-authentication', 34, '{\"CN\":\"实名认证\",\"HK\":\"實名認證\",\"US\":\"Real-name authentication\"}');
INSERT INTO `shd_auth_rule` VALUES (555, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::hostRenew', '', '续费', '', 28, 0, '', 149, '{\"CN\":\"续费\",\"HK\":\"續費\",\"US\":\"Renewal\"}');
INSERT INTO `shd_auth_rule` VALUES (557, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::type', '', '获取认证类型', '', 1336, 0, '', 107, '{\"CN\":\"获取认证类型\",\"HK\":\"獲取認證類型\",\"US\":\"Obtain authentication type\"}');
INSERT INTO `shd_auth_rule` VALUES (558, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::alipay_biz_code', '', '获取阿里认证类型', '', 1336, 0, '', 108, '{\"CN\":\"获取阿里认证类型\",\"HK\":\"獲取阿里認證類型\",\"US\":\"Get Ali certification type\"}');
INSERT INTO `shd_auth_rule` VALUES (559, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::registerlogin', '', '注册登录提交', '', 0, 0, '', 817, '{\"CN\":\"注册登录提交\",\"HK\":\"註冊登錄提交\",\"US\":\"Registration Login Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (560, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::postrecharge', '', '常规设置-充值页面-提交', '', 0, 0, '', 818, '{\"CN\":\"常规设置-充值页面-提交\",\"HK\":\"常規設置-充值頁面-提交\",\"US\":\"General Settings-Top Up Page-Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (561, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::postinvoice', '', '常规设置-账单页面-提交', '', 476, 0, '', 943, '{\"CN\":\"常规设置-账单页面-提交\",\"HK\":\"常規設置-賬單頁面-提交\",\"US\":\"General Settings-Billing Page-Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (562, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CancelRequestcontroller::getlist', '', '待审核取消请求', '', 516, 0, '', 805, '{\"CN\":\"待审核取消请求\",\"HK\":\"待審核取消請求\",\"US\":\"Pending review cancellation request\"}');
INSERT INTO `shd_auth_rule` VALUES (563, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CancelRequestcontroller::getcancellist', '', '已审核取消请求', '', 516, 0, '', 806, '{\"CN\":\"已审核取消请求\",\"HK\":\"已審核取消請求\",\"US\":\"Cancellation request has been reviewed\"}');
INSERT INTO `shd_auth_rule` VALUES (564, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifistatus', '', '修改认证状态', '', 542, 0, '', 38, '{\"CN\":\"修改认证状态\",\"HK\":\"修改認證狀態\",\"US\":\"Modify authentication status\"}');
INSERT INTO `shd_auth_rule` VALUES (566, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::edititem', '', '编辑账单摘要', '', 1342, 0, '', 224, '{\"CN\":\"编辑账单摘要\",\"HK\":\"編輯賬單摘要\",\"US\":\"Edit Bill Summary\"}');
INSERT INTO `shd_auth_rule` VALUES (588, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::index', '', '分组权限', '', 1912, 1, '/permissions-managment', 593, '{\"CN\":\"分组权限\",\"HK\":\"分組權限\",\"US\":\"Group Permission\"}');
INSERT INTO `shd_auth_rule` VALUES (590, 1, 'admin', 'admin_url', '', '', '其他权限', '', 0, 0, '', 851, '{\"CN\":\"其他权限\",\"HK\":\"其他權限\",\"US\":\"Other permissions\"}');
INSERT INTO `shd_auth_rule` VALUES (591, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Newscontroller::getCateList', '', '新闻分类所有数据', '', 426, 0, '', 550, '{\"CN\":\"新闻分类所有数据\",\"HK\":\"新聞分類所有數據\",\"US\":\"All data of news classification\"}');
INSERT INTO `shd_auth_rule` VALUES (592, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Ordercontroller::checkProduct', '', '验证', '', 0, 0, '', 906, '{\"CN\":\"验证\",\"HK\":\"驗證\",\"US\":\"Verify\"}');
INSERT INTO `shd_auth_rule` VALUES (600, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Announcecontroller::getList', '', '站点公告列表数据', '', 604, 0, '', 867, '{\"CN\":\"站点公告列表数据\",\"HK\":\"站點公告列表數據\",\"US\":\"Site announcement list data\"}');
INSERT INTO `shd_auth_rule` VALUES (601, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Announcecontroller::deleteList', '', '删除站点公告', '', 604, 0, '', 868, '{\"CN\":\"删除站点公告\",\"HK\":\"刪除站點公告\",\"US\":\"Delete site announcement\"}');
INSERT INTO `shd_auth_rule` VALUES (602, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Announcecontroller::getManage', '', '公告内页数据', '', 604, 0, '', 869, '{\"CN\":\"公告内页数据\",\"HK\":\"公告內頁數據\",\"US\":\"Announcement Inner Page Data\"}');
INSERT INTO `shd_auth_rule` VALUES (603, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Announcecontroller::postSave', '', '保存公告', '', 604, 0, '', 870, '{\"CN\":\"保存公告\",\"HK\":\"保存公告\",\"US\":\"Save Announcement\"}');
INSERT INTO `shd_auth_rule` VALUES (604, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Announcecontroller', '', '站点公告', '', 590, 0, '', 866, '{\"CN\":\"站点公告\",\"HK\":\"站點公告\",\"US\":\"Site Notice\"}');
INSERT INTO `shd_auth_rule` VALUES (855, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CancelRequestcontroller::deleteList', '', '删除取消请求', '', 516, 0, '', 807, '{\"CN\":\"删除取消请求\",\"HK\":\"刪除取消請求\",\"US\":\"Delete cancellation request\"}');
INSERT INTO `shd_auth_rule` VALUES (887, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::update', '', '修改实名认证设置', '', 454, 0, '', 111, '{\"CN\":\"修改实名认证设置\",\"HK\":\"修改實名認證設置\",\"US\":\"Modify real-name authentication settings\"}');
INSERT INTO `shd_auth_rule` VALUES (922, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController', '', '后台合同模块', '', 590, 0, '', 871, '{\"CN\":\"后台合同模块\",\"HK\":\"後台合同模塊\",\"US\":\"Background contract module\"}');
INSERT INTO `shd_auth_rule` VALUES (984, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::addServer', '', '添加接口', '', 1813, 0, '', 415, '{\"CN\":\"添加接口\",\"HK\":\"添加接口\",\"US\":\"Add interface\"}');
INSERT INTO `shd_auth_rule` VALUES (985, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::editServer', '', '编辑接口', '', 1813, 0, '', 416, '{\"CN\":\"编辑接口\",\"HK\":\"編輯接口\",\"US\":\"Edit Interface\"}');
INSERT INTO `shd_auth_rule` VALUES (986, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::serverDetail', '', '接口详情', '', 1813, 0, '', 417, '{\"CN\":\"接口详情\",\"HK\":\"接口詳情\",\"US\":\"Interface Details\"}');
INSERT INTO `shd_auth_rule` VALUES (987, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::delServer', '', '删除接口', '', 1813, 0, '', 418, '{\"CN\":\"删除接口\",\"HK\":\"刪除接口\",\"US\":\"Delete interface\"}');
INSERT INTO `shd_auth_rule` VALUES (989, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::refreshServerStatus', '', '获取服务器状态', '', 1813, 0, '', 419, '{\"CN\":\"获取服务器状态\",\"HK\":\"獲取服務器狀態\",\"US\":\"Get server status\"}');
INSERT INTO `shd_auth_rule` VALUES (990, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::refreshAllServerStatus', '', '刷新所有服务器状态', '', 0, 0, '', 944, '{\"CN\":\"刷新所有服务器状态\",\"HK\":\"刷新所有服務器狀態\",\"US\":\"Refresh all server status\"}');
INSERT INTO `shd_auth_rule` VALUES (992, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::delRecord', '', '删除购买记录', '', 27, 0, '', 146, '{\"CN\":\"删除购买记录\",\"HK\":\"刪除購買記錄\",\"US\":\"Delete Purchase Record\"}');
INSERT INTO `shd_auth_rule` VALUES (994, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::addFlowPacketPage', '', '添加流量包', '', 19, 0, '', 393, '{\"CN\":\"添加流量包\",\"HK\":\"添加流量包\",\"US\":\"Add Traffic Package\"}');
INSERT INTO `shd_auth_rule` VALUES (995, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::editFlowPacketPage', '', '修改流量包', '', 19, 0, '', 395, '{\"CN\":\"修改流量包\",\"HK\":\"修改流量包\",\"US\":\"Modify Traffic Package\"}');
INSERT INTO `shd_auth_rule` VALUES (996, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::addFlowPacket', '', '添加流量包', '', 994, 0, '', 394, '{\"CN\":\"添加流量包\",\"HK\":\"添加流量包\",\"US\":\"Add Traffic Package\"}');
INSERT INTO `shd_auth_rule` VALUES (997, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::editFlowPacket', '', '修改流量包', '', 995, 0, '', 396, '{\"CN\":\"修改流量包\",\"HK\":\"修改流量包\",\"US\":\"Modify Traffic Package\"}');
INSERT INTO `shd_auth_rule` VALUES (998, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::delFlowPacket', '', '删除流量包', '', 19, 0, '', 397, '{\"CN\":\"删除流量包\",\"HK\":\"刪除流量包\",\"US\":\"Delete traffic package\"}');
INSERT INTO `shd_auth_rule` VALUES (999, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::suspendPage', '', '暂停', '', 1397, 0, '', 156, '{\"CN\":\"暂停\",\"HK\":\"暫停\",\"US\":\"Pause\"}');
INSERT INTO `shd_auth_rule` VALUES (1000, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::execute', '', '解除暂停', '', 1397, 0, '', 158, '{\"CN\":\"解除暂停\",\"HK\":\"解除暫停\",\"US\":\"Unsuspend\"}');
INSERT INTO `shd_auth_rule` VALUES (1001, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::execute', '', '删除', '', 1397, 0, '', 159, '{\"CN\":\"删除\",\"HK\":\"刪除\",\"US\":\"Delete\"}');
INSERT INTO `shd_auth_rule` VALUES (1002, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::on', '', '开机', '', 1397, 0, '', 160, '{\"CN\":\"开机\",\"HK\":\"開機\",\"US\":\"Turn on\"}');
INSERT INTO `shd_auth_rule` VALUES (1003, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::off', '', '关机', '', 1397, 0, '', 161, '{\"CN\":\"关机\",\"HK\":\"關機\",\"US\":\"Shutdown\"}');
INSERT INTO `shd_auth_rule` VALUES (1004, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::reboot', '', '重启', '', 1397, 0, '', 162, '{\"CN\":\"重启\",\"HK\":\"重啟\",\"US\":\"Restart\"}');
INSERT INTO `shd_auth_rule` VALUES (1005, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::download', '', '下载java文件', '', 0, 0, '', 947, '{\"CN\":\"下载java文件\",\"HK\":\"下載java文件\",\"US\":\"Download java file\"}');
INSERT INTO `shd_auth_rule` VALUES (1006, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::bmc', '', '重置BMC', '', 1397, 0, '', 163, '{\"CN\":\"重置BMC\",\"HK\":\"重置BMC\",\"US\":\"Reset BMC\"}');
INSERT INTO `shd_auth_rule` VALUES (1007, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::getReinstallStatus', '', '获取重装,救援系统,破解密码进度', '', 430, 0, '', 170, '{\"CN\":\"获取重装,救援系统,破解密码进度\",\"HK\":\"獲取重裝,救援系統,破解密碼進度\",\"US\":\"Get reinstallation, rescue system, password cracking progress\"}');
INSERT INTO `shd_auth_rule` VALUES (1008, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::kvm', '', '获取kvm', '', 1397, 0, '', 164, '{\"CN\":\"获取kvm\",\"HK\":\"獲取kvm\",\"US\":\"Get kvm\"}');
INSERT INTO `shd_auth_rule` VALUES (1009, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::ikvm', '', '获取ikvm', '', 1397, 0, '', 165, '{\"CN\":\"获取ikvm\",\"HK\":\"獲取ikvm\",\"US\":\"Get ikvm\"}');
INSERT INTO `shd_auth_rule` VALUES (1010, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::getTrafficUsage', '', '获取用量信息', '', 0, 0, '', 948, '{\"CN\":\"获取用量信息\",\"HK\":\"獲取用量信息\",\"US\":\"Get usage information\"}');
INSERT INTO `shd_auth_rule` VALUES (1011, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::cancelReinstall', '', '取消重装,救援,破解密码', '', 0, 0, '', 949, '{\"CN\":\"取消重装,救援,破解密码\",\"HK\":\"取消重裝,救援,破解密碼\",\"US\":\"Cancel reinstallation, rescue, crack password\"}');
INSERT INTO `shd_auth_rule` VALUES (1012, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::unsuspendReload', '', '重装解除暂停', '', 0, 0, '', 950, '{\"CN\":\"重装解除暂停\",\"HK\":\"重裝解除暫停\",\"US\":\"Reloading to release pause\"}');
INSERT INTO `shd_auth_rule` VALUES (1013, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getList', '', '文档下载分类页数据', '', 420, 0, '', 534, '{\"CN\":\"文档下载分类页数据\",\"HK\":\"文檔下載分類頁數據\",\"US\":\"Document download category page data\"}');
INSERT INTO `shd_auth_rule` VALUES (1014, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postCreate', '', '文档下载添加分类', '', 420, 0, '', 536, '{\"CN\":\"文档下载添加分类\",\"HK\":\"文檔下載添加分類\",\"US\":\"File download add category\"}');
INSERT INTO `shd_auth_rule` VALUES (1015, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getEdit', '', '文档下载编辑分类', '', 420, 0, '', 537, '{\"CN\":\"文档下载编辑分类\",\"HK\":\"文檔下載編輯分類\",\"US\":\"Document download editing category\"}');
INSERT INTO `shd_auth_rule` VALUES (1016, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postUpdate', '', '编辑分类保存数据', '', 420, 0, '', 538, '{\"CN\":\"编辑分类保存数据\",\"HK\":\"編輯分類保存數據\",\"US\":\"Edit classification and save data\"}');
INSERT INTO `shd_auth_rule` VALUES (1017, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::deleteCat', '', '删除分类数据', '', 420, 0, '', 539, '{\"CN\":\"删除分类数据\",\"HK\":\"刪除分類數據\",\"US\":\"Delete classification data\"}');
INSERT INTO `shd_auth_rule` VALUES (1018, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postAddFile', '', '添加文件', '', 420, 0, '', 541, '{\"CN\":\"添加文件\",\"HK\":\"添加文件\",\"US\":\"Add File\"}');
INSERT INTO `shd_auth_rule` VALUES (1019, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getFilePage', '', '编辑文件', '', 420, 0, '', 542, '{\"CN\":\"编辑文件\",\"HK\":\"編輯文件\",\"US\":\"Edit File\"}');
INSERT INTO `shd_auth_rule` VALUES (1020, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postSaveFile', '', '保存文件信息', '', 420, 0, '', 543, '{\"CN\":\"保存文件信息\",\"HK\":\"保存文件信息\",\"US\":\"Save file information\"}');
INSERT INTO `shd_auth_rule` VALUES (1021, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::deleteFile', '', '删除文件', '', 420, 0, '', 544, '{\"CN\":\"删除文件\",\"HK\":\"刪除文件\",\"US\":\"Delete File\"}');
INSERT INTO `shd_auth_rule` VALUES (1035, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller', '', '后台首页', '', 590, 0, '', 852, '{\"CN\":\"后台首页\",\"HK\":\"後台首頁\",\"US\":\"Backstage Homepage\"}');
INSERT INTO `shd_auth_rule` VALUES (1036, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller::index', '', '首页', '', 1035, 0, '', 853, '{\"CN\":\"首页\",\"HK\":\"首頁\",\"US\":\"Homepage\"}');
INSERT INTO `shd_auth_rule` VALUES (1037, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller::ad_index', '', '菜单', '', 1035, 0, '', 854, '{\"CN\":\"菜单\",\"HK\":\"菜單\",\"US\":\"Menu\"}');
INSERT INTO `shd_auth_rule` VALUES (1040, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::paid', '', '标记为已支付', '', 1342, 0, '', 216, '{\"CN\":\"标记为已支付\",\"HK\":\"標記為已支付\",\"US\":\"Mark as paid\"}');
INSERT INTO `shd_auth_rule` VALUES (1041, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::unpaid', '', '标记为未支付', '', 1342, 0, '', 217, '{\"CN\":\"标记为未支付\",\"HK\":\"標記為未支付\",\"US\":\"Mark as unpaid\"}');
INSERT INTO `shd_auth_rule` VALUES (1042, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::cancelled', '', '标记为被取消', '', 1342, 0, '', 218, '{\"CN\":\"标记为被取消\",\"HK\":\"標記為被取消\",\"US\":\"Mark as cancelled\"}');
INSERT INTO `shd_auth_rule` VALUES (1043, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::delete', '', '删除账单', '', 408, 0, '', 206, '{\"CN\":\"删除账单\",\"HK\":\"刪除賬單\",\"US\":\"Delete Bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1044, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::duplicate', '', '复制账单', '', 1342, 0, '', 219, '{\"CN\":\"复制账单\",\"HK\":\"複製賬單\",\"US\":\"Copy Bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1045, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::summary', '', '账单详情', '', 408, 0, '', 207, '{\"CN\":\"账单详情\",\"HK\":\"賬單詳情\",\"US\":\"Bill Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1046, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::addPayPage', '', '新增付款', '', 1045, 0, '', 208, '{\"CN\":\"新增付款\",\"HK\":\"新增付款\",\"US\":\"Add Payment\"}');
INSERT INTO `shd_auth_rule` VALUES (1047, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::addPay', '', '编辑新增付款', '', 1342, 0, '', 220, '{\"CN\":\"编辑新增付款\",\"HK\":\"編輯新增付款\",\"US\":\"Edit new payment\"}');
INSERT INTO `shd_auth_rule` VALUES (1048, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::optionPage', '', '选项', '', 1045, 0, '', 209, '{\"CN\":\"选项\",\"HK\":\"選項\",\"US\":\"Options\"}');
INSERT INTO `shd_auth_rule` VALUES (1049, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::option', '', '编辑选项', '', 1342, 0, '', 221, '{\"CN\":\"编辑选项\",\"HK\":\"編輯選項\",\"US\":\"Editing Options\"}');
INSERT INTO `shd_auth_rule` VALUES (1050, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::addPayInvoicePage', '', '余额', '', 1045, 0, '', 210, '{\"CN\":\"余额\",\"HK\":\"餘額\",\"US\":\"Balance\"}');
INSERT INTO `shd_auth_rule` VALUES (1051, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::addPayInvoice', '', '添加付款金额到账单', '', 1343, 0, '', 226, '{\"CN\":\"添加付款金额到账单\",\"HK\":\"添加付款金額到賬單\",\"US\":\"Add the payment amount to the bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1052, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::deletePayInvoice', '', '从账单中删除付款金额', '', 1343, 0, '', 227, '{\"CN\":\"从账单中删除付款金额\",\"HK\":\"從賬單中刪除付款金額\",\"US\":\"Remove the payment amount from the bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1053, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::refundPage', '', '退款', '', 1045, 0, '', 211, '{\"CN\":\"退款\",\"HK\":\"退款\",\"US\":\"Refund\"}');
INSERT INTO `shd_auth_rule` VALUES (1054, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::refund', '', '编辑账单退款', '', 1342, 0, '', 222, '{\"CN\":\"编辑账单退款\",\"HK\":\"編輯賬單退款\",\"US\":\"Edit Bill Refund\"}');
INSERT INTO `shd_auth_rule` VALUES (1055, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::notesPage', '', '备注', '', 1045, 0, '', 212, '{\"CN\":\"备注\",\"HK\":\"備註\",\"US\":\"Remarks\"}');
INSERT INTO `shd_auth_rule` VALUES (1056, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::notes', '', '编辑账单备注', '', 1342, 0, '', 223, '{\"CN\":\"编辑账单备注\",\"HK\":\"編輯賬單備註\",\"US\":\"Edit billing notes\"}');
INSERT INTO `shd_auth_rule` VALUES (1057, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::invoceEmail', '', '发送账单邮件', '', 1341, 0, '', 214, '{\"CN\":\"发送账单邮件\",\"HK\":\"發送賬單郵件\",\"US\":\"Send billing email\"}');
INSERT INTO `shd_auth_rule` VALUES (1059, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::deleteItems', '', '账单项目删除', '', 1343, 0, '', 228, '{\"CN\":\"账单项目删除\",\"HK\":\"賬單項目刪除\",\"US\":\"Delete bill item\"}');
INSERT INTO `shd_auth_rule` VALUES (1060, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::delAccount', '', '删除账单流水', '', 1343, 0, '', 229, '{\"CN\":\"删除账单流水\",\"HK\":\"刪除賬單流水\",\"US\":\"Delete bill flow\"}');
INSERT INTO `shd_auth_rule` VALUES (1061, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::createRenew', '', '生成续费账单', '', 0, 0, '', 815, '{\"CN\":\"生成续费账单\",\"HK\":\"生成續費賬單\",\"US\":\"Generate renewal bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1062, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::invoicePayAfterHandle', '', '获取收入数据', '', 0, 0, '', 816, '{\"CN\":\"获取收入数据\",\"HK\":\"獲取收入數據\",\"US\":\"Get income data\"}');
INSERT INTO `shd_auth_rule` VALUES (1065, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceItemscontroller::save', '', '添加账单项目', '', 1070, 0, '', 862, '{\"CN\":\"添加账单项目\",\"HK\":\"添加賬單項目\",\"US\":\"Add bill item\"}');
INSERT INTO `shd_auth_rule` VALUES (1066, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceItemscontroller::read', '', '账单项目列表', '', 1070, 0, '', 863, '{\"CN\":\"账单项目列表\",\"HK\":\"賬單項目列表\",\"US\":\"List of billing items\"}');
INSERT INTO `shd_auth_rule` VALUES (1068, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceItemscontroller::update', '', '账单项目批量更新', '', 1070, 0, '', 864, '{\"CN\":\"账单项目批量更新\",\"HK\":\"賬單項目批量更新\",\"US\":\"Batch update of billing items\"}');
INSERT INTO `shd_auth_rule` VALUES (1069, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceItemscontroller::delete', '', '账单项目删除', '', 1070, 0, '', 865, '{\"CN\":\"账单项目删除\",\"HK\":\"賬單項目刪除\",\"US\":\"Delete bill item\"}');
INSERT INTO `shd_auth_rule` VALUES (1070, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceItemscontroller', '', '账单项目管理', '', 590, 0, '', 861, '{\"CN\":\"账单项目管理\",\"HK\":\"賬單項目管理\",\"US\":\"Bill Project Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1174, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Publiccontroller::getMenu', '', '获取用户菜单数据', '', 157, 0, '', 887, '{\"CN\":\"获取用户菜单数据\",\"HK\":\"獲取用戶菜單數據\",\"US\":\"Get user menu data\"}');
INSERT INTO `shd_auth_rule` VALUES (1176, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Publiccontroller::getClient', '', '后台用户列表', '', 338, 0, '', 299, '{\"CN\":\"后台用户列表\",\"HK\":\"後台用戶列表\",\"US\":\"Background user list\"}');
INSERT INTO `shd_auth_rule` VALUES (1177, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Publiccontroller::getTicketDepartment', '', '后台工单部门列表', '', 157, 0, '', 888, '{\"CN\":\"后台工单部门列表\",\"HK\":\"後台工單部門列表\",\"US\":\"Backstage Ticket department list\"}');
INSERT INTO `shd_auth_rule` VALUES (1266, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Uploadcontroller::upload', '', '富文本框上传图片', '', 1269, 0, '', 898, '{\"CN\":\"富文本框上传图片\",\"HK\":\"富文本框上傳圖片\",\"US\":\"Rich text box upload picture\"}');
INSERT INTO `shd_auth_rule` VALUES (1267, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Uploadcontroller::uploadImage', '', '上传图片', '', 1269, 0, '', 899, '{\"CN\":\"上传图片\",\"HK\":\"上傳圖片\",\"US\":\"Upload Picture\"}');
INSERT INTO `shd_auth_rule` VALUES (1268, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Uploadcontroller::uploadFile', '', '上传文件', '', 350, 0, '', 314, '{\"CN\":\"上传文件\",\"HK\":\"上傳文件\",\"US\":\"Upload file\"}');
INSERT INTO `shd_auth_rule` VALUES (1269, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Uploadcontroller', '', '文件上传', '', 590, 0, '', 897, '{\"CN\":\"文件上传\",\"HK\":\"文件上傳\",\"US\":\"File upload\"}');
INSERT INTO `shd_auth_rule` VALUES (1279, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::summary', '', '查看客户摘要', '', 13, 0, '', 32, '{\"CN\":\"查看客户摘要\",\"HK\":\"查看客戶摘要\",\"US\":\"View customer summary\"}');
INSERT INTO `shd_auth_rule` VALUES (1280, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller', '', '个人资料', '', 13, 0, '', 6, '{\"CN\":\"个人资料\",\"HK\":\"個人資料\",\"US\":\"Personal Information\"}');
INSERT INTO `shd_auth_rule` VALUES (1281, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::profilePost', '', '修改个人资料', '', 1280, 0, '', 7, '{\"CN\":\"修改个人资料\",\"HK\":\"修改個人資料\",\"US\":\"Modify Personal Information\"}');
INSERT INTO `shd_auth_rule` VALUES (1282, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::createClient', '', '创建客户', '', 1, 0, '', 2, '{\"CN\":\"创建客户\",\"HK\":\"創建客戶\",\"US\":\"Create Customer\"}');
INSERT INTO `shd_auth_rule` VALUES (1284, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::closeClient', '', '关闭客户', '', 1332, 0, '', 15, '{\"CN\":\"关闭客户\",\"HK\":\"關閉客戶\",\"US\":\"Close Client\"}');
INSERT INTO `shd_auth_rule` VALUES (1285, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::deleteClient', '', '删除客户', '', 1332, 0, '', 16, '{\"CN\":\"删除客户\",\"HK\":\"刪除客戶\",\"US\":\"Delete Customer\"}');
INSERT INTO `shd_auth_rule` VALUES (1286, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::logRecord', '', '用户日志记录', '', 1916, 0, '', 680, '{\"CN\":\"用户日志记录\",\"HK\":\"用戶日誌記錄\",\"US\":\"User Log Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1287, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::cerify_list', '', '认证列表', '', 0, 0, '', 808, '{\"CN\":\"认证列表\",\"HK\":\"認證列表\",\"US\":\"Certification List\"}');
INSERT INTO `shd_auth_rule` VALUES (1289, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiPersonDetail', '', '客户个人实名认证详情', '', 542, 0, '', 35, '{\"CN\":\"客户个人实名认证详情\",\"HK\":\"客戶個人實名認證詳情\",\"US\":\"Customer\'s personal real-name authentication details\"}');
INSERT INTO `shd_auth_rule` VALUES (1290, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiPersonModify', '', '客户个人实名认证修改', '', 0, 0, '', 809, '{\"CN\":\"客户个人实名认证修改\",\"HK\":\"客戶個人實名認證修改\",\"US\":\"Customer personal real-name authentication modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1291, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiCompanyDetail', '', '客户企业实名认证详情', '', 542, 0, '', 36, '{\"CN\":\"客户企业实名认证详情\",\"HK\":\"客戶企業實名認證詳情\",\"US\":\"Customer company real-name authentication details\"}');
INSERT INTO `shd_auth_rule` VALUES (1292, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiCompanyModify', '', '客户企业实名认证修改', '', 0, 0, '', 810, '{\"CN\":\"客户企业实名认证修改\",\"HK\":\"客戶企業實名認證修改\",\"US\":\"Customer company real-name authentication modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1293, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiPersonDownload', '', '客户个人认证图片下载', '', 0, 0, '', 811, '{\"CN\":\"客户个人认证图片下载\",\"HK\":\"客戶個人認證圖片下載\",\"US\":\"Customer personal authentication picture download\"}');
INSERT INTO `shd_auth_rule` VALUES (1294, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::certifiDownload', '', '下载认证资料', '', 542, 0, '', 37, '{\"CN\":\"下载认证资料\",\"HK\":\"下載認證資料\",\"US\":\"Download certification information\"}');
INSERT INTO `shd_auth_rule` VALUES (1296, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::userInvoice', '', '用户账单列表', '', 404, 0, '', 231, '{\"CN\":\"用户账单列表\",\"HK\":\"用戶賬單列表\",\"US\":\"User Bill List\"}');
INSERT INTO `shd_auth_rule` VALUES (1297, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::addUserInvoice', '', '添加账单', '', 408, 0, '', 205, '{\"CN\":\"添加账单\",\"HK\":\"添加賬單\",\"US\":\"Add Bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1298, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::loginByUser', '', '以该客户登录', '', 1332, 0, '', 17, '{\"CN\":\"以该客户登录\",\"HK\":\"以該客戶登錄\",\"US\":\"Log in as this customer\"}');
INSERT INTO `shd_auth_rule` VALUES (1299, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::relationUserList', '', '用户关系列表', '', 0, 0, '', 813, '{\"CN\":\"用户关系列表\",\"HK\":\"用戶關係列表\",\"US\":\"User Relationship List\"}');
INSERT INTO `shd_auth_rule` VALUES (1300, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller::index', '', '显示资源列表', '', 1307, 0, '', 856, '{\"CN\":\"显示资源列表\",\"HK\":\"顯示資源列表\",\"US\":\"Display resource list\"}');
INSERT INTO `shd_auth_rule` VALUES (1302, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller::save', '', '显示资源列表', '', 1307, 0, '', 857, '{\"CN\":\"显示资源列表\",\"HK\":\"顯示資源列表\",\"US\":\"Display resource list\"}');
INSERT INTO `shd_auth_rule` VALUES (1303, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller::read', '', '显示指定的资源', '', 1307, 0, '', 858, '{\"CN\":\"显示指定的资源\",\"HK\":\"顯示指定的資源\",\"US\":\"Display the specified resource\"}');
INSERT INTO `shd_auth_rule` VALUES (1305, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller::update', '', '保存更新的资源', '', 1307, 0, '', 859, '{\"CN\":\"保存更新的资源\",\"HK\":\"保存更新的資源\",\"US\":\"Save updated resources\"}');
INSERT INTO `shd_auth_rule` VALUES (1306, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller::delete', '', '删除指定资源', '', 1307, 0, '', 860, '{\"CN\":\"删除指定资源\",\"HK\":\"刪除指定資源\",\"US\":\"Delete the specified resource\"}');
INSERT INTO `shd_auth_rule` VALUES (1307, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserRemarkcontroller', '', '资源', '', 590, 0, '', 855, '{\"CN\":\"资源\",\"HK\":\"資源\",\"US\":\"Resources\"}');
INSERT INTO `shd_auth_rule` VALUES (1316, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController', '', '新闻中心', '', 8, 1, '', 545, '{\"CN\":\"新闻中心\",\"HK\":\"新聞中心\",\"US\":\"News Center\"}');
INSERT INTO `shd_auth_rule` VALUES (1317, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getList', '', '帮助列表', '', 2067, 1, '/help-list', 559, '{\"CN\":\"帮助列表\",\"HK\":\"幫助列表\",\"US\":\"Help List\"}');
INSERT INTO `shd_auth_rule` VALUES (1318, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getCatsPage', '', '帮助分类', '', 2067, 1, '/help-category', 560, '{\"CN\":\"帮助分类\",\"HK\":\"幫助分類\",\"US\":\"Help Classification\"}');
INSERT INTO `shd_auth_rule` VALUES (1320, 1, 'admin', 'admin_url', 'ticsetting', '', '工单设置', '', 7, 1, '', 321, '{\"CN\":\"工单设置\",\"HK\":\"工单設置\",\"US\":\"Ticket Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1321, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getSmsLog', '', '短信日志', '', 1916, 1, '/sms-log', 681, '{\"CN\":\"短信日志\",\"HK\":\"短信日誌\",\"US\":\"SMS log\"}');
INSERT INTO `shd_auth_rule` VALUES (1329, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::common', '', '主页', '', 0, 0, '', 819, '{\"CN\":\"主页\",\"HK\":\"主頁\",\"US\":\"Homepage\"}');
INSERT INTO `shd_auth_rule` VALUES (1330, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::getuser', '', '获取指定客户信息', '', 13, 0, '', 31, '{\"CN\":\"获取指定客户信息\",\"HK\":\"獲取指定客戶信息\",\"US\":\"Get specific customer information\"}');
INSERT INTO `shd_auth_rule` VALUES (1331, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::refreshPowerStatus', '', '获取电源状态', '', 430, 0, '', 169, '{\"CN\":\"获取电源状态\",\"HK\":\"獲取電源狀態\",\"US\":\"Get power status\"}');
INSERT INTO `shd_auth_rule` VALUES (1332, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::summary', '', '修改客户摘要', '', 13, 0, '', 14, '{\"CN\":\"修改客户摘要\",\"HK\":\"修改客戶摘要\",\"US\":\"Modify Customer Summary\"}');
INSERT INTO `shd_auth_rule` VALUES (1334, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController::postCustomFields', '', '新增/修改客户自定义字段', '', 512, 0, '', 89, '{\"CN\":\"新增\\/修改客户自定义字段\",\"HK\":\"新增\\/修改客戶自定義字段\",\"US\":\"Add\\/modify customer-defined fields\"}');
INSERT INTO `shd_auth_rule` VALUES (1335, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController::delCustomFields', '', '删除客户自定义字段', '', 512, 0, '', 90, '{\"CN\":\"删除客户自定义字段\",\"HK\":\"刪除客戶自定義字段\",\"US\":\"Delete customer custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (1336, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::detail', '', '实名认证设置详情', '', 454, 0, '/authentication-setting', 106, '{\"CN\":\"实名认证设置详情\",\"HK\":\"實名認證設置詳情\",\"US\":\"Real-name authentication setting details\"}');
INSERT INTO `shd_auth_rule` VALUES (1337, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::save', '', '添加提交订单', '', 14, 0, '', 125, '{\"CN\":\"添加提交订单\",\"HK\":\"添加提交訂單\",\"US\":\"Add Submit Order\"}');
INSERT INTO `shd_auth_rule` VALUES (1338, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::changeStatus', '', '修改订单状态', '', 398, 0, '', 138, '{\"CN\":\"修改订单状态\",\"HK\":\"修改訂單狀態\",\"US\":\"Modify order status\"}');
INSERT INTO `shd_auth_rule` VALUES (1339, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::index', '', '账单列表页', '', 404, 0, '', 232, '{\"CN\":\"账单列表页\",\"HK\":\"賬單列表頁\",\"US\":\"Bill List Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1340, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::searchPage', '', '账单列表页搜索', '', 404, 1, '/bill-management', 233, '{\"CN\":\"账单列表页搜索\",\"HK\":\"賬單列表頁搜索\",\"US\":\"Search Bill List Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1341, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::summary', '', '账单摘要', '', 1045, 0, '', 213, '{\"CN\":\"账单摘要\",\"HK\":\"賬單摘要\",\"US\":\"Bill Summary\"}');
INSERT INTO `shd_auth_rule` VALUES (1342, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::edititem', '', '编辑账单', '', 408, 0, '', 215, '{\"CN\":\"编辑账单\",\"HK\":\"編輯賬單\",\"US\":\"Edit Bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1343, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Invoicecontroller::addPayInvoicePage', '', '编辑账单余额', '', 1342, 0, '', 225, '{\"CN\":\"编辑账单余额\",\"HK\":\"編輯賬單餘額\",\"US\":\"Edit bill balance\"}');
INSERT INTO `shd_auth_rule` VALUES (1344, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController', '', '交易流水列表', '', 405, 0, '', 193, '{\"CN\":\"交易流水列表\",\"HK\":\"交易流水列表\",\"US\":\"Transaction Flow List\"}');
INSERT INTO `shd_auth_rule` VALUES (1346, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::update', '', '编辑交易流水提交', '', 1436, 0, '', 199, '{\"CN\":\"编辑交易流水提交\",\"HK\":\"編輯交易流水提交\",\"US\":\"Edit transaction flow submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1353, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController', '', '产品分组', '', 29, 0, '', 444, '{\"CN\":\"产品分组\",\"HK\":\"產品分組\",\"US\":\"Product Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1354, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Publiccontroller::getTicketDepartment', '', '后台工单部门列表', '', 338, 0, '', 297, '{\"CN\":\"后台工单部门列表\",\"HK\":\"後台工單部門列表\",\"US\":\"Backstage ticket department list\"}');
INSERT INTO `shd_auth_rule` VALUES (1359, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::configMobile', '', '短信设置', '', 530, 0, '/sms-template/sms', 628, '{\"CN\":\"短信设置\",\"HK\":\"短信設置\",\"US\":\"SMS Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1360, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::emailIndex', '', '邮件设置', '', 530, 0, '', 631, '{\"CN\":\"邮件设置\",\"HK\":\"郵件設置\",\"US\":\"Mail Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1361, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::emailIndex', '', '邮件设置详情', '', 1360, 0, '', 632, '{\"CN\":\"邮件设置详情\",\"HK\":\"郵件設置詳情\",\"US\":\"Mail setting details\"}');
INSERT INTO `shd_auth_rule` VALUES (1362, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::configMobile', '', '短信模板列表接口数据', '', 1363, 1, '/sms-template/sms', 649, '{\"CN\":\"短信模板列表接口数据\",\"HK\":\"短信模板列表接口數據\",\"US\":\"SMS template list interface data\"}');
INSERT INTO `shd_auth_rule` VALUES (1363, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::templateList', '', '短信模板列表', '', 533, 0, '/sms-template-index', 648, '{\"CN\":\"短信模板列表\",\"HK\":\"短信模板列表\",\"US\":\"SMS template list\"}');
INSERT INTO `shd_auth_rule` VALUES (1364, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::updateTemStatus', '', '更新审核状态', '', 533, 0, '/sms-template-index', 650, '{\"CN\":\"更新审核状态\",\"HK\":\"更新審核狀態\",\"US\":\"Update audit status\"}');
INSERT INTO `shd_auth_rule` VALUES (1365, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::delete', '', '删除产品', '', 524, 0, '', 363, '{\"CN\":\"删除产品\",\"HK\":\"刪除產品\",\"US\":\"Delete product\"}');
INSERT INTO `shd_auth_rule` VALUES (1366, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::duplicatePage', '', '复制产品', '', 524, 0, '', 364, '{\"CN\":\"复制产品\",\"HK\":\"複製產品\",\"US\":\"Copy product\"}');
INSERT INTO `shd_auth_rule` VALUES (1367, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addPage', '', '产品添加', '', 524, 0, '', 366, '{\"CN\":\"产品添加\",\"HK\":\"產品添加\",\"US\":\"Product Added\"}');
INSERT INTO `shd_auth_rule` VALUES (1368, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController', '', '产品分组', '', 524, 0, '', 368, '{\"CN\":\"产品分组\",\"HK\":\"產品分組\",\"US\":\"Product Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1369, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editPage', '', '产品编辑', '', 524, 0, '', 372, '{\"CN\":\"产品编辑\",\"HK\":\"產品編輯\",\"US\":\"Product Editor\"}');
INSERT INTO `shd_auth_rule` VALUES (1370, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateGroupsort', '', '产品分组排序修改', '', 0, 0, '', 907, '{\"CN\":\"产品分组排序修改\",\"HK\":\"產品分組排序修改\",\"US\":\"Product grouping and sorting modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1371, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateProductsort', '', '产品排序修改', '', 0, 0, '', 908, '{\"CN\":\"产品排序修改\",\"HK\":\"產品排序修改\",\"US\":\"Product Sorting Modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1372, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editGroupPage', '', '产品分组添加/编辑', '', 1368, 0, '', 369, '{\"CN\":\"产品分组添加\\/编辑\",\"HK\":\"產品分組添加\\/編輯\",\"US\":\"Product Group Add\\/Edit\"}');
INSERT INTO `shd_auth_rule` VALUES (1373, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::saveProductGroup', '', '保存产品分组信息', '', 1372, 0, '', 370, '{\"CN\":\"保存产品分组信息\",\"HK\":\"保存產品分組信息\",\"US\":\"Save product group information\"}');
INSERT INTO `shd_auth_rule` VALUES (1374, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::deleteGroup', '', '删除产品组', '', 1368, 0, '', 371, '{\"CN\":\"删除产品组\",\"HK\":\"刪除產品組\",\"US\":\"Delete product group\"}');
INSERT INTO `shd_auth_rule` VALUES (1375, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::duplicate', '', '复制产品', '', 1366, 0, '', 365, '{\"CN\":\"复制产品\",\"HK\":\"複製產品\",\"US\":\"Copy product\"}');
INSERT INTO `shd_auth_rule` VALUES (1376, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::create', '', '创建产品', '', 1367, 0, '', 367, '{\"CN\":\"创建产品\",\"HK\":\"創建產品\",\"US\":\"Create Product\"}');
INSERT INTO `shd_auth_rule` VALUES (1377, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::edit', '', '保存产品信息', '', 1369, 0, '', 373, '{\"CN\":\"保存产品信息\",\"HK\":\"保存產品信息\",\"US\":\"Save product information\"}');
INSERT INTO `shd_auth_rule` VALUES (1378, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::createGroups', '', '创建可选项配置组', '', 526, 0, '', 378, '{\"CN\":\"创建可选项配置组\",\"HK\":\"創建可選項配置組\",\"US\":\"Create optional configuration group\"}');
INSERT INTO `shd_auth_rule` VALUES (1379, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editGroups', '', '编辑可配置选项组', '', 526, 0, '', 380, '{\"CN\":\"编辑可配置选项组\",\"HK\":\"編輯可配置選項組\",\"US\":\"Edit configurable option group\"}');
INSERT INTO `shd_auth_rule` VALUES (1380, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::addOptions', '', '添加可配置选项', '', 1379, 0, '', 381, '{\"CN\":\"添加可配置选项\",\"HK\":\"添加可配置選項\",\"US\":\"Add configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (1381, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteSubOptions', '', '删除可配置选项的子选项', '', 1382, 0, '', 383, '{\"CN\":\"删除可配置选项的子选项\",\"HK\":\"刪除可配置選項的子選項\",\"US\":\"Delete sub-options of configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (1382, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteOptions', '', '删除可配置选项', '', 1379, 0, '', 382, '{\"CN\":\"删除可配置选项\",\"HK\":\"刪除可配置選項\",\"US\":\"Delete configurable options\"}');
INSERT INTO `shd_auth_rule` VALUES (1383, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::deleteGroups', '', '删除可配置选项组', '', 526, 0, '', 387, '{\"CN\":\"删除可配置选项组\",\"HK\":\"刪除可配置選項組\",\"US\":\"Delete configurable option group\"}');
INSERT INTO `shd_auth_rule` VALUES (1384, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::duplicateGroups', '', '复制可配置选项组', '', 526, 0, '', 388, '{\"CN\":\"复制可配置选项组\",\"HK\":\"複製可配置選項組\",\"US\":\"Copy Configurable Option Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1385, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editConfig', '', '编辑可配置项', '', 1379, 0, '', 384, '{\"CN\":\"编辑可配置项\",\"HK\":\"編輯可配置項\",\"US\":\"Edit configurable items\"}');
INSERT INTO `shd_auth_rule` VALUES (1386, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::createGroupsPost', '', '创建可选项配置组页面提交', '', 1378, 0, '', 379, '{\"CN\":\"创建可选项配置组页面提交\",\"HK\":\"創建可選項配置組頁面提交\",\"US\":\"Create optional configuration group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1387, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editGroupsPost', '', '编辑可配置选项组页面提交', '', 1379, 0, '', 386, '{\"CN\":\"编辑可配置选项组页面提交\",\"HK\":\"編輯可配置選項組頁面提交\",\"US\":\"Edit configurable option group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1388, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::duplicateGroupsPost', '', '复制可配置选项组页面提交', '', 1384, 0, '', 389, '{\"CN\":\"复制可配置选项组页面提交\",\"HK\":\"複製可配置選項組頁面提交\",\"US\":\"Copy configurable option group page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1389, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::editConfigPost', '', '编辑可配置项页面提交', '', 1385, 0, '', 385, '{\"CN\":\"编辑可配置项页面提交\",\"HK\":\"編輯可配置項頁面提交\",\"US\":\"Edit configurable item page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1391, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plInstall', '', '支付接口安装', '', 11, 0, '', 261, '{\"CN\":\"支付接口安装\",\"HK\":\"支付接口安裝\",\"US\":\"Payment interface installation\"}');
INSERT INTO `shd_auth_rule` VALUES (1392, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plUninstall', '', '支付接口卸载', '', 11, 0, '', 262, '{\"CN\":\"支付接口卸载\",\"HK\":\"支付接口卸載\",\"US\":\"Payment interface uninstall\"}');
INSERT INTO `shd_auth_rule` VALUES (1393, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plToggle', '', '支付接口禁用(启用)', '', 11, 0, '', 263, '{\"CN\":\"支付接口禁用(启用)\",\"HK\":\"支付接口禁用(啟用)\",\"US\":\"Payment interface disable (enable)\"}');
INSERT INTO `shd_auth_rule` VALUES (1394, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSetting', '', '支付接口配置', '', 11, 0, '', 264, '{\"CN\":\"支付接口配置\",\"HK\":\"支付接口配置\",\"US\":\"Payment interface configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1395, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSettingPost', '', '保存支付接口配置', '', 1394, 0, '', 265, '{\"CN\":\"保存支付接口配置\",\"HK\":\"保存支付接口配置\",\"US\":\"Save payment interface configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1396, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plUpdate', '', '支付接口更新', '', 11, 0, '', 267, '{\"CN\":\"支付接口更新\",\"HK\":\"支付接口更新\",\"US\":\"Payment interface update\"}');
INSERT INTO `shd_auth_rule` VALUES (1397, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController', '', '执行模块命令', '', 28, 0, '', 150, '{\"CN\":\"执行模块命令\",\"HK\":\"執行模塊命令\",\"US\":\"Execute Module Command\"}');
INSERT INTO `shd_auth_rule` VALUES (1398, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getAutoUpdate', '', '更新系统', '', 1915, 0, '', 673, '{\"CN\":\"更新系统\",\"HK\":\"更新系統\",\"US\":\"Update System\"}');
INSERT INTO `shd_auth_rule` VALUES (1399, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::active', '', '订单审核通过', '', 398, 0, '', 139, '{\"CN\":\"订单审核通过\",\"HK\":\"訂單審核通過\",\"US\":\"Order approved\"}');
INSERT INTO `shd_auth_rule` VALUES (1400, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::getModuleConfig', '', '获取模块设置', '', 1369, 0, '', 374, '{\"CN\":\"获取模块设置\",\"HK\":\"獲取模塊設置\",\"US\":\"Get Module Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1401, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::getModuleConfig', '', '获取模块设置', '', 364, 0, '', 457, '{\"CN\":\"获取模块设置\",\"HK\":\"獲取模塊設置\",\"US\":\"Get Module Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1402, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController::clientList', '', '客户列表', '', 13, 0, '/customer-list', 25, '{\"CN\":\"客户列表\",\"HK\":\"客戶列表\",\"US\":\"Customer List\"}');
INSERT INTO `shd_auth_rule` VALUES (1403, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::cerifyloglist', '', '实名认证列表', '', 542, 0, '', 39, '{\"CN\":\"实名认证列表\",\"HK\":\"實名認證列表\",\"US\":\"Real-name authentication list\"}');
INSERT INTO `shd_auth_rule` VALUES (1404, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController::getList', '', '业务列表', '', 28, 0, '', 166, '{\"CN\":\"业务列表\",\"HK\":\"業務列表\",\"US\":\"Business List\"}');
INSERT INTO `shd_auth_rule` VALUES (1405, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plIndex', '', '支付接口列表', '', 11, 0, '', 268, '{\"CN\":\"支付接口列表\",\"HK\":\"支付接口列表\",\"US\":\"Payment interface list\"}');
INSERT INTO `shd_auth_rule` VALUES (1406, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::getList', '', '优惠码列表', '', 203, 0, '', 272, '{\"CN\":\"优惠码列表\",\"HK\":\"優惠碼列表\",\"US\":\"Promotion Code List\"}');
INSERT INTO `shd_auth_rule` VALUES (1407, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::currencyList', '', '货币配置列表', '', 260, 0, '', 254, '{\"CN\":\"货币配置列表\",\"HK\":\"貨幣配置列表\",\"US\":\"Currency Configuration List\"}');
INSERT INTO `shd_auth_rule` VALUES (1408, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getList', '', '后台工单部门列表', '', 308, 0, '', 335, '{\"CN\":\"后台工单部门列表\",\"HK\":\"後台工單部門列表\",\"US\":\"Backstage ticket department list\"}');
INSERT INTO `shd_auth_rule` VALUES (1409, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::novnc', '', 'vnc', '', 1397, 0, '', 151, '{\"CN\":\"vnc\",\"HK\":\"vnc\",\"US\":\"vnc\"}');
INSERT INTO `shd_auth_rule` VALUES (1410, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::reinstall', '', '重装系统', '', 1397, 0, '', 152, '{\"CN\":\"重装系统\",\"HK\":\"重裝系統\",\"US\":\"Reinstall the system\"}');
INSERT INTO `shd_auth_rule` VALUES (1412, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::rescue', '', '救援系统', '', 1397, 0, '', 153, '{\"CN\":\"救援系统\",\"HK\":\"救援系統\",\"US\":\"Rescue System\"}');
INSERT INTO `shd_auth_rule` VALUES (1413, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProvisionController::execute', '', '暂停提交', '', 999, 0, '', 157, '{\"CN\":\"暂停提交\",\"HK\":\"暫停提交\",\"US\":\"Suspend submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1414, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::crackPass', '', '破解密码', '', 1397, 0, '', 154, '{\"CN\":\"破解密码\",\"HK\":\"破解密碼\",\"US\":\"Crack the code\"}');
INSERT INTO `shd_auth_rule` VALUES (1415, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::serverList', '', 'DCIM接口列表', '', 1813, 0, '', 414, '{\"CN\":\"DCIM接口列表\",\"HK\":\"DCIM接口列表\",\"US\":\"DCIM interface list\"}');
INSERT INTO `shd_auth_rule` VALUES (1416, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getProuductlistPage', '', '产品列表', '', 29, 0, '', 460, '{\"CN\":\"产品列表\",\"HK\":\"產品列表\",\"US\":\"Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (1417, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getProuductlistPage', '', '产品列表', '', 1416, 0, '', 461, '{\"CN\":\"产品列表\",\"HK\":\"產品列表\",\"US\":\"Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (1418, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::listFlowPacket', '', '流量包列表', '', 19, 0, '', 392, '{\"CN\":\"流量包列表\",\"HK\":\"流量包列表\",\"US\":\"Traffic Packet List\"}');
INSERT INTO `shd_auth_rule` VALUES (1419, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::listBuyRecord', '', '流量包记录', '', 27, 0, '', 145, '{\"CN\":\"流量包记录\",\"HK\":\"流量包記錄\",\"US\":\"Traffic Packet Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1420, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '自定义配置列表', '', 526, 0, '', 390, '{\"CN\":\"自定义配置列表\",\"HK\":\"自定義配置列表\",\"US\":\"Custom Configuration List\"}');
INSERT INTO `shd_auth_rule` VALUES (1421, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '自定义配置列表', '', 30, 0, '', 463, '{\"CN\":\"自定义配置列表\",\"HK\":\"自定義配置列表\",\"US\":\"Custom Configuration List\"}');
INSERT INTO `shd_auth_rule` VALUES (1422, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::serverList', '', '接口列表', '', 528, 0, '', 401, '{\"CN\":\"接口列表\",\"HK\":\"接口列表\",\"US\":\"Interface List\"}');
INSERT INTO `shd_auth_rule` VALUES (1423, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::configMobilePost', '', '手机短信配置页面提交', '', 1359, 0, '', 629, '{\"CN\":\"手机短信配置页面提交\",\"HK\":\"手機短信配置頁面提交\",\"US\":\"Submit the SMS configuration page of the mobile phone\"}');
INSERT INTO `shd_auth_rule` VALUES (1424, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::emailIndexPost', '', '邮件设置提交', '', 1360, 0, '', 633, '{\"CN\":\"邮件设置提交\",\"HK\":\"郵件設置提交\",\"US\":\"Mail Settings Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1425, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SetController::getCustomFields', '', '客户自定义字段详情', '', 512, 0, '', 91, '{\"CN\":\"客户自定义字段详情\",\"HK\":\"客戶自定義字段詳情\",\"US\":\"Customer Custom Field Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1426, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::SetSmsTemplatePost', '', '发送设置页面提交', '', 536, 0, '', 661, '{\"CN\":\"发送设置页面提交\",\"HK\":\"發送設置頁面提交\",\"US\":\"Send setting page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1427, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getGeneral', '', '常规设置详情', '', 462, 0, '', 574, '{\"CN\":\"常规设置详情\",\"HK\":\"常規設置詳情\",\"US\":\"General Settings Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1428, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getRecharge', '', '常规设置-充值详情', '', 0, 0, '', 916, '{\"CN\":\"常规设置-充值详情\",\"HK\":\"常規設置-充值詳情\",\"US\":\"General Settings-Recharge Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1429, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::registerloginpage', '', '注册登录列表', '', 0, 0, '', 917, '{\"CN\":\"注册登录列表\",\"HK\":\"註冊登錄列表\",\"US\":\"Registered Login List\"}');
INSERT INTO `shd_auth_rule` VALUES (1430, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketDetail', '', '工单详情', '', 350, 0, '', 313, '{\"CN\":\"工单详情\",\"HK\":\"工單詳情\",\"US\":\"Ticket Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1431, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::createPage', '', '新建工单', '', 336, 0, '', 294, '{\"CN\":\"新建工单\",\"HK\":\"新建工單\",\"US\":\"New Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (1432, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CurrencyController::editCurrency', '', '编辑货币种类', '', 254, 0, '', 257, '{\"CN\":\"编辑货币种类\",\"HK\":\"編輯貨幣種類\",\"US\":\"Edit Currency Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1433, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::savePage', '', '编辑优惠码', '', 206, 0, '', 277, '{\"CN\":\"编辑优惠码\",\"HK\":\"編輯優惠碼\",\"US\":\"Edit Promo Code\"}');
INSERT INTO `shd_auth_rule` VALUES (1434, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PromoCodeController::addPage', '', '添加优惠码', '', 204, 0, '', 274, '{\"CN\":\"添加优惠码\",\"HK\":\"添加優惠碼\",\"US\":\"Add coupon code\"}');
INSERT INTO `shd_auth_rule` VALUES (1435, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSetting', '', '支付接口配置', '', 1394, 0, '', 266, '{\"CN\":\"支付接口配置\",\"HK\":\"支付接口配置\",\"US\":\"Payment interface configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1436, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::read', '', '编辑交易流水', '', 411, 0, '', 198, '{\"CN\":\"编辑交易流水\",\"HK\":\"編輯交易流水\",\"US\":\"Edit transaction flow\"}');
INSERT INTO `shd_auth_rule` VALUES (1438, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientGroupController::index', '', '客户分组列表', '', 448, 0, '', 101, '{\"CN\":\"客户分组列表\",\"HK\":\"客戶分組列表\",\"US\":\"Customer Group List\"}');
INSERT INTO `shd_auth_rule` VALUES (1439, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getList', '', '新闻列表', '', 518, 0, '', 548, '{\"CN\":\"新闻列表\",\"HK\":\"新聞列表\",\"US\":\"News List\"}');
INSERT INTO `shd_auth_rule` VALUES (1440, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getCatsPage', '', '新闻分类列表', '', 519, 0, '', 554, '{\"CN\":\"新闻分类列表\",\"HK\":\"新聞分類列表\",\"US\":\"News Category List\"}');
INSERT INTO `shd_auth_rule` VALUES (1441, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getDatabaseInfo', '', '数据库状态详情', '', 481, 0, '/database-message', 703, '{\"CN\":\"数据库状态详情\",\"HK\":\"數據庫狀態詳情\",\"US\":\"Database Status Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1442, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::profile', '', '个人资料详情', '', 1280, 0, '', 8, '{\"CN\":\"个人资料详情\",\"HK\":\"個人資料詳情\",\"US\":\"Profile Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1443, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController', '', '销售设置', '', 1912, 1, '/sales-management', 599, '{\"CN\":\"销售设置\",\"HK\":\"銷售設置\",\"US\":\"Sales Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1444, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::groupList', '', '分组列表', '', 1443, 0, '', 600, '{\"CN\":\"分组列表\",\"HK\":\"分組列表\",\"US\":\"Group List\"}');
INSERT INTO `shd_auth_rule` VALUES (1445, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::addSalegroupPage', '', '添加分组页面', '', 1443, 0, '', 601, '{\"CN\":\"添加分组页面\",\"HK\":\"添加分組頁面\",\"US\":\"Add group page\"}');
INSERT INTO `shd_auth_rule` VALUES (1446, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::addSalegroup', '', '添加分组', '', 1445, 0, '', 602, '{\"CN\":\"添加分组\",\"HK\":\"添加分組\",\"US\":\"Add Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1447, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::editSalegroupPage', '', '编辑分组页面', '', 1443, 0, '', 603, '{\"CN\":\"编辑分组页面\",\"HK\":\"編輯分組頁面\",\"US\":\"Edit Group Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1448, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::editSalegroup', '', '编辑分组', '', 1447, 0, '', 604, '{\"CN\":\"编辑分组\",\"HK\":\"編輯分組\",\"US\":\"Edit Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1449, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::ladderList', '', '阶梯列表', '', 1443, 0, '', 605, '{\"CN\":\"阶梯列表\",\"HK\":\"階梯列表\",\"US\":\"Ladder List\"}');
INSERT INTO `shd_auth_rule` VALUES (1450, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::addSaleLadder', '', '添加阶梯', '', 1443, 0, '', 606, '{\"CN\":\"添加阶梯\",\"HK\":\"添加階梯\",\"US\":\"Add Ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1451, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::editSaleLadderPage', '', '编辑阶梯页面', '', 1443, 0, '', 607, '{\"CN\":\"编辑阶梯页面\",\"HK\":\"編輯階梯頁面\",\"US\":\"Edit Ladder Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1452, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::editSaleLadder', '', '编辑阶梯', '', 1451, 0, '', 608, '{\"CN\":\"编辑阶梯\",\"HK\":\"編輯階梯\",\"US\":\"Edit Ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1453, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::create', '', '添加交易流水页面', '', 405, 0, '', 201, '{\"CN\":\"添加交易流水页面\",\"HK\":\"添加交易流水頁面\",\"US\":\"Add transaction flow page\"}');
INSERT INTO `shd_auth_rule` VALUES (1454, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::saleStatistics', '', '我的业绩', '', 1861, 1, '/sales-statistics', 47, '{\"CN\":\"我的业绩\",\"HK\":\"我的業績\",\"US\":\"My Performance\"}');
INSERT INTO `shd_auth_rule` VALUES (1455, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Salecontroller::saleusers', '', '获取销售用户', '', 1454, 0, '', 48, '{\"CN\":\"获取销售用户\",\"HK\":\"獲取銷售用戶\",\"US\":\"Get sales users\"}');
INSERT INTO `shd_auth_rule` VALUES (1456, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Salecontroller::saleRecords', '', '获取销售客户购买记录', '', 1454, 0, '', 49, '{\"CN\":\"获取销售客户购买记录\",\"HK\":\"獲取銷售客戶購買記錄\",\"US\":\"Get sales customer purchase records\"}');
INSERT INTO `shd_auth_rule` VALUES (1457, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::checkPost', '', '提交审核', '', 533, 0, '', 652, '{\"CN\":\"提交审核\",\"HK\":\"提交審核\",\"US\":\"Submit for review\"}');
INSERT INTO `shd_auth_rule` VALUES (1458, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::delSalegroup', '', '删除分组', '', 1443, 0, '', 609, '{\"CN\":\"删除分组\",\"HK\":\"刪除分組\",\"US\":\"Delete group\"}');
INSERT INTO `shd_auth_rule` VALUES (1459, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::delSaleLadder', '', '删除阶梯', '', 1443, 0, '', 610, '{\"CN\":\"删除阶梯\",\"HK\":\"刪除階梯\",\"US\":\"Delete Ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1462, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getAffiliate', '', '常规设置-推介页面', '', 1680, 0, '', 93, '{\"CN\":\"常规设置-推介页面\",\"HK\":\"常規設置-推介頁面\",\"US\":\"General Settings-Referral Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1463, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController', '', '推介计划', '', 1863, 1, '/customer-promotionplan', 66, '{\"CN\":\"推介计划\",\"HK\":\"推介計劃\",\"US\":\"Recommendation Plan\"}');
INSERT INTO `shd_auth_rule` VALUES (1464, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::index', '', '推介计划列表', '', 1463, 0, '', 68, '{\"CN\":\"推介计划列表\",\"HK\":\"推介計劃列表\",\"US\":\"Recommendation Program List\"}');
INSERT INTO `shd_auth_rule` VALUES (1465, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::ladderList', '', '推介阶梯列表', '', 1463, 0, '', 69, '{\"CN\":\"推介阶梯列表\",\"HK\":\"推介階梯列表\",\"US\":\"Recommendation Ladder List\"}');
INSERT INTO `shd_auth_rule` VALUES (1466, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::addAffLadder', '', '添加推介阶梯', '', 1463, 0, '', 70, '{\"CN\":\"添加推介阶梯\",\"HK\":\"添加推介階梯\",\"US\":\"Add referral ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1467, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::editAffLadderPage', '', '修改推介阶梯页面', '', 1463, 0, '', 71, '{\"CN\":\"修改推介阶梯页面\",\"HK\":\"修改推介階梯頁面\",\"US\":\"Modify the referral ladder page\"}');
INSERT INTO `shd_auth_rule` VALUES (1468, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::editAffLadder', '', '修改推介阶梯', '', 1463, 0, '', 72, '{\"CN\":\"修改推介阶梯\",\"HK\":\"修改推介階梯\",\"US\":\"Modify the recommendation ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1469, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::delAffLadder', '', '删除推介阶梯', '', 1463, 0, '', 73, '{\"CN\":\"删除推介阶梯\",\"HK\":\"刪除推介階梯\",\"US\":\"Delete the referral ladder\"}');
INSERT INTO `shd_auth_rule` VALUES (1470, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffiPage', '', '用户推荐配置', '', 1463, 0, '', 75, '{\"CN\":\"用户推荐配置\",\"HK\":\"用戶推薦配置\",\"US\":\"User recommended configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1471, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffiPost', '', '用户推荐配置提交', '', 1463, 0, '', 83, '{\"CN\":\"用户推荐配置提交\",\"HK\":\"用戶推薦配置提交\",\"US\":\"User recommended configuration submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1472, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::productaffiPage', '', '产品推荐配置', '', 1463, 0, '', 84, '{\"CN\":\"产品推荐配置\",\"HK\":\"產品推薦配置\",\"US\":\"Product Recommended Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1473, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::productaffiPost', '', '产品推荐配置提交', '', 1463, 0, '', 85, '{\"CN\":\"产品推荐配置提交\",\"HK\":\"產品推薦配置提交\",\"US\":\"Product recommended configuration submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1475, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::invoicePost', '', '财务设置--提交', '', 0, 0, '', 930, '{\"CN\":\"财务设置--提交\",\"HK\":\"財務設置--提交\",\"US\":\"Financial Settings--Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1476, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::invoicePage', '', '财务设置--页面', '', 0, 0, '', 931, '{\"CN\":\"财务设置--页面\",\"HK\":\"財務設置--頁面\",\"US\":\"Financial Settings--Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1477, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffilist', '', '客户注册列表', '', 1470, 0, '', 76, '{\"CN\":\"客户注册列表\",\"HK\":\"客戶註冊列表\",\"US\":\"Customer Registration List\"}');
INSERT INTO `shd_auth_rule` VALUES (1478, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffirecord', '', '提现记录', '', 1470, 0, '', 77, '{\"CN\":\"提现记录\",\"HK\":\"提現記錄\",\"US\":\"Withdrawal Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1479, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffibuyrecord', '', '订购记录', '', 1470, 0, '', 78, '{\"CN\":\"订购记录\",\"HK\":\"訂購記錄\",\"US\":\"Order Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1480, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::useraffibalance', '', '用户推荐金额修改', '', 1463, 0, '', 86, '{\"CN\":\"用户推荐金额修改\",\"HK\":\"用戶推薦金額修改\",\"US\":\"User recommended amount modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1481, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketStatusController::getList', '', '工单状态列表', '', 335, 0, '', 315, '{\"CN\":\"工单状态列表\",\"HK\":\"工單狀態列表\",\"US\":\"Ticket Status List\"}');
INSERT INTO `shd_auth_rule` VALUES (1482, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::affiwithdrawrecord', '', '后台推介提现记录', '', 1470, 0, '', 79, '{\"CN\":\"后台推介提现记录\",\"HK\":\"後台推介提現記錄\",\"US\":\"Background promotion and withdrawal record\"}');
INSERT INTO `shd_auth_rule` VALUES (1483, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::affiwithdrawsh', '', '提现记录审核', '', 1470, 0, '', 80, '{\"CN\":\"提现记录审核\",\"HK\":\"提現記錄審核\",\"US\":\"Withdrawal Record Review\"}');
INSERT INTO `shd_auth_rule` VALUES (1484, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::adminList', '', '销售设置管理员列表', '', 1443, 0, '', 611, '{\"CN\":\"销售设置管理员列表\",\"HK\":\"銷售設置管理員列表\",\"US\":\"Sales Settings Administrator List\"}');
INSERT INTO `shd_auth_rule` VALUES (1485, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::editAdminList', '', '销售设置管理员', '', 1443, 0, '', 612, '{\"CN\":\"销售设置管理员\",\"HK\":\"銷售設置管理員\",\"US\":\"Sales Settings Manager\"}');
INSERT INTO `shd_auth_rule` VALUES (1486, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::gatewaylist', '', '后台推介支付方式列表', '', 1470, 0, '', 81, '{\"CN\":\"后台推介支付方式列表\",\"HK\":\"後台推介支付方式列表\",\"US\":\"Backstage recommended payment method list\"}');
INSERT INTO `shd_auth_rule` VALUES (1489, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getProuductlistPage', '', '商品设置', '', 21, 1, '/zjmfcloud-product', 438, '{\"CN\":\"商品设置\",\"HK\":\"商品設置\",\"US\":\"Commodity Setting\"}');
INSERT INTO `shd_auth_rule` VALUES (1490, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::groupsList', '', '可配置选项', '', 21, 0, '/configurable-option?type=dcimcloud', 439, '{\"CN\":\"可配置选项\",\"HK\":\"可配置選項\",\"US\":\"Configurable Options\"}');
INSERT INTO `shd_auth_rule` VALUES (1491, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::getSaleEnble', '', '销售配置', '', 1443, 0, '', 613, '{\"CN\":\"销售配置\",\"HK\":\"銷售配置\",\"US\":\"Sales Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1492, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::saleEnblePost', '', '销售配置提交', '', 1443, 0, '', 614, '{\"CN\":\"销售配置提交\",\"HK\":\"銷售配置提交\",\"US\":\"Sales Configuration Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1493, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getCheckAutoUpdate', '', '检测更新系统', '', 1915, 0, '', 675, '{\"CN\":\"检测更新系统\",\"HK\":\"檢測更新系統\",\"US\":\"Check and update the system\"}');
INSERT INTO `shd_auth_rule` VALUES (1496, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::groupList', '', '产品分组', '', 1901, 0, '', 112, '{\"CN\":\"产品分组\",\"HK\":\"產品分組\",\"US\":\"Product Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1497, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::groupList', '', '产品分组列表', '', 1496, 0, '', 113, '{\"CN\":\"产品分组列表\",\"HK\":\"產品分組列表\",\"US\":\"Product Group List\"}');
INSERT INTO `shd_auth_rule` VALUES (1498, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addProductgroupPage', '', '添加产品分组页面', '', 1496, 0, '', 114, '{\"CN\":\"添加产品分组页面\",\"HK\":\"添加產品分組頁面\",\"US\":\"Add product group page\"}');
INSERT INTO `shd_auth_rule` VALUES (1499, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::addProductgroup', '', '添加分组', '', 1496, 0, '', 115, '{\"CN\":\"添加分组\",\"HK\":\"添加分組\",\"US\":\"Add Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1500, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editProductgroupPage', '', '编辑分组页面', '', 1496, 0, '', 116, '{\"CN\":\"编辑分组页面\",\"HK\":\"編輯分組頁面\",\"US\":\"Edit Group Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1501, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editProductgroup', '', '编辑分组', '', 1496, 0, '', 117, '{\"CN\":\"编辑分组\",\"HK\":\"編輯分組\",\"US\":\"Edit Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1502, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::delProductgroup', '', '删除分组', '', 1496, 0, '', 118, '{\"CN\":\"删除分组\",\"HK\":\"刪除分組\",\"US\":\"Delete group\"}');
INSERT INTO `shd_auth_rule` VALUES (1503, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::zklistPage', '', '折扣设置', '', 1901, 0, '', 119, '{\"CN\":\"折扣设置\",\"HK\":\"折扣設置\",\"US\":\"Discount Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1504, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editUserProductgroup', '', '编辑客户产品分组的金额', '', 1503, 0, '', 120, '{\"CN\":\"编辑客户产品分组的金额\",\"HK\":\"編輯客戶產品分組的金額\",\"US\":\"Edit the amount of customer product grouping\"}');
INSERT INTO `shd_auth_rule` VALUES (1505, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::zklistPage', '', '折扣列表', '', 1503, 0, '', 121, '{\"CN\":\"折扣列表\",\"HK\":\"折扣列表\",\"US\":\"Discount List\"}');
INSERT INTO `shd_auth_rule` VALUES (1506, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::gatewaylist', '', '后台推介支付方式列表', '', 1470, 0, '', 82, '{\"CN\":\"后台推介支付方式列表\",\"HK\":\"後台推介支付方式列表\",\"US\":\"Backstage recommended payment method list\"}');
INSERT INTO `shd_auth_rule` VALUES (1507, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::requestCancelList', '', '产品暂停请求', '', 1867, 1, '/customer-cancelreq', 180, '{\"CN\":\"产品暂停请求\",\"HK\":\"產品暫停請求\",\"US\":\"Product pause request\"}');
INSERT INTO `shd_auth_rule` VALUES (1588, 1, 'admin', 'admin_url', 'app\\admin\\controller\\WithdrawController::getWithdraw', '', '提现审核', '', 1869, 1, '/customer-withdrawal', 240, '{\"CN\":\"提现审核\",\"HK\":\"提現審核\",\"US\":\"Withdrawal review\"}');
INSERT INTO `shd_auth_rule` VALUES (1590, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getSystemMessageLog', '', '站内信日志', '', 1916, 1, '/station-letter-log', 682, '{\"CN\":\"站内信日志\",\"HK\":\"站內信日誌\",\"US\":\"Site Message Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1599, 1, 'admin', 'admin_url', '', '', '数据迁移', '', 1915, 1, '/data-migration', 671, '{\"CN\":\"数据迁移\",\"HK\":\"數據遷移\",\"US\":\"Data Migration\"}');
INSERT INTO `shd_auth_rule` VALUES (1601, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController', '', '关于', '', 1915, 1, '/about', 672, '{\"CN\":\"关于\",\"HK\":\"關於\",\"US\":\"About\"}');
INSERT INTO `shd_auth_rule` VALUES (1603, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '服务器列表', '', 2110, 1, '/munual-resource', 723, '{\"CN\":\"服务器列表\",\"HK\":\"服務器列表\",\"US\":\"Server List\"}');
INSERT INTO `shd_auth_rule` VALUES (1604, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '上游设置', '', 1899, 0, '', 760, '{\"CN\":\"上游设置\",\"HK\":\"上游設置\",\"US\":\"Upstream Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1605, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::index', '', '上游列表', '', 1603, 0, '', 724, '{\"CN\":\"上游列表\",\"HK\":\"上游列表\",\"US\":\"Upstream List\"}');
INSERT INTO `shd_auth_rule` VALUES (1606, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::addPost', '', '上游添加', '', 1603, 0, '', 725, '{\"CN\":\"上游添加\",\"HK\":\"上游添加\",\"US\":\"Upstream add\"}');
INSERT INTO `shd_auth_rule` VALUES (1607, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::editupPost', '', '上游修改', '', 1603, 0, '', 726, '{\"CN\":\"上游修改\",\"HK\":\"上游修改\",\"US\":\"Upstream Modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1608, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::delup', '', '上游删除', '', 1603, 0, '', 727, '{\"CN\":\"上游删除\",\"HK\":\"上游刪除\",\"US\":\"Upstream delete\"}');
INSERT INTO `shd_auth_rule` VALUES (1609, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '资源添加', '', 1603, 0, '', 728, '{\"CN\":\"资源添加\",\"HK\":\"資源添加\",\"US\":\"Add Resource\"}');
INSERT INTO `shd_auth_rule` VALUES (1610, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '资源修改', '', 1603, 0, '', 731, '{\"CN\":\"资源修改\",\"HK\":\"資源修改\",\"US\":\"Resource Modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1611, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::delUpper', '', '资源删除', '', 1603, 0, '', 753, '{\"CN\":\"资源删除\",\"HK\":\"資源刪除\",\"US\":\"Resource Delete\"}');
INSERT INTO `shd_auth_rule` VALUES (1612, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::upperIndex', '', '资源列表', '', 1603, 0, '', 754, '{\"CN\":\"资源列表\",\"HK\":\"資源列表\",\"US\":\"Resource List\"}');
INSERT INTO `shd_auth_rule` VALUES (1613, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::addUpperPage', '', '资源添加页面', '', 1609, 0, '', 729, '{\"CN\":\"资源添加页面\",\"HK\":\"資源添加頁面\",\"US\":\"Resource Adding Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1614, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::addUpperPost', '', '资源添加提交', '', 1609, 0, '', 730, '{\"CN\":\"资源添加提交\",\"HK\":\"資源添加提交\",\"US\":\"Resource add submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1615, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::editUpperPage', '', '资源修改页面', '', 1610, 0, '', 751, '{\"CN\":\"资源修改页面\",\"HK\":\"資源修改頁面\",\"US\":\"Resource Modification Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1616, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::editUpperPost', '', '资源修改提交', '', 1610, 0, '', 752, '{\"CN\":\"资源修改提交\",\"HK\":\"資源修改提交\",\"US\":\"Resource Modification Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1617, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::indexPost', '', '订单提成金额', '', 390, 0, '', 134, '{\"CN\":\"订单提成金额\",\"HK\":\"訂單提成金額\",\"US\":\"Order commission amount\"}');
INSERT INTO `shd_auth_rule` VALUES (1680, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getAffiliate', '', '推介设置', '', 1901, 1, '/promotion_plan', 92, '{\"CN\":\"推介设置\",\"HK\":\"推介設置\",\"US\":\"Recommendation Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1682, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::productgroupPage', '', '产品分类--页面', '', 1921, 0, '', 426, '{\"CN\":\"产品分类--页面\",\"HK\":\"產品分類--頁面\",\"US\":\"Product Category--Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1683, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::productGroupPost', '', '产品分类--提交', '', 1921, 0, '', 427, '{\"CN\":\"产品分类--提交\",\"HK\":\"產品分類--提交\",\"US\":\"Product Classification--Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1684, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::selectType', '', '选择产品分组', '', 1369, 0, '', 375, '{\"CN\":\"选择产品分组\",\"HK\":\"選擇產品分組\",\"US\":\"Select Product Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1686, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::productgroupList', '', '产品分类--列表', '', 1921, 0, '', 428, '{\"CN\":\"产品分类--列表\",\"HK\":\"產品分類--列表\",\"US\":\"Product Category--List\"}');
INSERT INTO `shd_auth_rule` VALUES (1687, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getCronSystemLog', '', '定时任务日志', '', 1916, 1, '/automatic-task-log', 684, '{\"CN\":\"定时任务日志\",\"HK\":\"定時任務日誌\",\"US\":\"Timed Task Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1688, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '供应商管理', '', 2110, 1, '/zjmf-api', 716, '{\"CN\":\"供应商管理\",\"HK\":\"供應商管理\",\"US\":\"Supplier Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1689, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::mobiletemplateList', '', '个人中心短信模板列表', '', 533, 0, '', 651, '{\"CN\":\"个人中心短信模板列表\",\"HK\":\"個人中心短信模板列表\",\"US\":\"Personal Center SMS Template List\"}');
INSERT INTO `shd_auth_rule` VALUES (1690, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::emailtemplateList', '', '个人中心邮件模板列表', '', 531, 0, '', 645, '{\"CN\":\"个人中心邮件模板列表\",\"HK\":\"個人中心郵件模板列表\",\"US\":\"Personal Center Mail Template List\"}');
INSERT INTO `shd_auth_rule` VALUES (1691, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::sendMessagePost', '', '发送邮件短信消息', '', 531, 0, '', 646, '{\"CN\":\"发送邮件短信消息\",\"HK\":\"發送郵件短信消息\",\"US\":\"Send Email SMS Message\"}');
INSERT INTO `shd_auth_rule` VALUES (1692, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::types', '', '获取认证类型(无人工审核)', '', 1336, 0, '', 109, '{\"CN\":\"获取认证类型(无人工审核)\",\"HK\":\"獲取認證類型(無人工審核)\",\"US\":\"Acquire certification type (no manual review)\"}');
INSERT INTO `shd_auth_rule` VALUES (1693, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController::getTimetype', '', '获取时间类型', '', 28, 0, '', 167, '{\"CN\":\"获取时间类型\",\"HK\":\"獲取時間類型\",\"US\":\"Get Time Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1695, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postGeneral', '', '官网设置提交', '', 8, 0, '', 561, '{\"CN\":\"官网设置提交\",\"HK\":\"官網設置提交\",\"US\":\"Official website setting submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1698, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getYearIncomeStatistics', '', '年度收入统计', '', 2107, 1, '/annual-statistics', 707, '{\"CN\":\"年度收入统计\",\"HK\":\"年度收入統計\",\"US\":\"Annual Income Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (1699, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getNewClientStatistics', '', '新客户', '', 2107, 1, '/new-customer', 709, '{\"CN\":\"新客户\",\"HK\":\"新客戶\",\"US\":\"New Customer\"}');
INSERT INTO `shd_auth_rule` VALUES (1700, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getNewClientStatistics', '', '产品收入', '', 2107, 1, '/product-revenue', 710, '{\"CN\":\"产品收入\",\"HK\":\"產品收入\",\"US\":\"Product Revenue\"}');
INSERT INTO `shd_auth_rule` VALUES (1701, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getNewClientStatistics', '', '收入排名', '', 2107, 1, '/revenue-ranking', 711, '{\"CN\":\"收入排名\",\"HK\":\"收入排名\",\"US\":\"Revenue Ranking\"}');
INSERT INTO `shd_auth_rule` VALUES (1702, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::sm_type', '', '获取类型', '', 1864, 0, '', 53, '{\"CN\":\"获取类型\",\"HK\":\"獲取類型\",\"US\":\"Get Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1703, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::searchList', '', '筛选客户集合', '', 1864, 0, '', 54, '{\"CN\":\"筛选客户集合\",\"HK\":\"篩選客戶集合\",\"US\":\"Filter customer collection\"}');
INSERT INTO `shd_auth_rule` VALUES (1704, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::mobiletemplateList', '', '短信模板列表', '', 1864, 0, '', 55, '{\"CN\":\"短信模板列表\",\"HK\":\"短信模板列表\",\"US\":\"SMS template list\"}');
INSERT INTO `shd_auth_rule` VALUES (1705, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::editTemplate', '', '邮件模板基本参数', '', 1864, 0, '', 56, '{\"CN\":\"邮件模板基本参数\",\"HK\":\"郵件模板基本參數\",\"US\":\"Basic Parameters of Email Template\"}');
INSERT INTO `shd_auth_rule` VALUES (1706, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::sendMessagePost', '', '发送邮件短信消息', '', 1864, 0, '', 57, '{\"CN\":\"发送邮件短信消息\",\"HK\":\"發送郵件短信消息\",\"US\":\"Send Email SMS Message\"}');
INSERT INTO `shd_auth_rule` VALUES (1707, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::getProgress', '', '获取进度', '', 1864, 0, '', 58, '{\"CN\":\"获取进度\",\"HK\":\"獲取進度\",\"US\":\"Get Progress\"}');
INSERT INTO `shd_auth_rule` VALUES (1708, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::getSalesServer', '', '获取销售服务器', '', 22, 0, '', 476, '{\"CN\":\"获取销售服务器\",\"HK\":\"獲取銷售服務器\",\"US\":\"Get sales server\"}');
INSERT INTO `shd_auth_rule` VALUES (1709, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::getSystemInfoModulesList', '', '获取信息系统展示模块列表', '', 306, 0, '', 823, '{\"CN\":\"获取信息系统展示模块列表\",\"HK\":\"獲取信息系統展示模塊列表\",\"US\":\"Get a list of information system display modules\"}');
INSERT INTO `shd_auth_rule` VALUES (1710, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::updateSystemInfoModulesSort', '', '修改信息系统展示模块顺序', '', 306, 0, '', 835, '{\"CN\":\"修改信息系统展示模块顺序\",\"HK\":\"修改信息系統展示模塊順序\",\"US\":\"Modify the order of information system display modules\"}');
INSERT INTO `shd_auth_rule` VALUES (1711, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plCopy', '', '复制', '', 11, 0, '', 269, '{\"CN\":\"复制\",\"HK\":\"複製\",\"US\":\"Copy\"}');
INSERT INTO `shd_auth_rule` VALUES (1712, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_waiting_ticket', '', '待处理工单', '', 1709, 0, '', 824, '{\"CN\":\"待处理工单\",\"HK\":\"待處理工單\",\"US\":\"Pending Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (1713, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_staff_sales_ranking', '', '员工销售排行', '', 1709, 0, '', 825, '{\"CN\":\"员工销售排行\",\"HK\":\"員工銷售排行\",\"US\":\"Employee Sales Ranking\"}');
INSERT INTO `shd_auth_rule` VALUES (1714, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_online_admin', '', '在线管理员', '', 1709, 0, '', 826, '{\"CN\":\"在线管理员\",\"HK\":\"在線管理員\",\"US\":\"Online Administrator\"}');
INSERT INTO `shd_auth_rule` VALUES (1715, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_system_log', '', '系统日志', '', 1709, 0, '', 827, '{\"CN\":\"系统日志\",\"HK\":\"系統日誌\",\"US\":\"System Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1716, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_sales_ranking', '', '本月销售排行', '', 1709, 0, '', 828, '{\"CN\":\"本月销售排行\",\"HK\":\"本月銷售排行\",\"US\":\"This month\'s sales ranking\"}');
INSERT INTO `shd_auth_rule` VALUES (1717, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_expiring', '', '即将过期', '', 1709, 0, '', 829, '{\"CN\":\"即将过期\",\"HK\":\"即將過期\",\"US\":\"Expiration soon\"}');
INSERT INTO `shd_auth_rule` VALUES (1718, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_client', '', '客户概况', '', 1709, 0, '', 830, '{\"CN\":\"客户概况\",\"HK\":\"客戶概況\",\"US\":\"Customer Profile\"}');
INSERT INTO `shd_auth_rule` VALUES (1719, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_trade', '', '交易统计', '', 1709, 0, '', 831, '{\"CN\":\"交易统计\",\"HK\":\"交易統計\",\"US\":\"Transaction Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (1720, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_todo', '', '代办事项', '', 1709, 0, '', 832, '{\"CN\":\"代办事项\",\"HK\":\"代辦事項\",\"US\":\"Agents to do\"}');
INSERT INTO `shd_auth_rule` VALUES (1721, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_income', '', '收入概览', '', 1709, 0, '', 833, '{\"CN\":\"收入概览\",\"HK\":\"收入概覽\",\"US\":\"Income Overview\"}');
INSERT INTO `shd_auth_rule` VALUES (1722, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_order', '', '订单概览', '', 1709, 0, '', 834, '{\"CN\":\"订单概览\",\"HK\":\"訂單概覽\",\"US\":\"Order Overview\"}');
INSERT INTO `shd_auth_rule` VALUES (1723, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::assignserver', '', '分配设置', '', 28, 0, '', 179, '{\"CN\":\"分配设置\",\"HK\":\"分配設置\",\"US\":\"Assignment Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1724, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::editSelfInfoPage', '', '修改信息显示', '', 195, 0, '', 616, '{\"CN\":\"修改信息显示\",\"HK\":\"修改信息顯示\",\"US\":\"Modification information display\"}');
INSERT INTO `shd_auth_rule` VALUES (1725, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::editSelfInfo', '', '修改信息', '', 195, 0, '', 617, '{\"CN\":\"修改信息\",\"HK\":\"修改信息\",\"US\":\"Modify Information\"}');
INSERT INTO `shd_auth_rule` VALUES (1726, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::getBlackList', '', '黑名单列表', '', 1914, 1, '/black-list', 669, '{\"CN\":\"黑名单列表\",\"HK\":\"黑名單列表\",\"US\":\"Blacklist List\"}');
INSERT INTO `shd_auth_rule` VALUES (1727, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController::removeBlackList', '', '移除黑名单', '', 195, 0, '', 618, '{\"CN\":\"移除黑名单\",\"HK\":\"移除黑名單\",\"US\":\"Remove blacklist\"}');
INSERT INTO `shd_auth_rule` VALUES (1729, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertificontroller::alipay_three_type', '', '获取三要素认证类型', '', 1336, 0, '', 110, '{\"CN\":\"获取三要素认证类型\",\"HK\":\"獲取三要素認證類型\",\"US\":\"Obtain three-factor authentication type\"}');
INSERT INTO `shd_auth_rule` VALUES (1731, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::deleteCancelRequest', '', '删除取消请求', '', 1507, 0, '', 187, '{\"CN\":\"删除取消请求\",\"HK\":\"刪除取消請求\",\"US\":\"Delete cancellation request\"}');
INSERT INTO `shd_auth_rule` VALUES (1732, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::searchPage', '', '可配置选项组搜索产品类型', '', 1490, 0, '', 440, '{\"CN\":\"可配置选项组搜索产品类型\",\"HK\":\"可配置選項組搜索產品類型\",\"US\":\"Configurable option group search product type\"}');
INSERT INTO `shd_auth_rule` VALUES (1733, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getYearIncomeStatisticsForChart', '', '年度收入统计--图表数据', '', 1698, 0, '', 708, '{\"CN\":\"年度收入统计--图表数据\",\"HK\":\"年度收入統計--圖表數據\",\"US\":\"Annual Income Statistics-Chart Data\"}');
INSERT INTO `shd_auth_rule` VALUES (1734, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::getNewClientStatistics', '', '新客户统计', '', 1897, 0, '', 696, '{\"CN\":\"新客户统计\",\"HK\":\"新客戶統計\",\"US\":\"New Client Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (1735, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::productIncome', '', '产品收入', '', 1897, 0, '', 697, '{\"CN\":\"产品收入\",\"HK\":\"產品收入\",\"US\":\"Product Revenue\"}');
INSERT INTO `shd_auth_rule` VALUES (1736, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController::rankForwardClient', '', '收入排名', '', 1897, 0, '', 698, '{\"CN\":\"收入排名\",\"HK\":\"收入排名\",\"US\":\"Revenue Ranking\"}');
INSERT INTO `shd_auth_rule` VALUES (1738, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::postToggleVersion', '', '切换版本', '', 1915, 0, '', 674, '{\"CN\":\"切换版本\",\"HK\":\"切換版本\",\"US\":\"Switch version\"}');
INSERT INTO `shd_auth_rule` VALUES (1739, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::editServer', '', '修改服务器', '', 21, 0, '', 432, '{\"CN\":\"修改服务器\",\"HK\":\"修改服務器\",\"US\":\"Modify Server\"}');
INSERT INTO `shd_auth_rule` VALUES (1740, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::addServer', '', '添加服务器', '', 21, 0, '', 433, '{\"CN\":\"添加服务器\",\"HK\":\"添加服務器\",\"US\":\"Add Server\"}');
INSERT INTO `shd_auth_rule` VALUES (1741, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::delServer', '', '删除服务器', '', 21, 0, '', 434, '{\"CN\":\"删除服务器\",\"HK\":\"刪除服務器\",\"US\":\"Delete Server\"}');
INSERT INTO `shd_auth_rule` VALUES (1742, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::refreshAllServerStatus', '', '刷新所有服务器状态', '', 21, 0, '', 435, '{\"CN\":\"刷新所有服务器状态\",\"HK\":\"刷新所有服務器狀態\",\"US\":\"Refresh all server status\"}');
INSERT INTO `shd_auth_rule` VALUES (1743, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::refreshServerStatus', '', '获取服务器状态', '', 21, 0, '', 436, '{\"CN\":\"获取服务器状态\",\"HK\":\"獲取服務器狀態\",\"US\":\"Get server status\"}');
INSERT INTO `shd_auth_rule` VALUES (1744, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::serverDetail', '', '服务器详情', '', 21, 0, '', 437, '{\"CN\":\"服务器详情\",\"HK\":\"服務器詳情\",\"US\":\"Server Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1745, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Salecontroller::saleRecordsNew', '', '获取销售客户购买记录(新)', '', 1454, 0, '', 50, '{\"CN\":\"获取销售客户购买记录(新)\",\"HK\":\"獲取銷售客戶購買記錄(新)\",\"US\":\"Get sales customer purchase records (new)\"}');
INSERT INTO `shd_auth_rule` VALUES (1746, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::getSearchParams', '', '获取营销推送筛选条件', '', 1864, 0, '', 59, '{\"CN\":\"获取营销推送筛选条件\",\"HK\":\"獲取營銷推送篩選條件\",\"US\":\"Get marketing push filter criteria\"}');
INSERT INTO `shd_auth_rule` VALUES (1747, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController', '', '魔方财务接口管理', '', 1899, 0, '', 761, '{\"CN\":\"魔方财务接口管理\",\"HK\":\"魔方財務接口管理\",\"US\":\"Mofang Financial Interface Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1748, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::createApi', '', '添加魔方财务API', '', 1747, 0, '', 762, '{\"CN\":\"添加魔方财务API\",\"HK\":\"添加魔方財務API\",\"US\":\"Add Rubik\'s Cube Finance API\"}');
INSERT INTO `shd_auth_rule` VALUES (1749, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::modifyApi', '', '修改魔方财务API', '', 1747, 0, '', 763, '{\"CN\":\"修改魔方财务API\",\"HK\":\"修改魔方財務API\",\"US\":\"Modify Rubik\'s Cube Finance API\"}');
INSERT INTO `shd_auth_rule` VALUES (1750, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::detail', '', '魔方财务API详情', '', 1747, 0, '', 764, '{\"CN\":\"魔方财务API详情\",\"HK\":\"魔方財務API詳情\",\"US\":\"Mofang Finance API Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1751, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::deleteApi', '', '删除魔方财务API', '', 1747, 0, '', 765, '{\"CN\":\"删除魔方财务API\",\"HK\":\"刪除魔方財務API\",\"US\":\"Delete Rubik\'s Cube Finance API\"}');
INSERT INTO `shd_auth_rule` VALUES (1752, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::index', '', '魔方财务API列表', '', 1747, 0, '', 766, '{\"CN\":\"魔方财务API列表\",\"HK\":\"魔方財務API列表\",\"US\":\"Mofang Finance API List\"}');
INSERT INTO `shd_auth_rule` VALUES (1753, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::refreshStatus', '', '刷新魔方财务API状态', '', 1747, 0, '', 767, '{\"CN\":\"刷新魔方财务API状态\",\"HK\":\"刷新魔方財務API狀態\",\"US\":\"Refresh Rubik\'s Cube Finance API Status\"}');
INSERT INTO `shd_auth_rule` VALUES (1755, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getUpstreamProducts', '', '获取上游产品', '', 5, 0, '', 483, '{\"CN\":\"获取上游产品\",\"HK\":\"獲取上游產品\",\"US\":\"Get upstream products\"}');
INSERT INTO `shd_auth_rule` VALUES (1756, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::syncProductInfo', '', '同步上游产品信息', '', 5, 0, '', 484, '{\"CN\":\"同步上游产品信息\",\"HK\":\"同步上游產品信息\",\"US\":\"Synchronize upstream product information\"}');
INSERT INTO `shd_auth_rule` VALUES (1757, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::addRechargeInvoice', '', '创建充值账单', '', 1280, 0, '', 9, '{\"CN\":\"创建充值账单\",\"HK\":\"創建充值賬單\",\"US\":\"Create a recharge bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1758, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::getUpstreamPrice', '', '获取上游产品成本价', '', 5, 0, '', 485, '{\"CN\":\"获取上游产品成本价\",\"HK\":\"獲取上游產品成本價\",\"US\":\"Get the cost price of upstream products\"}');
INSERT INTO `shd_auth_rule` VALUES (1759, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::addOptionsPage', '', '添加可配置选项页面', '', 1490, 0, '', 441, '{\"CN\":\"添加可配置选项页面\",\"HK\":\"添加可配置選項頁面\",\"US\":\"Add a configurable option page\"}');
INSERT INTO `shd_auth_rule` VALUES (1760, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Dcimcontroller::novncpage', '', 'vnc页面', '', 1397, 0, '', 155, '{\"CN\":\"vnc页面\",\"HK\":\"vnc頁面\",\"US\":\"vnc page\"}');
INSERT INTO `shd_auth_rule` VALUES (1762, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController', '', '开发者应用', '', 5, 0, '', 486, '{\"CN\":\"开发者应用\",\"HK\":\"開發者應用\",\"US\":\"Developer App\"}');
INSERT INTO `shd_auth_rule` VALUES (1763, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperAppList', '', '应用列表', '', 1762, 1, '/application-list?appstatus=1', 488, '{\"CN\":\"应用列表\",\"HK\":\"應用列表\",\"US\":\"Application List\"}');
INSERT INTO `shd_auth_rule` VALUES (1764, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperAppList', '', '应用审核', '', 1762, 1, '/appcheck-list?appstatus=2', 489, '{\"CN\":\"应用审核\",\"HK\":\"應用審核\",\"US\":\"App Review\"}');
INSERT INTO `shd_auth_rule` VALUES (1765, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperDetail', '', '获取开发者详情', '', 1762, 0, '', 490, '{\"CN\":\"获取开发者详情\",\"HK\":\"獲取開發者詳情\",\"US\":\"Get developer details\"}');
INSERT INTO `shd_auth_rule` VALUES (1766, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::postCheckDeveloper', '', '审核开发者', '', 1762, 0, '', 491, '{\"CN\":\"审核开发者\",\"HK\":\"審核開發者\",\"US\":\"Audit Developer\"}');
INSERT INTO `shd_auth_rule` VALUES (1767, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::postToggleRetired', '', '上/下架应用', '', 1762, 0, '', 492, '{\"CN\":\"上\\/下架应用\",\"HK\":\"上\\/下架應用\",\"US\":\"Up\\/Down App\"}');
INSERT INTO `shd_auth_rule` VALUES (1768, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperApp', '', '应用详情', '', 1762, 0, '', 493, '{\"CN\":\"应用详情\",\"HK\":\"應用詳情\",\"US\":\"Application Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1769, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getAppAccounts', '', '交易流水(开发者应用)', '', 1762, 0, '', 494, '{\"CN\":\"交易流水(开发者应用)\",\"HK\":\"交易流水(開發者應用)\",\"US\":\"Transaction Flow (Developer App)\"}');
INSERT INTO `shd_auth_rule` VALUES (1770, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::postCheckDeveloperApp', '', '审核通过/驳回应用', '', 1762, 0, '', 495, '{\"CN\":\"审核通过\\/驳回应用\",\"HK\":\"審核通過\\/駁回​​應用\",\"US\":\"Approved\\/Rejected App\"}');
INSERT INTO `shd_auth_rule` VALUES (1771, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::getDeveloperAppLogs', '', '开发者应用日志', '', 1762, 0, '', 496, '{\"CN\":\"开发者应用日志\",\"HK\":\"開發者應用日誌\",\"US\":\"Developer Application Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1772, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Systemcontroller::getupdatecontent', '', '获取版本更新内容', '', 1915, 0, '', 678, '{\"CN\":\"获取版本更新内容\",\"HK\":\"獲取版本更新內容\",\"US\":\"Get version update content\"}');
INSERT INTO `shd_auth_rule` VALUES (1773, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller::tableList', '', '条件搜索页面', '', 1329, 0, '', 836, '{\"CN\":\"条件搜索页面\",\"HK\":\"條件搜索頁面\",\"US\":\"Conditional Search Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1774, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller::search', '', '搜索', '', 1329, 0, '', 837, '{\"CN\":\"搜索\",\"HK\":\"搜索\",\"US\":\"Search\"}');
INSERT INTO `shd_auth_rule` VALUES (1776, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::userProductInvoice', '', '用户产品账单列表', '', 404, 0, '', 234, '{\"CN\":\"用户产品账单列表\",\"HK\":\"用戶產品賬單列表\",\"US\":\"User Product Billing List\"}');
INSERT INTO `shd_auth_rule` VALUES (1777, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::userProductaccounts', '', '交易流水列表', '', 404, 0, '', 235, '{\"CN\":\"交易流水列表\",\"HK\":\"交易流水列表\",\"US\":\"Transaction Flow List\"}');
INSERT INTO `shd_auth_rule` VALUES (1778, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::selectcates', '', '返回可用文件列表', '', 364, 0, '', 458, '{\"CN\":\"返回可用文件列表\",\"HK\":\"返回可用文件列表\",\"US\":\"Return to the list of available files\"}');
INSERT INTO `shd_auth_rule` VALUES (1779, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::downloadcates', '', '返回文件下载列表', '', 364, 0, '', 459, '{\"CN\":\"返回文件下载列表\",\"HK\":\"返回文件下載列表\",\"US\":\"Return to file download list\"}');
INSERT INTO `shd_auth_rule` VALUES (1780, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postUploadFile', '', '上传文件', '', 420, 0, '', 533, '{\"CN\":\"上传文件\",\"HK\":\"上傳文件\",\"US\":\"Upload file\"}');
INSERT INTO `shd_auth_rule` VALUES (1781, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getFile', '', '下载文件', '', 420, 0, '', 535, '{\"CN\":\"下载文件\",\"HK\":\"下載文件\",\"US\":\"Download File\"}');
INSERT INTO `shd_auth_rule` VALUES (1782, 1, 'admin', 'admin_url', 'app\\admin\\controller\\WithdrawController::postWithdraw', '', '审核提现记录', '', 1588, 0, '', 241, '{\"CN\":\"审核提现记录\",\"HK\":\"審核提現記錄\",\"US\":\"Audit and withdrawal record\"}');
INSERT INTO `shd_auth_rule` VALUES (1783, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportController::get_order', '', '获取用户id', '', 1337, 0, '', 126, '{\"CN\":\"获取用户id\",\"HK\":\"獲取用戶id\",\"US\":\"Get user id\"}');
INSERT INTO `shd_auth_rule` VALUES (1784, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AccountController::createInvoice', '', '添加交易流水获取账单', '', 409, 0, '', 203, '{\"CN\":\"添加交易流水获取账单\",\"HK\":\"添加交易流水獲取賬單\",\"US\":\"Add transaction flow to get bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1785, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postUpdateSort', '', '分类排序', '', 420, 0, '', 540, '{\"CN\":\"分类排序\",\"HK\":\"分類排序\",\"US\":\"Sort by Category\"}');
INSERT INTO `shd_auth_rule` VALUES (1786, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::getSendMethod', '', '营销信息-推送方式', '', 1864, 0, '', 60, '{\"CN\":\"营销信息-推送方式\",\"HK\":\"營銷信息-推送方式\",\"US\":\"Marketing Information-Push Method\"}');
INSERT INTO `shd_auth_rule` VALUES (1787, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::emailtemplateList', '', '邮件模板列表', '', 1864, 0, '', 61, '{\"CN\":\"邮件模板列表\",\"HK\":\"郵件模板列表\",\"US\":\"Mail template list\"}');
INSERT INTO `shd_auth_rule` VALUES (1788, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::getEmailTemplateParams', '', '营销推送方式下的邮件模板参数', '', 1864, 0, '', 62, '{\"CN\":\"营销推送方式下的邮件模板参数\",\"HK\":\"營銷推送方式下的郵件模板參數\",\"US\":\"Mail template parameters in marketing push mode\"}');
INSERT INTO `shd_auth_rule` VALUES (1789, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::sendSmsBefore', '', '发送短信息操作', '', 1864, 0, '', 63, '{\"CN\":\"发送短信息操作\",\"HK\":\"發送短信息操作\",\"US\":\"Send SMS Operation\"}');
INSERT INTO `shd_auth_rule` VALUES (1790, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::update_smslog', '', '更新日志', '', 1864, 0, '', 64, '{\"CN\":\"更新日志\",\"HK\":\"更新日誌\",\"US\":\"Update Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1791, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController::get_smslog', '', '获取日志', '', 1864, 0, '', 65, '{\"CN\":\"获取日志\",\"HK\":\"獲取日誌\",\"US\":\"Get Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1793, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DeveloperController::deleteDeveloperApp', '', '删除应用', '', 1762, 0, '', 487, '{\"CN\":\"删除应用\",\"HK\":\"刪除應用\",\"US\":\"Delete Application\"}');
INSERT INTO `shd_auth_rule` VALUES (1794, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::hostByUid', '', '单个客户产品列表', '', 13, 0, '', 12, '{\"CN\":\"单个客户产品列表\",\"HK\":\"單個客戶產品列表\",\"US\":\"Single Customer Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (1795, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::requestCancelReason', '', '取消请求原因管理', '', 1507, 0, '', 181, '{\"CN\":\"取消请求原因管理\",\"HK\":\"取消請求原因管理\",\"US\":\"Cancellation request reason management\"}');
INSERT INTO `shd_auth_rule` VALUES (1796, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::requestCancelReasonPost', '', '取消请求原因增加修改', '', 1507, 0, '', 182, '{\"CN\":\"取消请求原因增加修改\",\"HK\":\"取消請求原因增加修改\",\"US\":\"Add and modify the reason for the cancellation request\"}');
INSERT INTO `shd_auth_rule` VALUES (1797, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Indexcontroller::searchfornameList', '', '条件搜索', '', 1329, 0, '', 820, '{\"CN\":\"条件搜索\",\"HK\":\"條件搜索\",\"US\":\"Condition Search\"}');
INSERT INTO `shd_auth_rule` VALUES (1798, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OrderController::getClients', '', '获取用户', '', 390, 0, '', 133, '{\"CN\":\"获取用户\",\"HK\":\"獲取用戶\",\"US\":\"Get User\"}');
INSERT INTO `shd_auth_rule` VALUES (1799, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::getTicketDetailHost', '', '工单信息获取产品', '', 335, 0, '', 291, '{\"CN\":\"工单信息获取产品\",\"HK\":\"工單信息獲取產品\",\"US\":\"Ticket information acquisition product\"}');
INSERT INTO `shd_auth_rule` VALUES (1801, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::Index', '', '应用商店', '', 1898, 0, '', 769, '{\"CN\":\"应用商店\",\"HK\":\"應用商店\",\"US\":\"App Store\"}');
INSERT INTO `shd_auth_rule` VALUES (1802, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::marketLogin', '', '应用商店登录', '', 1898, 0, '', 770, '{\"CN\":\"应用商店登录\",\"HK\":\"應用商店登錄\",\"US\":\"App Store Login\"}');
INSERT INTO `shd_auth_rule` VALUES (1803, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::buy', '', '购买应用(选择产品配置)', '', 1898, 0, '', 771, '{\"CN\":\"购买应用(选择产品配置)\",\"HK\":\"購買應用(選擇產品配置)\",\"US\":\"Purchase application (select product configuration)\"}');
INSERT INTO `shd_auth_rule` VALUES (1804, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::changeBillingcycle', '', '选择付款周期获取金额', '', 1898, 0, '', 772, '{\"CN\":\"选择付款周期获取金额\",\"HK\":\"選擇付款週期獲取金額\",\"US\":\"Select the payment cycle to obtain the amount\"}');
INSERT INTO `shd_auth_rule` VALUES (1805, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::createInvoice', '', '创建订单(默认选择余额)', '', 1898, 0, '', 773, '{\"CN\":\"创建订单(默认选择余额)\",\"HK\":\"創建訂單(默認選擇餘額)\",\"US\":\"Create order (select balance by default)\"}');
INSERT INTO `shd_auth_rule` VALUES (1806, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::useCredit', '', '支付订单(切换支付方式:余额)', '', 1898, 0, '', 774, '{\"CN\":\"支付订单(切换支付方式:余额)\",\"HK\":\"支付訂單(切換支付方式:餘額)\",\"US\":\"Pay order (switch payment method: balance)\"}');
INSERT INTO `shd_auth_rule` VALUES (1807, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::changePayment', '', '支付订单(切换支付方式)', '', 1898, 0, '', 775, '{\"CN\":\"支付订单(切换支付方式)\",\"HK\":\"支付訂單(切換支付方式)\",\"US\":\"Pay the order (switch payment method)\"}');
INSERT INTO `shd_auth_rule` VALUES (1808, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::applyCredit', '', '余额支付', '', 1898, 0, '', 776, '{\"CN\":\"余额支付\",\"HK\":\"餘額支付\",\"US\":\"Balance Payment\"}');
INSERT INTO `shd_auth_rule` VALUES (1809, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::checkOrder', '', '检查支付状态', '', 1898, 0, '', 777, '{\"CN\":\"检查支付状态\",\"HK\":\"檢查支付狀態\",\"US\":\"Check payment status\"}');
INSERT INTO `shd_auth_rule` VALUES (1810, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::install', '', '安装应用', '', 1898, 0, '', 778, '{\"CN\":\"安装应用\",\"HK\":\"安裝應用\",\"US\":\"Install App\"}');
INSERT INTO `shd_auth_rule` VALUES (1811, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::uninstall', '', '卸载应用', '', 1898, 0, '', 779, '{\"CN\":\"卸载应用\",\"HK\":\"卸載應用\",\"US\":\"Uninstall Application\"}');
INSERT INTO `shd_auth_rule` VALUES (1812, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::marketLogout', '', '退出登录', '', 1898, 0, '', 780, '{\"CN\":\"退出登录\",\"HK\":\"退出登錄\",\"US\":\"Logout\"}');
INSERT INTO `shd_auth_rule` VALUES (1813, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::serverList', '', '魔方DCIM', '', 1876, 1, '/dcim', 413, '{\"CN\":\"魔方DCIM\",\"HK\":\"魔方DCIM\",\"US\":\"Cube DCIM\"}');
INSERT INTO `shd_auth_rule` VALUES (1814, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateFirstGroupsort', '', '一级分组排序修改', '', 5, 0, '', 477, '{\"CN\":\"一级分组排序修改\",\"HK\":\"一級分組排序修改\",\"US\":\"First level grouping and sorting modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1815, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateGroupsort', '', '产品分组排序修改', '', 5, 0, '', 478, '{\"CN\":\"产品分组排序修改\",\"HK\":\"產品分組排序修改\",\"US\":\"Product grouping and sorting modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1816, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::updateProductsort', '', '产品排序修改', '', 5, 0, '', 479, '{\"CN\":\"产品排序修改\",\"HK\":\"產品排序修改\",\"US\":\"Product order modification\"}');
INSERT INTO `shd_auth_rule` VALUES (1817, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editFirstGroupPage', '', '一级分组添加页', '', 5, 0, '', 480, '{\"CN\":\"一级分组添加页\",\"HK\":\"一級分組添加頁\",\"US\":\"First level grouping add page\"}');
INSERT INTO `shd_auth_rule` VALUES (1818, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::saveProductFirstGroup', '', '保存一级分组信息', '', 5, 0, '', 481, '{\"CN\":\"保存一级分组信息\",\"HK\":\"保存一級分組信息\",\"US\":\"Save the first level grouping information\"}');
INSERT INTO `shd_auth_rule` VALUES (1819, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::deleteFirstGroup', '', '删除一级组', '', 5, 0, '', 482, '{\"CN\":\"删除一级组\",\"HK\":\"刪除一級組\",\"US\":\"Delete first level group\"}');
INSERT INTO `shd_auth_rule` VALUES (1821, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getGetways', '', '系统后台支付方式', '', 1843, 0, '', 839, '{\"CN\":\"系统后台支付方式\",\"HK\":\"系統後台支付方式\",\"US\":\"System background payment method\"}');
INSERT INTO `shd_auth_rule` VALUES (1822, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::infoNotice', '', '系统后台消息通知', '', 1843, 0, '', 840, '{\"CN\":\"系统后台消息通知\",\"HK\":\"系統後台消息通知\",\"US\":\"System background message notification\"}');
INSERT INTO `shd_auth_rule` VALUES (1823, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getEmailTem', '', '系统邮件模板列表', '', 1843, 0, '', 841, '{\"CN\":\"系统邮件模板列表\",\"HK\":\"系統郵件模板列表\",\"US\":\"System Mail Template List\"}');
INSERT INTO `shd_auth_rule` VALUES (1824, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getClientGroups', '', '系统用户分组', '', 1843, 0, '', 842, '{\"CN\":\"系统用户分组\",\"HK\":\"系統用戶分組\",\"US\":\"System User Group\"}');
INSERT INTO `shd_auth_rule` VALUES (1825, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getProductList', '', '商品列表', '', 1843, 0, '', 843, '{\"CN\":\"商品列表\",\"HK\":\"商品列表\",\"US\":\"Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (1826, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getPromoCode', '', '优惠码', '', 1843, 0, '', 844, '{\"CN\":\"优惠码\",\"HK\":\"優惠碼\",\"US\":\"Promotion Code\"}');
INSERT INTO `shd_auth_rule` VALUES (1827, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getHostList', '', '客户产品列表', '', 1843, 0, '', 845, '{\"CN\":\"客户产品列表\",\"HK\":\"客戶產品列表\",\"US\":\"Customer Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (1828, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getSmsCountry', '', '国家列表', '', 1843, 0, '', 846, '{\"CN\":\"国家列表\",\"HK\":\"國家列表\",\"US\":\"Country List\"}');
INSERT INTO `shd_auth_rule` VALUES (1829, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::getProductConfigOptions', '', '可配置项', '', 1843, 0, '', 847, '{\"CN\":\"可配置项\",\"HK\":\"可配置項\",\"US\":\"Configurable Items\"}');
INSERT INTO `shd_auth_rule` VALUES (1830, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::editUpperPost', '', '资源修改提交', '', 1610, 0, '', 732, '{\"CN\":\"资源修改提交\",\"HK\":\"資源修改提交\",\"US\":\"Resource Modification Submit\"}');
INSERT INTO `shd_auth_rule` VALUES (1831, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::ipmiStatus', '', 'IPMI获取电源状态', '', 1610, 0, '', 733, '{\"CN\":\"IPMI获取电源状态\",\"HK\":\"IPMI獲取電源狀態\",\"US\":\"IPMI obtains power status\"}');
INSERT INTO `shd_auth_rule` VALUES (1832, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::ipmiOn', '', 'IPMI开机', '', 1610, 0, '', 734, '{\"CN\":\"IPMI开机\",\"HK\":\"IPMI開機\",\"US\":\"IPMI boot\"}');
INSERT INTO `shd_auth_rule` VALUES (1833, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::ipmiOff', '', 'IPMI关机', '', 1610, 0, '', 735, '{\"CN\":\"IPMI关机\",\"HK\":\"IPMI關機\",\"US\":\"IPMI shutdown\"}');
INSERT INTO `shd_auth_rule` VALUES (1834, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::ipmiReboot', '', 'IPMI重启', '', 1610, 0, '', 736, '{\"CN\":\"IPMI重启\",\"HK\":\"IPMI重啟\",\"US\":\"IPMI restart\"}');
INSERT INTO `shd_auth_rule` VALUES (1835, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::ipmiVnc', '', 'IPMI VNC', '', 1610, 0, '', 737, '{\"CN\":\"IPMI VNC\",\"HK\":\"IPMI VNC\",\"US\":\"IPMI VNC\"}');
INSERT INTO `shd_auth_rule` VALUES (1836, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientStatus', '', 'DCIM客户端获取电源状态', '', 1610, 0, '', 738, '{\"CN\":\"DCIM客户端获取电源状态\",\"HK\":\"DCIM客戶端獲取電源狀態\",\"US\":\"DCIM client obtains power status\"}');
INSERT INTO `shd_auth_rule` VALUES (1837, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientOn', '', 'DCIM客户端开机', '', 1610, 0, '', 739, '{\"CN\":\"DCIM客户端开机\",\"HK\":\"DCIM客戶端開機\",\"US\":\"DCIM client power on\"}');
INSERT INTO `shd_auth_rule` VALUES (1838, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientOff', '', 'DCIM客户端关机', '', 1610, 0, '', 740, '{\"CN\":\"DCIM客户端关机\",\"HK\":\"DCIM客戶端關機\",\"US\":\"DCIM client shutdown\"}');
INSERT INTO `shd_auth_rule` VALUES (1839, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientReboot', '', 'DCIM客户端重启', '', 1610, 0, '', 741, '{\"CN\":\"DCIM客户端重启\",\"HK\":\"DCIM客戶端重啟\",\"US\":\"DCIM client restart\"}');
INSERT INTO `shd_auth_rule` VALUES (1840, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientVnc', '', 'DCIM客户端VNC', '', 1610, 0, '', 742, '{\"CN\":\"DCIM客户端VNC\",\"HK\":\"DCIM客戶端VNC\",\"US\":\"DCIM Client VNC\"}');
INSERT INTO `shd_auth_rule` VALUES (1841, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientVncPage', '', 'novnc页面', '', 1610, 0, '', 743, '{\"CN\":\"novnc页面\",\"HK\":\"novnc頁面\",\"US\":\"novnc page\"}');
INSERT INTO `shd_auth_rule` VALUES (1842, 1, 'admin', 'admin_url', 'app\\admin\\controller\\PluginController::plSort', '', '修改插件排序', '', 11, 0, '', 260, '{\"CN\":\"修改插件排序\",\"HK\":\"修改插件排序\",\"US\":\"Modify plug-in sorting\"}');
INSERT INTO `shd_auth_rule` VALUES (1843, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller', '', '基础数据', '', 0, 0, '', 838, '{\"CN\":\"基础数据\",\"HK\":\"基礎數據\",\"US\":\"Basic Data\"}');
INSERT INTO `shd_auth_rule` VALUES (1844, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::emptyUpper', '', '资源空闲', '', 1610, 0, '', 744, '{\"CN\":\"资源空闲\",\"HK\":\"資源空閒\",\"US\":\"Resource is free\"}');
INSERT INTO `shd_auth_rule` VALUES (1845, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::allotUpper', '', '资源分配', '', 1610, 0, '', 745, '{\"CN\":\"资源分配\",\"HK\":\"資源分配\",\"US\":\"Resource Allocation\"}');
INSERT INTO `shd_auth_rule` VALUES (1847, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::detail', '', '应用详情', '', 1898, 0, '', 781, '{\"CN\":\"应用详情\",\"HK\":\"應用詳情\",\"US\":\"Application Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1849, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getapilog', '', 'API日志', '', 1916, 1, '/api-log', 683, '{\"CN\":\"API日志\",\"HK\":\"API日誌\",\"US\":\"API Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1850, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController::editStock', '', '保存产品库存', '', 364, 0, '', 454, '{\"CN\":\"保存产品库存\",\"HK\":\"保存產品庫存\",\"US\":\"Save product inventory\"}');
INSERT INTO `shd_auth_rule` VALUES (1851, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientReinstall', '', '重装系统', '', 1610, 0, '', 746, '{\"CN\":\"重装系统\",\"HK\":\"重裝系統\",\"US\":\"Reinstall the system\"}');
INSERT INTO `shd_auth_rule` VALUES (1852, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientCrackPass', '', '破解密码', '', 1610, 0, '', 747, '{\"CN\":\"破解密码\",\"HK\":\"破解密碼\",\"US\":\"Crack the password\"}');
INSERT INTO `shd_auth_rule` VALUES (1853, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientCancelReinstall', '', '取消重装/破解密码', '', 1610, 0, '', 748, '{\"CN\":\"取消重装\\/破解密码\",\"HK\":\"取消重裝\\/破解密碼\",\"US\":\"Cancel reinstallation\\/Crack password\"}');
INSERT INTO `shd_auth_rule` VALUES (1854, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientReinstallStatus', '', '获取重装/破解密码状态', '', 1610, 0, '', 749, '{\"CN\":\"获取重装\\/破解密码状态\",\"HK\":\"獲取重裝\\/破解密碼狀態\",\"US\":\"Get reinstallation\\/crack password status\"}');
INSERT INTO `shd_auth_rule` VALUES (1855, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController::dcimClientGetOs', '', '获取操作系统', '', 1610, 0, '', 750, '{\"CN\":\"获取操作系统\",\"HK\":\"獲取操作系統\",\"US\":\"Get Operating System\"}');
INSERT INTO `shd_auth_rule` VALUES (1857, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::update', '', '更新应用', '', 1898, 0, '', 782, '{\"CN\":\"更新应用\",\"HK\":\"更新應用\",\"US\":\"Update Application\"}');
INSERT INTO `shd_auth_rule` VALUES (1859, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::testLink', '', '服务器连接测试', '', 528, 0, '', 400, '{\"CN\":\"服务器连接测试\",\"HK\":\"服務器連接測試\",\"US\":\"Server Connection Test\"}');
INSERT INTO `shd_auth_rule` VALUES (1860, 1, 'admin', 'admin_url', '', '', '客户管理', '', 1, 1, '', 4, '{\"CN\":\"客户管理\",\"HK\":\"客戶管理\",\"US\":\"Customer Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1861, 1, 'admin', 'admin_url', '', '', '我的业绩', '', 1, 1, '', 44, '{\"CN\":\"我的业绩\",\"HK\":\"我的業績\",\"US\":\"My Performance\"}');
INSERT INTO `shd_auth_rule` VALUES (1862, 1, 'admin', 'admin_url', '', '', '客户跟踪', '', 1861, 0, '', 45, '{\"CN\":\"客户跟踪\",\"HK\":\"客戶跟踪\",\"US\":\"Customer Tracking\"}');
INSERT INTO `shd_auth_rule` VALUES (1863, 1, 'admin', 'admin_url', '', '', '运营管理', '', 1, 1, '', 51, '{\"CN\":\"运营管理\",\"HK\":\"運營管理\",\"US\":\"Operation Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1864, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SendMessageBatchController', '', '营销推送', '', 1863, 1, '/marketing-push', 52, '{\"CN\":\"营销推送\",\"HK\":\"營銷推送\",\"US\":\"Marketing Push\"}');
INSERT INTO `shd_auth_rule` VALUES (1866, 1, 'admin', 'admin_url', '', '', '订单', '', 2, 1, '', 123, '{\"CN\":\"订单\",\"HK\":\"訂單\",\"US\":\"Order\"}');
INSERT INTO `shd_auth_rule` VALUES (1867, 1, 'admin', 'admin_url', '', '', '业务', '', 2, 1, '', 147, '{\"CN\":\"业务\",\"HK\":\"業務\",\"US\":\"Business\"}');
INSERT INTO `shd_auth_rule` VALUES (1868, 1, 'admin', 'admin_url', '', '', '财务记录', '', 3, 1, '', 189, '{\"CN\":\"财务记录\",\"HK\":\"財務記錄\",\"US\":\"Financial Records\"}');
INSERT INTO `shd_auth_rule` VALUES (1869, 1, 'admin', 'admin_url', '', '', '审核管理', '', 3, 1, '', 239, '{\"CN\":\"审核管理\",\"HK\":\"審核管理\",\"US\":\"Audit Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1870, 1, 'admin', 'admin_url', '', '', '充值记录', '', 1868, 0, '', 190, '{\"CN\":\"充值记录\",\"HK\":\"充值記錄\",\"US\":\"Recharge Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1871, 1, 'admin', 'admin_url', '', '', '退款记录', '', 1868, 0, '', 191, '{\"CN\":\"退款记录\",\"HK\":\"退款記錄\",\"US\":\"Refund Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1872, 1, 'admin', 'admin_url', '', '', '合同管理', '', 1869, 0, '', 242, '{\"CN\":\"合同管理\",\"HK\":\"合同管理\",\"US\":\"Contract Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1873, 1, 'admin', 'admin_url', '', '', '发票管理', '', 1869, 0, '', 243, '{\"CN\":\"发票管理\",\"HK\":\"發票管理\",\"US\":\"Invoice Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1874, 1, 'admin', 'admin_url', '', '', '我的工单', '', 335, 0, '', 300, '{\"CN\":\"我的工单\",\"HK\":\"我的工單​​\",\"US\":\"My Ticket\"}');
INSERT INTO `shd_auth_rule` VALUES (1875, 1, 'admin', 'admin_url', '', '', '商品配置', '', 5, 1, '', 360, '{\"CN\":\"商品配置\",\"HK\":\"商品配置\",\"US\":\"Commodity Configuration\"}');
INSERT INTO `shd_auth_rule` VALUES (1876, 1, 'admin', 'admin_url', '', '', '自动化接口', '', 5, 1, '', 398, '{\"CN\":\"自动化接口\",\"HK\":\"自動化接口\",\"US\":\"Automation Interface\"}');
INSERT INTO `shd_auth_rule` VALUES (1878, 1, 'admin', 'admin_url', '', '', '设置', '', 5, 1, '', 422, '{\"CN\":\"设置\",\"HK\":\"設置\",\"US\":\"Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1879, 1, 'admin', 'admin_url', '', '', '全局可配置项', '', 1878, 1, '/configurable-option', 423, '{\"CN\":\"全局可配置项\",\"HK\":\"全局可配置項\",\"US\":\"Globally configurable items\"}');
INSERT INTO `shd_auth_rule` VALUES (1882, 1, 'admin', 'admin_url', '', '', '客户资源池', '', 1860, 1, '/customer-resources', 43, '{\"CN\":\"客户资源池\",\"HK\":\"客戶資源池\",\"US\":\"Customer Resource Pool\"}');
INSERT INTO `shd_auth_rule` VALUES (1889, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getLocal', '', '本地化', '', 1910, 0, '/general-settings/local', 581, '{\"CN\":\"本地化\",\"HK\":\"本地化\",\"US\":\"Localization\"}');
INSERT INTO `shd_auth_rule` VALUES (1891, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::registerloginpage', '', '注册登录', '', 1910, 0, '/general-settings/login-setting', 582, '{\"CN\":\"注册登录\",\"HK\":\"註冊登錄\",\"US\":\"Register and Login\"}');
INSERT INTO `shd_auth_rule` VALUES (1892, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::invoicePage', '', '充值与财务', '', 1902, 1, '/general-settings/finance', 270, '{\"CN\":\"充值与财务\",\"HK\":\"充值與財務\",\"US\":\"Recharge and Finance\"}');
INSERT INTO `shd_auth_rule` VALUES (1893, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getApiConfig', '', 'API', '', 1910, 0, '/general-settings/source-api', 583, '{\"CN\":\"API\",\"HK\":\"API\",\"US\":\"API\"}');
INSERT INTO `shd_auth_rule` VALUES (1894, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CronController', '', '定时任务', '', 1910, 1, '/automatic-tasks', 577, '{\"CN\":\"定时任务\",\"HK\":\"定時任務\",\"US\":\"Timed Task\"}');
INSERT INTO `shd_auth_rule` VALUES (1897, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ReportsController', '', '功能', '', 0, 1, '/timing-results', 358, '{\"CN\":\"功能\",\"HK\":\"功能\",\"US\":\"Function\"}');
INSERT INTO `shd_auth_rule` VALUES (1895, 1, 'admin', 'admin_url', 'app-store', '', '资源与商店', '', 0, 1, '/app-store/app-list', 768, '{\"CN\":\"资源与商店\",\"HK\":\"資源與商店\",\"US\":\"Resources And Stores\"}');
INSERT INTO `shd_auth_rule` VALUES (1898, 1, 'admin', 'admin_url', 'app-store', '', '应用商店', '', 1895, 1, '/app-store/app-list', 768, '{\"CN\":\"应用商店\",\"HK\":\"應用商店\",\"US\":\"App Store\"}');
INSERT INTO `shd_auth_rule` VALUES (1899, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UpperReachesController', '', '上下游', '', 1895, 1, '/zjmf-api', 714, '{\"CN\":\"上下游\",\"HK\":\"上下游\",\"US\":\"Upstream And Downstream\"}');
INSERT INTO `shd_auth_rule` VALUES (1900, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController', '', '发票和合同', '', 3, 1, '', 244, '{\"CN\":\"发票和合同\",\"HK\":\"發票和合同\",\"US\":\"Invoices and Contracts\"}');
INSERT INTO `shd_auth_rule` VALUES (1901, 1, 'admin', 'admin_url', 'setting', '', '客户设置', '', 7, 1, '', 87, '{\"CN\":\"客户设置\",\"HK\":\"客户設置\",\"US\":\"Customer Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1902, 1, 'admin', 'admin_url', 'accountset', '', '财务设置', '', 7, 1, '', 249, '{\"CN\":\"财务设置\",\"HK\":\"财务設置\",\"US\":\"Financial Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1904, 1, 'admin', 'admin_url', '', '', '反馈', '', 0, 1, '', 769, '{\"CN\":\"反馈\",\"HK\":\"迴響\",\"US\":\"Feedback\"}');
INSERT INTO `shd_auth_rule` VALUES (1905, 1, 'admin', 'admin_url', '', '', '需求', '', 1904, 1, 'https://bbs.idcsmart.com/forum.php?mod=forumdisplay&fid=10', 249, '{\"CN\":\"需求\",\"HK\":\"需求\",\"US\":\"Demand\"}');
INSERT INTO `shd_auth_rule` VALUES (1906, 1, 'admin', 'admin_url', '', '', '互助', '', 1904, 1, 'https://bbs.idcsmart.com/forum.php?mod=forumdisplay&fid=10', 250, '{\"CN\":\"互助\",\"HK\":\"互助\",\"US\":\"Help\"}');
INSERT INTO `shd_auth_rule` VALUES (1907, 1, 'admin', 'admin_url', '', '', 'BUG反馈', '', 1904, 1, 'https://bbs.idcsmart.com/forum.php?mod=forumdisplay&fid=50&filter=typeid&typeid=62', 251, '{\"CN\":\"BUG反馈\",\"HK\":\"BUG迴響\",\"US\":\"Bug Feedback\"}');
INSERT INTO `shd_auth_rule` VALUES (1910, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController', '', '基础设置', '', 1909, 1, '', 572, '{\"CN\":\"基础设置\",\"HK\":\"基礎設置\",\"US\":\"Basic Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1912, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserController', '', '人员管理', '', 1909, 1, '', 592, '{\"CN\":\"人员管理\",\"HK\":\"人員管理\",\"US\":\"Personnel Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1913, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController', '', '短信邮件设置', '', 1909, 1, '', 626, '{\"CN\":\"短信邮件设置\",\"HK\":\"短信郵件設置\",\"US\":\"SMS mail settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1914, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController', '', '安全相关', '', 1909, 1, '', 663, '{\"CN\":\"安全相关\",\"HK\":\"安全相關\",\"US\":\"Security related\"}');
INSERT INTO `shd_auth_rule` VALUES (1915, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController', '', '系统相关', '', 1909, 1, '', 670, '{\"CN\":\"系统相关\",\"HK\":\"系統相關\",\"US\":\"System Related\"}');
INSERT INTO `shd_auth_rule` VALUES (1916, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController', '', '日志', '', 1909, 1, '', 679, '{\"CN\":\"日志\",\"HK\":\"日誌\",\"US\":\"Log\"}');
INSERT INTO `shd_auth_rule` VALUES (1920, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimCloudController::serverList', '', '魔方云', '', 1876, 1, '/zjmfcloud', 420, '{\"CN\":\"魔方云\",\"HK\":\"魔方雲\",\"US\":\"Magic Cube Cloud\"}');
INSERT INTO `shd_auth_rule` VALUES (1921, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::invoicePage', '', '产品分类', '', 1878, 0, '/general-settings/class', 425, '{\"CN\":\"产品分类\",\"HK\":\"產品分類\",\"US\":\"Product Classification\"}');
INSERT INTO `shd_auth_rule` VALUES (1922, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessagecontroller::sendsmstest', '', '测试短信', '', 531, 0, '', 644, '{\"CN\":\"测试短信\",\"HK\":\"測試短信\",\"US\":\"Test SMS\"}');
INSERT INTO `shd_auth_rule` VALUES (1923, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SaleController::getTimetype', '', '获取时间类型', '', 1861, 0, '', 46, '{\"CN\":\"获取时间类型\",\"HK\":\"獲取時間類型\",\"US\":\"Get Time Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1924, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller', '', '我的应用', '', 1898, 1, '/app-store', 783, '{\"CN\":\"我的应用\",\"HK\":\"我的應用\",\"US\":\"My Application\"}');
INSERT INTO `shd_auth_rule` VALUES (1928, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::putLicense', '', '更换授权码', '', 1909, 0, '', 693, '{\"CN\":\"更换授权码\",\"HK\":\"更換授權碼\",\"US\":\"Replace authorization code\"}');
INSERT INTO `shd_auth_rule` VALUES (1929, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getLastVersion', '', '下个版本', '', 1909, 0, '', 694, '{\"CN\":\"下个版本\",\"HK\":\"下個版本\",\"US\":\"Next version\"}');
INSERT INTO `shd_auth_rule` VALUES (1930, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::getcaptcha_page', '', '验证码设置', '', 1914, 1, '/general-settings/captcha', 665, '{\"CN\":\"验证码设置\",\"HK\":\"驗證碼設置\",\"US\":\"Verification Code Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (1931, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralcontroller::postregister_login_captcha', '', '验证码设置提交', '', 1914, 0, '', 666, '{\"CN\":\"验证码设置提交\",\"HK\":\"驗證碼設置提交\",\"US\":\"Verification code setting submission\"}');
INSERT INTO `shd_auth_rule` VALUES (1932, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::rankingList', '', '应用排行榜', '', 1898, 0, '', 784, '{\"CN\":\"应用排行榜\",\"HK\":\"應用排行榜\",\"US\":\"App Ranking\"}');
INSERT INTO `shd_auth_rule` VALUES (1933, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::myApps', '', '我的应用', '', 1898, 0, '', 785, '{\"CN\":\"我的应用\",\"HK\":\"我的應用\",\"US\":\"My Application\"}');
INSERT INTO `shd_auth_rule` VALUES (1934, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::favoriteApp', '', '应用收藏', '', 1898, 0, '', 786, '{\"CN\":\"应用收藏\",\"HK\":\"應用收藏\",\"US\":\"App Collection\"}');
INSERT INTO `shd_auth_rule` VALUES (1935, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::favoriteAppAdd', '', '应用添加收藏', '', 1898, 0, '', 787, '{\"CN\":\"应用添加收藏\",\"HK\":\"應用添加收藏\",\"US\":\"Apply add favorites\"}');
INSERT INTO `shd_auth_rule` VALUES (1936, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::favoriteAppDel', '', '应用移除删除', '', 1898, 0, '', 788, '{\"CN\":\"应用移除删除\",\"HK\":\"應用移除刪除\",\"US\":\"App remove delete\"}');
INSERT INTO `shd_auth_rule` VALUES (1937, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::appEvaluation', '', '应用评论', '', 1898, 0, '', 789, '{\"CN\":\"应用评论\",\"HK\":\"應用評論\",\"US\":\"App Review\"}');
INSERT INTO `shd_auth_rule` VALUES (1938, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::appEvaluationAdd', '', '应用添加评论', '', 1898, 0, '', 790, '{\"CN\":\"应用添加评论\",\"HK\":\"應用添加評論\",\"US\":\"Apply add comment\"}');
INSERT INTO `shd_auth_rule` VALUES (1939, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::appEvaluationDel', '', '应用删除评论', '', 1898, 0, '', 791, '{\"CN\":\"应用删除评论\",\"HK\":\"應用刪除評論\",\"US\":\"App delete comment\"}');
INSERT INTO `shd_auth_rule` VALUES (1940, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::evaluationEvaluate', '', '追加评论', '', 1898, 0, '', 792, '{\"CN\":\"追加评论\",\"HK\":\"追加評論\",\"US\":\"Add Comment\"}');
INSERT INTO `shd_auth_rule` VALUES (1941, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::evaluationLikeAdd', '', '评论点赞', '', 1898, 0, '', 793, '{\"CN\":\"评论点赞\",\"HK\":\"評論點贊\",\"US\":\"Comment Like\"}');
INSERT INTO `shd_auth_rule` VALUES (1942, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AppStorecontroller::evaluationLikeDel', '', '评论取消点赞', '', 1898, 0, '', 794, '{\"CN\":\"评论取消点赞\",\"HK\":\"評論取消點贊\",\"US\":\"Comment canceled like\"}');
INSERT INTO `shd_auth_rule` VALUES (1943, 1, 'admin', 'admin_url', '', '', '客户等级', '', 1901, 1, '/customer-level', 95, '{\"CN\":\"客户等级\",\"HK\":\"客戶等級\",\"US\":\"Customer Level\"}');
INSERT INTO `shd_auth_rule` VALUES (1944, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Commoncontroller::saleList', '', '销售列表', '', 1843, 0, '', 848, '{\"CN\":\"销售列表\",\"HK\":\"銷售列表\",\"US\":\"Sales List\"}');
INSERT INTO `shd_auth_rule` VALUES (1945, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getUserDownList', '', '附件列表', '', 420, 0, '', 526, '{\"CN\":\"附件列表\",\"HK\":\"附件列表\",\"US\":\"Attachment List\"}');
INSERT INTO `shd_auth_rule` VALUES (1946, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getUserFile', '', '下载附件', '', 420, 0, '', 527, '{\"CN\":\"下载附件\",\"HK\":\"下載附件\",\"US\":\"Download attachment\"}');
INSERT INTO `shd_auth_rule` VALUES (1947, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postUploadUserFile', '', '添加文件', '', 420, 0, '', 528, '{\"CN\":\"添加文件\",\"HK\":\"添加文件\",\"US\":\"Add File\"}');
INSERT INTO `shd_auth_rule` VALUES (1948, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::deleteUserFile', '', '删除文件', '', 420, 0, '', 529, '{\"CN\":\"删除文件\",\"HK\":\"刪除文件\",\"US\":\"Delete File\"}');
INSERT INTO `shd_auth_rule` VALUES (1949, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postAddUserFile', '', '添加用户附件', '', 420, 0, '', 530, '{\"CN\":\"添加用户附件\",\"HK\":\"添加用戶附件\",\"US\":\"Add user attachment\"}');
INSERT INTO `shd_auth_rule` VALUES (1950, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::getUserFilePage', '', '编辑添加附件页面', '', 420, 0, '', 531, '{\"CN\":\"编辑添加附件页面\",\"HK\":\"編輯添加附件頁面\",\"US\":\"Edit and add attachment page\"}');
INSERT INTO `shd_auth_rule` VALUES (1951, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Downloadscontroller::postSaveUserFile', '', '保存附件信息', '', 420, 0, '', 532, '{\"CN\":\"保存附件信息\",\"HK\":\"保存附件信息\",\"US\":\"Save attachment information\"}');
INSERT INTO `shd_auth_rule` VALUES (1953, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserLevelController::getList', '', '客户等级列表', '', 1943, 0, '', 96, '{\"CN\":\"客户等级列表\",\"HK\":\"客戶等級列表\",\"US\":\"Customer Level List\"}');
INSERT INTO `shd_auth_rule` VALUES (1954, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserLevelController::getLevelPage', '', '编辑规则页面', '', 1943, 0, '', 97, '{\"CN\":\"编辑规则页面\",\"HK\":\"編輯規則頁面\",\"US\":\"Edit Rule Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1955, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserLevelController::postLevel', '', '创建/编辑规则', '', 1943, 0, '', 98, '{\"CN\":\"创建\\/编辑规则\",\"HK\":\"創建\\/編輯規則\",\"US\":\"Create\\/Edit Rule\"}');
INSERT INTO `shd_auth_rule` VALUES (1956, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserLevelController::deleteLevel', '', '删除规则', '', 1943, 0, '', 99, '{\"CN\":\"删除规则\",\"HK\":\"刪除規則\",\"US\":\"Delete Rule\"}');
INSERT INTO `shd_auth_rule` VALUES (1957, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::addRecordLog', '', '添加跟踪记录', '', 1507, 0, '', 183, '{\"CN\":\"添加跟踪记录\",\"HK\":\"添加跟踪記錄\",\"US\":\"Add Tracking Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1958, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::addRemarkLog', '', '添加跟踪记录 补充说明', '', 1507, 0, '', 184, '{\"CN\":\"添加跟踪记录 补充说明\",\"HK\":\"添加跟踪記錄 補充說明\",\"US\":\"Add tracking record supplementary explanation\"}');
INSERT INTO `shd_auth_rule` VALUES (1959, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::getTrackRecord', '', '获取跟踪记录', '', 1507, 0, '', 185, '{\"CN\":\"获取跟踪记录\",\"HK\":\"獲取跟踪記錄\",\"US\":\"Get Tracking Record\"}');
INSERT INTO `shd_auth_rule` VALUES (1960, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::clientTrackStatus', '', '修改跟踪记录状态', '', 1507, 0, '', 186, '{\"CN\":\"修改跟踪记录状态\",\"HK\":\"修改跟踪記錄狀態\",\"US\":\"Modify Track Record Status\"}');
INSERT INTO `shd_auth_rule` VALUES (1961, 1, 'admin', 'admin_url', 'app\\admin\\controller\\DcimController::delete', '', 'dcim删除', '', 1876, 0, '', 421, '{\"CN\":\"dcim删除\",\"HK\":\"dcim刪除\",\"US\":\"dcim delete\"}');
INSERT INTO `shd_auth_rule` VALUES (1962, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::clientlistre', '', '客户列表', '', 13, 0, '', 26, '{\"CN\":\"客户列表\",\"HK\":\"客戶列表\",\"US\":\"Customer List\"}');
INSERT INTO `shd_auth_rule` VALUES (1965, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController', '', '日志清理', '', 1916, 1, '/log-cleanup', 685, '{\"CN\":\"日志清理\",\"HK\":\"日誌清理\",\"US\":\"Log Cleanup\"}');
INSERT INTO `shd_auth_rule` VALUES (1966, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getDeleteLogPage', '', '删除日志页面', '', 1965, 0, '0', 686, '{\"CN\":\"删除日志页面\",\"HK\":\"刪除日誌頁面\",\"US\":\"Delete log page\"}');
INSERT INTO `shd_auth_rule` VALUES (1967, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::getAffirmDeleteLogPage', '', '删除日志页面(二次确认)', '', 1965, 0, '0', 687, '{\"CN\":\"删除日志页面(二次确认)\",\"HK\":\"刪除日誌頁面(二次確認)\",\"US\":\"Delete log page (second confirmation)\"}');
INSERT INTO `shd_auth_rule` VALUES (1968, 1, 'admin', 'admin_url', 'app\\admin\\controller\\LogRecordController::deleteLog', '', '删除日志', '', 1965, 0, '0', 688, '{\"CN\":\"删除日志\",\"HK\":\"刪除日誌\",\"US\":\"Delete log\"}');
INSERT INTO `shd_auth_rule` VALUES (1969, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::postBatchRenewPage', '', '结算批量续费（页面）', '', 28, 0, '', 174, '{\"CN\":\"结算批量续费（页面）\",\"HK\":\"結算批量續費（頁面）\",\"US\":\"Settlement batch renewal (page)\"}');
INSERT INTO `shd_auth_rule` VALUES (1970, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::postBatchRenew', '', '结算批量续费', '', 28, 0, '', 175, '{\"CN\":\"结算批量续费\",\"HK\":\"結算批量續費\",\"US\":\"Settlement batch renewal\"}');
INSERT INTO `shd_auth_rule` VALUES (1971, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::getApplyCreditPage', '', '向账单使用余额 页面', '', 28, 0, '', 177, '{\"CN\":\"向账单使用余额 页面\",\"HK\":\"向賬單使用餘額 頁面\",\"US\":\"Use balance page to bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1972, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::applyCredit', '', '向账单使用余额', '', 28, 0, '', 178, '{\"CN\":\"向账单使用余额\",\"HK\":\"向賬單使用餘額\",\"US\":\"Use balance to bill\"}');
INSERT INTO `shd_auth_rule` VALUES (1973, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getTimetype', '', '获取时间类型', '', 1463, 0, '', 67, '{\"CN\":\"获取时间类型\",\"HK\":\"獲取時間類型\",\"US\":\"Get Time Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1974, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller', '', '高级可配置项', '', 0, 0, '', 921, '{\"CN\":\"高级可配置项\",\"HK\":\"高級可配置項\",\"US\":\"Advanced configurable items\"}');
INSERT INTO `shd_auth_rule` VALUES (1975, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::page', '', '高级配置页面', '', 1974, 0, '', 922, '{\"CN\":\"高级配置页面\",\"HK\":\"高級配置頁面\",\"US\":\"Advanced Configuration Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1976, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::create', '', '高级配置创建、编辑', '', 1974, 0, '', 923, '{\"CN\":\"高级配置创建、编辑\",\"HK\":\"高級配置創建、編輯\",\"US\":\"Advanced configuration creation and editing\"}');
INSERT INTO `shd_auth_rule` VALUES (1977, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::deleteCondition', '', '删除条件', '', 1974, 0, '', 924, '{\"CN\":\"删除条件\",\"HK\":\"刪除條件\",\"US\":\"Delete Condition\"}');
INSERT INTO `shd_auth_rule` VALUES (1978, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::deleteResult', '', '删除结果', '', 1974, 0, '', 925, '{\"CN\":\"删除结果\",\"HK\":\"刪除結果\",\"US\":\"Delete Results\"}');
INSERT INTO `shd_auth_rule` VALUES (1979, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::addCondition', '', '添加条件', '', 1974, 0, '', 926, '{\"CN\":\"添加条件\",\"HK\":\"添加條件\",\"US\":\"Add Condition\"}');
INSERT INTO `shd_auth_rule` VALUES (1980, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AdvancedOptionscontroller::addResult', '', '添加结果', '', 1974, 0, '', 927, '{\"CN\":\"添加结果\",\"HK\":\"添加結果\",\"US\":\"Add Result\"}');
INSERT INTO `shd_auth_rule` VALUES (1981, 1, 'admin', 'admin_url', 'app\\admin\\controller\\AffiliateController::gettimetype', '', '获取时间类型', '', 1463, 0, '', 74, '{\"CN\":\"获取时间类型\",\"HK\":\"獲取時間類型\",\"US\":\"Get Time Type\"}');
INSERT INTO `shd_auth_rule` VALUES (1984, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController', '', '发票管理', '', 1900, 0, '/invoice-manage', 245, '{\"CN\":\"发票管理\",\"HK\":\"發票管理\",\"US\":\"Invoice Management\"}');
INSERT INTO `shd_auth_rule` VALUES (1985, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::getVoucherList', '', '发票列表', '', 1900, 1, '/invoice-audit', 248, '{\"CN\":\"发票列表\",\"HK\":\"發票列表\",\"US\":\"Invoice List\"}');
INSERT INTO `shd_auth_rule` VALUES (1986, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::getCombineInvoices', '', '合并账单页面', '', 408, 0, '', 237, '{\"CN\":\"合并账单页面\",\"HK\":\"合併賬單頁面\",\"US\":\"Consolidated Billing Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1987, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::combineInvoices', '', '合并账单', '', 408, 0, '', 238, '{\"CN\":\"合并账单\",\"HK\":\"合併賬單\",\"US\":\"Consolidated Bills\"}');
INSERT INTO `shd_auth_rule` VALUES (1988, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::getrate', '', '设置费率页面', '', 2010, 0, '', 283, '{\"CN\":\"设置费率页面\",\"HK\":\"設置費率頁面\",\"US\":\"Set rate page\"}');
INSERT INTO `shd_auth_rule` VALUES (1989, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::postRate', '', '设置费率', '', 2010, 0, '', 284, '{\"CN\":\"设置费率\",\"HK\":\"設置費率\",\"US\":\"Set rate\"}');
INSERT INTO `shd_auth_rule` VALUES (1990, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::getExpressList', '', '快递管理列表', '', 2010, 0, '', 285, '{\"CN\":\"快递管理列表\",\"HK\":\"快遞管理列表\",\"US\":\"Express Delivery Management List\"}');
INSERT INTO `shd_auth_rule` VALUES (1991, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::postExpress', '', '快递管理(添加、编辑)', '', 2010, 0, '', 286, '{\"CN\":\"快递管理(添加、编辑)\",\"HK\":\"快遞管理(添加、編輯)\",\"US\":\"Express Delivery Management (Add, Edit)\"}');
INSERT INTO `shd_auth_rule` VALUES (1992, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::getExpress', '', '快递管理页面', '', 2010, 0, '', 287, '{\"CN\":\"快递管理页面\",\"HK\":\"快遞管理頁面\",\"US\":\"Express Delivery Management Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1993, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::deleteExpress', '', '快递管理(删除)', '', 2010, 0, '', 288, '{\"CN\":\"快递管理(删除)\",\"HK\":\"快遞管理(刪除)\",\"US\":\"Express Delivery Management (deleted)\"}');
INSERT INTO `shd_auth_rule` VALUES (1994, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::postVoucherStatus', '', '修改发票状态', '', 1984, 0, '', 246, '{\"CN\":\"修改发票状态\",\"HK\":\"修改發票狀態\",\"US\":\"Modify Invoice Status\"}');
INSERT INTO `shd_auth_rule` VALUES (1995, 1, 'admin', 'admin_url', 'app\\admin\\controller\\VoucherController::getVoucherDetail', '', '发票详情', '', 1984, 0, '', 247, '{\"CN\":\"发票详情\",\"HK\":\"發票詳情\",\"US\":\"Invoice Details\"}');
INSERT INTO `shd_auth_rule` VALUES (1996, 1, 'admin', 'admin_url', '', '', '工单传递', '', 1320, 1, '/work-order-rules', 353, '{\"CN\":\"工单传递\",\"HK\":\"工單傳遞\",\"US\":\"Ticket Transfer\"}');
INSERT INTO `shd_auth_rule` VALUES (1997, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CommonController::getUpstreamTicketDepartmentList', '', '上游部门列表', '', 1843, 0, '', 849, '{\"CN\":\"上游部门列表\",\"HK\":\"上游部門列表\",\"US\":\"Upstream Department List\"}');
INSERT INTO `shd_auth_rule` VALUES (1998, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDeliverController::addPage', '', '添加工单传递规则页面', '', 1996, 0, '', 354, '{\"CN\":\"添加工单传递规则页面\",\"HK\":\"添加工單傳遞規則頁面\",\"US\":\"Add Ticket Delivery Rule Page\"}');
INSERT INTO `shd_auth_rule` VALUES (1999, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDeliverController::add', '', '添加工单传递规则', '', 1996, 0, '', 355, '{\"CN\":\"添加工单传递规则\",\"HK\":\"添加工單傳遞規則\",\"US\":\"Add Ticket routing rules\"}');
INSERT INTO `shd_auth_rule` VALUES (2000, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDeliverController::save', '', '编辑工单传递规则', '', 1996, 0, '', 356, '{\"CN\":\"编辑工单传递规则\",\"HK\":\"編輯工單傳遞規則\",\"US\":\"Edit Ticket Delivery Rules\"}');
INSERT INTO `shd_auth_rule` VALUES (2001, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDeliverController::delete', '', '删除工单传递规则', '', 1996, 0, '', 357, '{\"CN\":\"删除工单传递规则\",\"HK\":\"刪除工單傳遞規則\",\"US\":\"Delete Ticket Delivery Rules\"}');
INSERT INTO `shd_auth_rule` VALUES (2002, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDeliverController::getList', '', '工单传递规则列表', '', 1996, 0, '', 358, '{\"CN\":\"工单传递规则列表\",\"HK\":\"工單傳遞規則列表\",\"US\":\"Ticket Delivery Rule List\"}');
INSERT INTO `shd_auth_rule` VALUES (2003, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::navGroupOrder', '', '产品分类排序', '', 1921, 0, '', 429, '{\"CN\":\"产品分类排序\",\"HK\":\"產品分類排序\",\"US\":\"Product Category Sorting\"}');
INSERT INTO `shd_auth_rule` VALUES (2004, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OauthController::listing', '', '所有三方登录', '', 1910, 0, '', 584, '{\"CN\":\"所有三方登录\",\"HK\":\"所有三方登錄\",\"US\":\"All three parties login\"}');
INSERT INTO `shd_auth_rule` VALUES (2005, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OauthController::active', '', '激活', '', 1910, 0, '', 585, '{\"CN\":\"激活\",\"HK\":\"激活\",\"US\":\"Activate\"}');
INSERT INTO `shd_auth_rule` VALUES (2006, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OauthController::config', '', '配置选项设置页面', '', 1910, 0, '', 586, '{\"CN\":\"配置选项设置页面\",\"HK\":\"配置選項設置頁面\",\"US\":\"Configuration Option Setting Page\"}');
INSERT INTO `shd_auth_rule` VALUES (2007, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OauthController::configSave', '', '配置选项提交保存页面', '', 1910, 0, '', 587, '{\"CN\":\"配置选项提交保存页面\",\"HK\":\"配置選項提交保存頁面\",\"US\":\"Configuration option submission save page\"}');
INSERT INTO `shd_auth_rule` VALUES (2008, 1, 'admin', 'admin_url', 'app\\admin\\controller\\OauthController::suspend', '', '停用三方登录', '', 1910, 0, '', 588, '{\"CN\":\"停用三方登录\",\"HK\":\"停用三方登錄\",\"US\":\"Disable three-way login\"}');
INSERT INTO `shd_auth_rule` VALUES (2010, 1, 'admin', 'admin_url', '', '', '发票设置', '', 1902, 1, '/voucher-setting', 282, '{\"CN\":\"发票设置\",\"HK\":\"發票設置\",\"US\":\"Invoice Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (2011, 1, 'admin', 'admin_url', '', '', '订购商品', '', 1910, 0, '/general-settings/order', 589, '{\"CN\":\"订购商品\",\"HK\":\"訂購商品\",\"US\":\"Order Goods\"}');
INSERT INTO `shd_auth_rule` VALUES (2012, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::getBuyProductPage', '', '订购商品设置页面', '', 2011, 0, '', 590, '{\"CN\":\"订购商品设置页面\",\"HK\":\"訂購商品設置頁面\",\"US\":\"Order product setting page\"}');
INSERT INTO `shd_auth_rule` VALUES (2013, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postBuyProduct', '', '订购商品设置', '', 2011, 0, '', 591, '{\"CN\":\"订购商品设置\",\"HK\":\"訂購商品設置\",\"US\":\"Order product settings\"}');
INSERT INTO `shd_auth_rule` VALUES (2014, 1, 'admin', 'admin_url', '', '', '工单统计', '', 335, 1, '/support-statistics', 316, '{\"CN\":\"工单统计\",\"HK\":\"工單統計\",\"US\":\"Ticket Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (2019, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketStatistics', '', '工单统计', '', 2014, 0, '', 317, '{\"CN\":\"工单统计\",\"HK\":\"工單統計\",\"US\":\"Ticket Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (2020, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketReceive', '', '工单接单', '', 2014, 0, '', 318, '{\"CN\":\"工单接单\",\"HK\":\"工單接單\",\"US\":\"Ticket Acceptance\"}');
INSERT INTO `shd_auth_rule` VALUES (2021, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketTransfer', '', '工单转移', '', 2014, 0, '', 319, '{\"CN\":\"工单转移\",\"HK\":\"工單轉移\",\"US\":\"Ticket Transfer\"}');
INSERT INTO `shd_auth_rule` VALUES (2022, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketController::ticketTransferList', '', '获取工单转移对象列表', '', 2014, 0, '', 320, '{\"CN\":\"获取工单转移对象列表\",\"HK\":\"獲取工單轉移對象列表\",\"US\":\"Get a list of Ticket transfer objects\"}');
INSERT INTO `shd_auth_rule` VALUES (2023, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::getClientNotes', '', '获取备注信息', '', 542, 0, '', 40, '{\"CN\":\"获取备注信息\",\"HK\":\"獲取備註信息\",\"US\":\"Get Remarks Information\"}');
INSERT INTO `shd_auth_rule` VALUES (2024, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::postClientNotes', '', '修改备注信息', '', 542, 0, '', 41, '{\"CN\":\"修改备注信息\",\"HK\":\"修改備註信息\",\"US\":\"Modify Remarks Information\"}');
INSERT INTO `shd_auth_rule` VALUES (2041, 1, 'admin', 'admin_url', 'plugins', '', '插件', '', 1897, 1, 'http://w2.test.idcsmart.com/admin/plugins', 698, '{\"CN\":\"插件\",\"HK\":\"插件\",\"US\":\"Plugin\"}');
INSERT INTO `shd_auth_rule` VALUES (2042, 1, 'admin', 'admin_url', 'plugins', '', '插件列表', '', 2041, 1, 'http://w2.test.idcsmart.com/admin/plugins', 713, '{\"CN\":\"插件列表\",\"HK\":\"插件列表\",\"US\":\"Plugin List\"}');
INSERT INTO `shd_auth_rule` VALUES (2043, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::index', '', '用户信用额详细', '', 13, 0, '', 27, '{\"CN\":\"用户信用额详细\",\"HK\":\"用戶信用額詳細\",\"US\":\"User credit details\"}');
INSERT INTO `shd_auth_rule` VALUES (2044, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::log', '', '信用额调整记录', '', 13, 0, '', 28, '{\"CN\":\"信用额调整记录\",\"HK\":\"信用額調整記錄\",\"US\":\"Credit Adjustment Record\"}');
INSERT INTO `shd_auth_rule` VALUES (2045, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::save', '', '启用信用额', '', 13, 0, '', 29, '{\"CN\":\"启用信用额\",\"HK\":\"啟用信用額\",\"US\":\"Enable Credit\"}');
INSERT INTO `shd_auth_rule` VALUES (2046, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::update', '', '修改信用额', '', 13, 0, '', 30, '{\"CN\":\"修改信用额\",\"HK\":\"修改信用額\",\"US\":\"Modify Credit Limit\"}');
INSERT INTO `shd_auth_rule` VALUES (2047, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::delete', '', '删除信用额', '', 13, 0, '', 33, '{\"CN\":\"删除信用额\",\"HK\":\"刪除信用額\",\"US\":\"Delete Credit\"}');
INSERT INTO `shd_auth_rule` VALUES (2048, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::list', '', '用户信用额使用记录', '', 13, 0, '', 10, '{\"CN\":\"用户信用额使用记录\",\"HK\":\"用戶信用額使用記錄\",\"US\":\"User Credit Usage Record\"}');
INSERT INTO `shd_auth_rule` VALUES (2049, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::userInvoice', '', '用户信用额使用记录', '', 13, 0, '', 11, '{\"CN\":\"用户信用额使用记录\",\"HK\":\"用戶信用額使用記錄\",\"US\":\"User Credit Usage Record\"}');
INSERT INTO `shd_auth_rule` VALUES (2050, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::creditLimitInvoice', '', '用户信用额账单详情', '', 13, 0, '', 13, '{\"CN\":\"用户信用额账单详情\",\"HK\":\"用戶信用額賬單詳情\",\"US\":\"User Credit Billing Details\"}');
INSERT INTO `shd_auth_rule` VALUES (2052, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UploadController::upload', '', '上传图片', '', 1316, 0, '', 546, '{\"CN\":\"上传图片\",\"HK\":\"上傳圖片\",\"US\":\"Upload Picture\"}');
INSERT INTO `shd_auth_rule` VALUES (2053, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getCustomParamType', '', '获取自定义字段类型', '', 308, 0, '', 323, '{\"CN\":\"获取自定义字段类型\",\"HK\":\"獲取自定義字段類型\",\"US\":\"Get Custom Field Type\"}');
INSERT INTO `shd_auth_rule` VALUES (2054, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::addTicketCustomParam', '', '添加自定义字段', '', 308, 0, '', 324, '{\"CN\":\"添加自定义字段\",\"HK\":\"添加自定義字段\",\"US\":\"Add custom field\"}');
INSERT INTO `shd_auth_rule` VALUES (2055, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::getTicketParamVal', '', '获取修改自定义字段的值', '', 308, 0, '', 325, '{\"CN\":\"获取修改自定义字段的值\",\"HK\":\"獲取修改自定義字段的值\",\"US\":\"Get and modify the value of a custom field\"}');
INSERT INTO `shd_auth_rule` VALUES (2056, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::editTicketCustomParam', '', '修改自定义字段', '', 308, 0, '', 326, '{\"CN\":\"修改自定义字段\",\"HK\":\"修改自定義字段\",\"US\":\"Modify custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (2057, 1, 'admin', 'admin_url', 'app\\admin\\controller\\TicketDepartmentController::delTicketCustomParam', '', '删除自定义字段', '', 308, 0, '', 327, '{\"CN\":\"删除自定义字段\",\"HK\":\"刪除自定義字段\",\"US\":\"Delete custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (2058, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getGetCustomParam', '', '获取www自定义字段列表', '', 252, 0, '', 563, '{\"CN\":\"获取www自定义字段列表\",\"HK\":\"獲取www自定義字段列表\",\"US\":\"Get the list of www custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (2059, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getAddCustomParam', '', '添加www自定义字段', '', 252, 0, '', 564, '{\"CN\":\"添加www自定义字段\",\"HK\":\"添加www自定義字段\",\"US\":\"Add www custom field\"}');
INSERT INTO `shd_auth_rule` VALUES (2060, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getUpdateCustomParam', '', '修改www自定义字段', '', 252, 0, '', 565, '{\"CN\":\"修改www自定义字段\",\"HK\":\"修改www自定義字段\",\"US\":\"Modify www custom field\"}');
INSERT INTO `shd_auth_rule` VALUES (2061, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getDelCustomParam', '', '删除www自定义字段的值', '', 252, 0, '', 566, '{\"CN\":\"删除www自定义字段的值\",\"HK\":\"刪除www自定義字段的值\",\"US\":\"Delete the value of the www custom field\"}');
INSERT INTO `shd_auth_rule` VALUES (2062, 1, 'admin', 'admin_url', 'app\\admin\\controller\\NewsController::getGetCustomUpdateVal', '', '获取要修改的www自定义字段的值', '', 252, 0, '', 567, '{\"CN\":\"获取要修改的www自定义字段的值\",\"HK\":\"獲取要修改的www自定義字段的值\",\"US\":\"Get the value of the www custom field to be modified\"}');
INSERT INTO `shd_auth_rule` VALUES (2064, 1, 'admin', 'admin_url', '', '', '基础信息', '', 238, 1, '/base-info', 499, '{\"CN\":\"基础信息\",\"HK\":\"基礎信息\",\"US\":\"Basic Information\"}');
INSERT INTO `shd_auth_rule` VALUES (2065, 1, 'admin', 'admin_url', '', '', '主题模板', '', 238, 1, '/theme-template', 500, '{\"CN\":\"主题模板\",\"HK\":\"主題模板\",\"US\":\"Theme Template\"}');
INSERT INTO `shd_auth_rule` VALUES (2066, 1, 'admin', 'admin_url', '', '', '官网自定义字段', '', 238, 1, '/custom-template-fields', 501, '{\"CN\":\"官网自定义字段\",\"HK\":\"官網自定義字段\",\"US\":\"Official website custom fields\"}');
INSERT INTO `shd_auth_rule` VALUES (2067, 1, 'admin', 'admin_url', 'help', '', '帮助中心', '', 8, 1, '', 558, '{\"CN\":\"帮助中心\",\"HK\":\"幫助中心\",\"US\":\"Help Center\"}');
INSERT INTO `shd_auth_rule` VALUES (2068, 1, 'admin', 'admin_url', '', '', '基础信息', '', 251, 1, '/menber-base-info', 522, '{\"CN\":\"基础信息\",\"HK\":\"基礎信息\",\"US\":\"Basic Information\"}');
INSERT INTO `shd_auth_rule` VALUES (2069, 1, 'admin', 'admin_url', '', '', '注册登录', '', 1910, 1, '/login-register', 580, '{\"CN\":\"注册登录\",\"HK\":\"註冊登錄\",\"US\":\"Register and Login\"}');
INSERT INTO `shd_auth_rule` VALUES (2070, 1, 'admin', 'admin_url', '', '', '主题模板', '', 251, 1, '/menber-theme-template', 523, '{\"CN\":\"主题模板\",\"HK\":\"主題模板\",\"US\":\"Theme Template\"}');
INSERT INTO `shd_auth_rule` VALUES (2071, 1, 'admin', 'admin_url', '', '', '商品订购设置', '', 1878, 1, '/order-product', 424, '{\"CN\":\"商品订购设置\",\"HK\":\"商品訂購設置\",\"US\":\"Product order setting\"}');
INSERT INTO `shd_auth_rule` VALUES (2072, 1, 'admin', 'admin_url', '', '', '文件分组', '', 420, 1, '/service-support', 525, '{\"CN\":\"文件分组\",\"HK\":\"文件分組\",\"US\":\"File Group\"}');
INSERT INTO `shd_auth_rule` VALUES (2073, 1, 'admin', 'admin_url', '', '', '第三方登录', '', 1910, 1, '/third-login', 576, '{\"CN\":\"第三方登录\",\"HK\":\"第三方登錄\",\"US\":\"Third Party Login\"}');
INSERT INTO `shd_auth_rule` VALUES (2074, 1, 'admin', 'admin_url', '', '', '二次验证', '', 1914, 1, '/twice-confirm', 664, '{\"CN\":\"二次验证\",\"HK\":\"二次驗證\",\"US\":\"Secondary Verification\"}');
INSERT INTO `shd_auth_rule` VALUES (2075, 1, 'admin', 'admin_url', '', '', '导航管理', '', 238, 1, '/menu_manage', 502, '{\"CN\":\"导航管理\",\"HK\":\"導航管理\",\"US\":\"Navigation Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2076, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postNewGeneral', '', '系统设置统一修改接口（新）', '', 1909, 0, '', 569, '{\"CN\":\"系统设置统一修改接口（新）\",\"HK\":\"系統設置統一修改接口（新）\",\"US\":\"System settings unified modification interface (new)\"}');
INSERT INTO `shd_auth_rule` VALUES (2077, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postGetConfig', '', '系统设置统一获取接口（新）', '', 1909, 0, '', 570, '{\"CN\":\"系统设置统一获取接口（新）\",\"HK\":\"系統設置統一獲取接口（新）\",\"US\":\"System settings unified acquisition interface (new)\"}');
INSERT INTO `shd_auth_rule` VALUES (2078, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigGeneralController::postGetConfigOption', '', '系统设置选项统一获取接口（新）', '', 1909, 0, '', 571, '{\"CN\":\"系统设置选项统一获取接口（新）\",\"HK\":\"系統設置選項統一獲取接口（新）\",\"US\":\"System setting options unified access interface (new)\"}');
INSERT INTO `shd_auth_rule` VALUES (2082, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getMenu', '', '获取导航以及导航对应的菜单列表', '', 2075, 0, '', 503, '{\"CN\":\"获取导航以及导航对应的菜单列表\",\"HK\":\"獲取導航以及導航對應的菜單列表\",\"US\":\"Get the navigation and the menu list corresponding to the navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2083, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getMenuList', '', '获取菜单列表table', '', 2075, 0, '', 504, '{\"CN\":\"获取菜单列表table\",\"HK\":\"獲取菜單列表table\",\"US\":\"Get the menu list table\"}');
INSERT INTO `shd_auth_rule` VALUES (2084, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::setNavList', '', '设置导航对应的菜单列表', '', 2075, 0, '', 505, '{\"CN\":\"设置导航对应的菜单列表\",\"HK\":\"設置導航對應的菜單列表\",\"US\":\"Set the menu list corresponding to the navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2085, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::addCustomPage', '', '添加产品中心页面', '', 2075, 0, '', 506, '{\"CN\":\"添加产品中心页面\",\"HK\":\"添加產品中心頁面\",\"US\":\"Add Product Center Page\"}');
INSERT INTO `shd_auth_rule` VALUES (2086, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getProductList', '', '导航类型为产品管理时： 获取产品列表', '', 2075, 0, '', 507, '{\"CN\":\"导航类型为产品管理时： 获取产品列表\",\"HK\":\"導航類型為產品管理時： 獲取產品列表\",\"US\":\"When the navigation type is product management: Get product list\"}');
INSERT INTO `shd_auth_rule` VALUES (2087, 1, 'admin', 'admin_url', 'app\\adminc\\ontroller\\MenusController::getMenuType', '', '获取导航以及导航对应的菜单列表', '', 2075, 0, '', 508, '{\"CN\":\"获取导航以及导航对应的菜单列表\",\"HK\":\"獲取導航以及導航對應的菜單列表\",\"US\":\"Get the navigation and the menu list corresponding to the navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2088, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getMenu', '', '获取菜单项类型（会员中心菜单，头部菜单', '', 2075, 0, '', 509, '{\"CN\":\"获取菜单项类型（会员中心菜单，头部菜单\",\"HK\":\"獲取菜單項類型（會員中心菜單，頭部菜單\",\"US\":\"Get the menu item type (member center menu, header menu\"}');
INSERT INTO `shd_auth_rule` VALUES (2089, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::addMenu', '', '添加菜单项', '', 2075, 0, '', 510, '{\"CN\":\"添加菜单项\",\"HK\":\"添加菜單項\",\"US\":\"Add menu item\"}');
INSERT INTO `shd_auth_rule` VALUES (2090, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::editMenu', '', '修改菜单项', '', 2075, 0, '', 511, '{\"CN\":\"修改菜单项\",\"HK\":\"修改菜單項\",\"US\":\"Modify Menu Item\"}');
INSERT INTO `shd_auth_rule` VALUES (2091, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::delMenu', '', '删除菜单项', '', 2075, 0, '', 512, '{\"CN\":\"删除菜单项\",\"HK\":\"刪除菜單項\",\"US\":\"Delete menu item\"}');
INSERT INTO `shd_auth_rule` VALUES (2092, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::delTwoMenu', '', '删除菜单项(二次)', '', 2075, 0, '', 513, '{\"CN\":\"删除菜单项(二次)\",\"HK\":\"刪除菜單項(二次)\",\"US\":\"Delete menu item (secondary)\"}');
INSERT INTO `shd_auth_rule` VALUES (2093, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getTypeAllMenu', '', '获取导航对应的菜单项列表', '', 2075, 0, '', 514, '{\"CN\":\"获取导航对应的菜单项列表\",\"HK\":\"獲取導航對應的菜單項列表\",\"US\":\"Get a list of menu items corresponding to navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2094, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::editMenuActive', '', '修改默认菜单', '', 2075, 0, '', 515, '{\"CN\":\"修改默认菜单\",\"HK\":\"修改默認菜單\",\"US\":\"Modify the default menu\"}');
INSERT INTO `shd_auth_rule` VALUES (2095, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getSystemNav', '', '获取指定的页面', '', 2075, 0, '', 516, '{\"CN\":\"获取指定的页面\",\"HK\":\"獲取指定的頁面\",\"US\":\"Get the specified page\"}');
INSERT INTO `shd_auth_rule` VALUES (2096, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getNavType', '', '获取页面类型', '', 2075, 0, '', 517, '{\"CN\":\"获取页面类型\",\"HK\":\"獲取頁麵類型\",\"US\":\"Get page type\"}');
INSERT INTO `shd_auth_rule` VALUES (2097, 1, 'admin', 'admin_url', 'appadmincontrollerMenusController::getLang', '', '获取语言列表', '', 2075, 0, '', 518, '{\"CN\":\"获取语言列表\",\"HK\":\"獲取語言列表\",\"US\":\"Get Language List\"}');
INSERT INTO `shd_auth_rule` VALUES (2098, 1, 'admin', 'admin_url', '', '', '下游管理', '', 1899, 1, '', 757, '{\"CN\":\"下游管理\",\"HK\":\"下游管理\",\"US\":\"Downstream Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2099, 1, 'admin', 'admin_url', '', '', 'API设置', '', 2098, 1, '/api-setup', 759, '{\"CN\":\"API设置\",\"HK\":\"API設置\",\"US\":\"API Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (2100, 1, 'admin', 'admin_url', '', '', '手动资源', '', 1899, 0, '', 755, '{\"CN\":\"手动资源\",\"HK\":\"手動資源\",\"US\":\"Manual Resources\"}');
INSERT INTO `shd_auth_rule` VALUES (2101, 1, 'admin', 'admin_url', '', '', '任务队列', '', 2098, 1, '/task-queue', 758, '{\"CN\":\"任务队列\",\"HK\":\"任務隊列\",\"US\":\"Task Queue\"}');
INSERT INTO `shd_auth_rule` VALUES (2102, 1, 'admin', 'admin_url', '', '', '系统状态', '', 1897, 1, '/timing-results', 706, '{\"CN\":\"系统状态\",\"HK\":\"系統狀態\",\"US\":\"System Status\"}');
INSERT INTO `shd_auth_rule` VALUES (2103, 1, 'admin', 'admin_url', '', '', '任务队列', '', 2102, 1, '/statistics-taskQueue', 701, '{\"CN\":\"任务队列\",\"HK\":\"任務隊列\",\"US\":\"Task Queue\"}');
INSERT INTO `shd_auth_rule` VALUES (2104, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Menuscontroller::getmenutype', '', '导航菜单类型', '', 2075, 0, '', 519, '{\"CN\":\"导航菜单类型\",\"HK\":\"導航菜單類型\",\"US\":\"Navigation Menu Type\"}');
INSERT INTO `shd_auth_rule` VALUES (2105, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Menuscontroller::getlang', '', '导航菜单语言', '', 2075, 0, '', 520, '{\"CN\":\"导航菜单语言\",\"HK\":\"導航菜單語言\",\"US\":\"Navigation Menu Language\"}');
INSERT INTO `shd_auth_rule` VALUES (2106, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::invoiceLog', '', '账单内页-账单日志', '', 404, 0, '', 236, '{\"CN\":\"账单内页-账单日志\",\"HK\":\"賬單內頁-賬單日誌\",\"US\":\"Bill Inner Page-Bill Log\"}');
INSERT INTO `shd_auth_rule` VALUES (2107, 1, 'admin', 'admin_url', '', '', '统计', '', 1897, 1, '/annual-statistics', 699, '{\"CN\":\"统计\",\"HK\":\"統計\",\"US\":\"Statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (2108, 1, 'admin', 'admin_url', '', '', '定时任务状态', '', 2102, 1, '/timing-results', 700, '{\"CN\":\"定时任务状态\",\"HK\":\"定時任務狀態\",\"US\":\"Timed Task Status\"}');
INSERT INTO `shd_auth_rule` VALUES (2109, 1, 'admin', 'admin_url', '', '', '供应商管理', '', 2100, 1, '/supplier-management', 756, '{\"CN\":\"供应商管理\",\"HK\":\"供應商管理\",\"US\":\"Supplier Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2110, 1, 'admin', 'admin_url', '', '', '上游资源', '', 1899, 1, '', 715, '{\"CN\":\"上游资源\",\"HK\":\"上游資源\",\"US\":\"Upstream Resources\"}');
INSERT INTO `shd_auth_rule` VALUES (2111, 1, 'admin', 'admin_url', '', '', '商品管理', '', 2110, 1, '/commodity-list', 717, '{\"CN\":\"商品管理\",\"HK\":\"商品管理\",\"US\":\"Commodity Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2112, 1, 'admin', 'admin_url', '', '', '产品管理', '', 2110, 1, '/commodity-product', 719, '{\"CN\":\"产品管理\",\"HK\":\"產品管理\",\"US\":\"Product Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2113, 1, 'admin', 'admin_url', '', '', '任务队列', '', 2110, 1, '/commodity-taskQueue', 721, '{\"CN\":\"任务队列\",\"HK\":\"任務隊列\",\"US\":\"Task Queue\"}');
INSERT INTO `shd_auth_rule` VALUES (2114, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserTastesController::editUserTanstes', '', '偏好设置', '', 0, 0, '', 951, '{\"CN\":\"偏好设置\",\"HK\":\"偏好設置\",\"US\":\"Preferences\"}');
INSERT INTO `shd_auth_rule` VALUES (2115, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RunMapController::runCronList', '', '定时任务执行统计', '', 0, 0, '', 952, '{\"CN\":\"定时任务执行统计\",\"HK\":\"定時任務執行統計\",\"US\":\"Timed task execution statistics\"}');
INSERT INTO `shd_auth_rule` VALUES (2116, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RunMapController::runCronTrend', '', '定时任务执行,曲线趋势图', '', 0, 0, '', 953, '{\"CN\":\"定时任务执行,曲线趋势图\",\"HK\":\"定時任務執行,曲線趨勢圖\",\"US\":\"Timed task execution, curve trend chart\"}');
INSERT INTO `shd_auth_rule` VALUES (2117, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::apiHost', '', '产品列表', '', 2112, 0, '', 720, '{\"CN\":\"产品列表\",\"HK\":\"產品列表\",\"US\":\"Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (2118, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::apiProducts', '', '商品列表', '', 2111, 0, '', 718, '{\"CN\":\"商品列表\",\"HK\":\"商品列表\",\"US\":\"Product List\"}');
INSERT INTO `shd_auth_rule` VALUES (2119, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigServersController::groupsList', '', '接口组列表', '', 528, 0, '', 412, '{\"CN\":\"接口组列表\",\"HK\":\"接口組列表\",\"US\":\"Interface Group List\"}');
INSERT INTO `shd_auth_rule` VALUES (2120, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::renew', '', '续费订单列表', '', 17, 0, '', 143, '{\"CN\":\"续费订单列表\",\"HK\":\"續費訂單列表\",\"US\":\"Renewal Order List\"}');
INSERT INTO `shd_auth_rule` VALUES (2121, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertifiController::setting', '', '实名认证设置', '', 542, 0, '', 42, '{\"CN\":\"实名认证设置\",\"HK\":\"實名認證設置\",\"US\":\"Real-name authentication settings\"}');
INSERT INTO `shd_auth_rule` VALUES (2122, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RunMapController::runMapList', '', '任务队列列表', '', 2113, 0, '', 722, '{\"CN\":\"任务队列列表\",\"HK\":\"任務隊列列表\",\"US\":\"Task Queue List\"}');
INSERT INTO `shd_auth_rule` VALUES (2123, 1, 'admin', 'admin_url', 'app\\admin\\controller\\RbacController::copyRole', '', '权限复制', '', 588, 0, '', 2110, '{\"CN\":\"权限复制\",\"HK\":\"權限複製\",\"US\":\"Permission to copy\"}');
INSERT INTO `shd_auth_rule` VALUES (2124, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::summary', '', 'API概览', '', 1860, 0, '', 2110, '{\"CN\":\"API概览\",\"HK\":\"API概覽\",\"US\":\"API Overview\"}');
INSERT INTO `shd_auth_rule` VALUES (2125, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController::userInfo', '', '获取用户信息', '', 28, 0, '', 167, '{\"CN\":\"获取用户信息\",\"HK\":\"獲取用戶信息\",\"US\":\"Get User Information\"}');
INSERT INTO `shd_auth_rule` VALUES (2126, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManagecontroller::getCerifyHistoryLog', '', '实名认证日志历史记录列表', '', 542, 0, '', 2110, '{\"CN\":\"实名认证日志历史记录列表\",\"HK\":\"實名認證日誌歷史記錄列表\",\"US\":\"Real-name authentication log history list\"}');
INSERT INTO `shd_auth_rule` VALUES (2127, 1, 'admin', 'admin_url', '', '', '订单列表', '', 2110, 1, '/supplier-order-list', 2110, '{\"CN\":\"订单列表\",\"HK\":\"訂單列表\",\"US\":\"Order List\"}');
INSERT INTO `shd_auth_rule` VALUES (2128, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController::hostBindSale', '', '绑定销售', '', 1882, 0, '', 2110, '{\"CN\":\"绑定销售\",\"HK\":\"綁定銷售\",\"US\":\"Binding Sales\"}');
INSERT INTO `shd_auth_rule` VALUES (2129, 1, 'admin', 'admin_url', '', '', '信用额管理', '', 1868, 1, '/credit-management', 2110, '{\"CN\":\"信用额管理\",\"HK\":\"信用額管理\",\"US\":\"Credit Management\"}');
INSERT INTO `shd_auth_rule` VALUES (2130, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::clientList', '', '信用额客户列表', '', 2129, 0, '', 2110, '{\"CN\":\"信用额客户列表\",\"HK\":\"信用額客戶列表\",\"US\":\"List of Credit Customers\"}');
INSERT INTO `shd_auth_rule` VALUES (2131, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::getConfig', '', '信用额设置页面', '', 2129, 0, '', 2110, '{\"CN\":\"信用额设置页面\",\"HK\":\"信用額設置頁面\",\"US\":\"Credit Limit Setting Page\"}');
INSERT INTO `shd_auth_rule` VALUES (2132, 1, 'admin', 'admin_url', 'app\\admin\\controller\\CreditLimitController::postConfig', '', '信用额设置页面提交', '', 2129, 0, '', 2110, '{\"CN\":\"信用额设置页面提交\",\"HK\":\"信用額設置頁面提交\",\"US\":\"Submission of credit limit setting page\"}');
INSERT INTO `shd_auth_rule` VALUES (2133, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UploadController::uploadCertificate', '', '后台实名上传', '', 1860, 0, '', 47, '{\"CN\":\"后台实名上传\",\"HK\":\"後臺實名上傳\",\"US\":\"Background real name upload\"}');
INSERT INTO `shd_auth_rule` VALUES (2134, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UploadController::uploadAuthor', '', '授权书上传', '', 1860, 0, '', 48, '{\"CN\":\"授权书上传\",\"HK\":\"後臺實名上傳\",\"US\":\"Background real name upload\"}');
INSERT INTO `shd_auth_rule` VALUES (2135, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertifiController::authorDown', '', '授权书下载', '', 1860, 0, '', 49, '{\"CN\":\"授权书下载\",\"HK\":\"授權書下載\",\"US\":\"Power of attorney Download\"}');
INSERT INTO `shd_auth_rule` VALUES (2136, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigCertifiController::authorDel', '', '授权书删除', '', 1860, 0, '', 50, '{\"CN\":\"授权书删除\",\"HK\":\"授權書删除\",\"US\":\"Deletion of power of attorney\"}');
INSERT INTO `shd_auth_rule` VALUES (2137, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController::authorSubmit', '', '后台实名提交', '', 1860, 0, '', 51, '{\"CN\":\"后台实名提交\",\"HK\":\"後臺實名提交\",\"US\":\"Background real name submission\"}');
INSERT INTO `shd_auth_rule` VALUES (2138, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController::authorInfo', '', '后台实名信息', '', 1860, 0, '', 52, '{\"CN\":\"后台实名信息\",\"HK\":\"後臺實名資訊\",\"US\":\"Background real name information\"}');
INSERT INTO `shd_auth_rule` VALUES (2139, 1, 'admin', 'admin_url', 'app\\admin\\controller\\UserManageController::getCerifyHistoryLog', '', '后台实名历史记录', '', 1860, 0, '', 53, '{\"CN\":\"后台实名历史记录\",\"HK\":\"後臺實名歷史記錄\",\"US\":\"Background real name history\"}');
INSERT INTO `shd_auth_rule` VALUES (2140, 1, 'admin', 'admin_url', 'app\\admin\\controller\\HostController::userInfo', '', '获取用户信息', '', 28, 0, '', 191, '{\"CN\":\"获取用户信息\",\"HK\":\"獲取用戶資訊\",\"US\":\"Get user information\"}');
INSERT INTO `shd_auth_rule` VALUES (2143, 1, 'admin', 'admin_url', '', '', '信用额设置', '', 1902, 1, '/credit-setting', 305, '{\"CN\":\"信用额设置\",\"HK\":\"信用額設定\",\"US\":\"Credit limit setting\"}');
INSERT INTO `shd_auth_rule` VALUES (2144, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigMessageController::getTemplateDesc', '', '创建模板页面可用参数', '', 533, 0, '', 2110, '{\"CN\":\"创建模板页面可用参数\",\"HK\":\"創建範本頁面可用參數\",\"US\":\"Create template page available parameters\"}');
INSERT INTO `shd_auth_rule` VALUES (2145, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::addPage', '', '产品添加页面', '', 2111, 0, '', 2110, '{\"CN\":\"产品添加页面\",\"HK\":\"產品添加頁面\",\"US\":\"Product add page\"}');
INSERT INTO `shd_auth_rule` VALUES (2146, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::upstreamHost', '', '批量拉取产品信息的前台会员中心接口', '', 2112, 0, '', 2110, '{\"CN\":\"批量拉取产品信息的前台会员中心接口\",\"HK\":\"批量拉取產品資訊的前臺會員中心介面\",\"US\":\"Front desk member center interface for batch');
INSERT INTO `shd_auth_rule` VALUES (2147, 1, 'admin', 'admin_url', '', '', '合同列表', '', 1900, 1, '/contracts_audit', 249, '{\"CN\":\"合同列表\",\"HK\":\"合同列表\",\"US\":\"contracts List\"}');
INSERT INTO `shd_auth_rule` VALUES (2148, 1, 'admin', 'admin_url', '', '', '合同设置', '', 1902, 1, '/contracts_setting', 283, '{\"CN\":\"合同设置\",\"HK\":\"合同設置\",\"US\":\"contracts Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (2149, 1, 'admin', 'admin_url', '', '', '友情链接', '', 238, 1, '/friendly_link', 503, '{\"CN\":\"友情链接\",\"HK\":\"友情鏈接\",\"US\":\"Friendly Link\"}');
INSERT INTO `shd_auth_rule` VALUES (2150, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getDefaultSenior', '', '根据第一个产品获取高级设置', '', 2075, 0, '', 507, '{\"CN\":\"根据第一个产品获取高级设置\",\"HK\":\"根據第一個產品獲取高級設定\",\"US\":\"Get advanced settings based on the first product\"}');
INSERT INTO `shd_auth_rule` VALUES (2151, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::setWebNavList', '', '设置web导航对应的菜单列表', '', 2075, 0, '', 507, '{\"CN\":\"设置web导航对应的菜单列表\",\"HK\":\"設定web導航對應的選單清單\",\"US\":\"Set the menu list corresponding to web navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2152, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::createWebPage', '', '创建web页面', '', 2075, 0, '', 507, '{\"CN\":\"创建web页面\",\"HK\":\"創建web頁面\",\"US\":\"Create a web page\"}');
INSERT INTO `shd_auth_rule` VALUES (2153, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getCreateWebData', '', '获取创建web导航所需数据', '', 2075, 0, '', 507, '{\"CN\":\"获取创建web导航所需数据\",\"HK\":\"獲取創建web導航所需數據\",\"US\":\"Get the data needed to create web navigation\"}');
INSERT INTO `shd_auth_rule` VALUES (2154, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::getOtherMenu', '', '获取除菜单id之外的菜单', '', 2075, 0, '', 507, '{\"CN\":\"获取除菜单id之外的菜单\",\"HK\":\"獲取除選單id之外的選單\",\"US\":\"Gets a menu other than the menu ID\"}');
INSERT INTO `shd_auth_rule` VALUES (2155, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ZjmfFinanceApiController::upstreamCredit', '', '获取余额', '', 0, 0, '', 2110, '{\"CN\":\"获取余额\",\"HK\":\"獲取餘額\",\"US\":\"get balance\"}');
INSERT INTO `shd_auth_rule` VALUES (2156, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getSystemAuthRuleLanguage', '', '路由菜单', '', 0, 0, NULL, 1, '{\"CN\":\"路由菜单\",\"HK\":\"路由菜單\",\"US\":\"Routing menu\"}');
INSERT INTO `shd_auth_rule` VALUES (2157, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::adminGetLinkAgeList', '', '产品内页层级联动', '', 28, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2158, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::getNextLinkAgeList', '', '可配置项层级联动下级列表', '', 228, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2159, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::saveConfigOptionInfo', '', '可配置项层级联动项信息保存', '', 228, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2160, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::saveLinkAgeLevel', '', '可配置项层级联动保存', '', 228, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2161, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::saveLinkAgeOrder', '', '可配置项层级联动排序', '', 228, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2162, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ConfigOptionsController::delLinkAgeSub', '', '可配置项层级联动删除', '', 228, 0, '', 2110, '');
INSERT INTO `shd_auth_rule` VALUES (2173, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contract', '', '合同列表', '', 922, 0, '', 1, '{\"CN\":\"合同列表\",\"HK\":\"契约清單\",\"US\":\"Contract list\"}');
INSERT INTO `shd_auth_rule` VALUES (2174, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Contractcontroller::setting', '', '合同模块基础设置', '', 922, 0, '', 1, '{\"CN\":\"合同模块基础设置\",\"HK\":\"契约模塊基礎設定\",\"US\":\"Basic settings of contract module\"}');
INSERT INTO `shd_auth_rule` VALUES (2175, 1, 'admin', 'admin_url', 'app\\admin\\controller\\Contractcontroller::download', '', '合同查看下载', '', 922, 0, '', 1, '{\"CN\":\"合同查看下载\",\"HK\":\"契约查看下載\",\"US\":\"Contract view and download\"}');
INSERT INTO `shd_auth_rule` VALUES (2176, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::tpl', '', '合同模板列表', '', 922, 0, '', 1, '{\"CN\":\"合同模板列表\",\"HK\":\"契约範本清單\",\"US\":\"List of contract templates\"}');
INSERT INTO `shd_auth_rule` VALUES (2177, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::detail', '', '添加/编辑合同页面', '', 922, 0, '', 1, '{\"CN\":\"添加/编辑合同页面\",\"HK\":\"添加/編輯契约頁面\",\"US\":\"Add / edit contract page\"}');
INSERT INTO `shd_auth_rule` VALUES (2178, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::detailPost', '', '创建编辑合同页面提交', '', 922, 0, '', 1, '{\"CN\":\"创建编辑合同页面提交\",\"HK\":\"創建編輯契约頁面提交\",\"US\":\"Create  edit contract page submission\"}');
INSERT INTO `shd_auth_rule` VALUES (2179, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::settingPost', '', '合同模块基础设置提交', '', 922, 0, '', 1, '{\"CN\":\"合同模块基础设置提交\",\"HK\":\"契约模塊基礎設定提交\",\"US\":\"Contract module basic settings submission\"}');
INSERT INTO `shd_auth_rule` VALUES (2180, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractPage', '', '签订合同页面', '', 922, 0, '', 1, '{\"CN\":\"签订合同页面\",\"HK\":\"簽訂合同頁面\",\"US\":\"Contract signing page\"}');
INSERT INTO `shd_auth_rule` VALUES (2181, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractPagePost', '', '签订合同(生成PDF文档)', '', 922, 0, '', 1, '{\"CN\":\"签订合同(生成PDF文档)\",\"HK\":\"簽訂合同（生成PDF檔案）\",\"US\":\"Contract signing (PDF document generation)\"}');
INSERT INTO `shd_auth_rule` VALUES (2182, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::cancel', '', '合同作废', '', 922, 0, '', 1, '{\"CN\":\"合同作废\",\"HK\":\"契约作廢\",\"US\":\"Cancellation of contract\"}');
INSERT INTO `shd_auth_rule` VALUES (2183, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::deleteTpl', '', '删除合同模板', '', 922, 0, '', 1, '{\"CN\":\"删除合同模板\",\"HK\":\"删除契约範本\",\"US\":\"Delete contract template\"}');
INSERT INTO `shd_auth_rule` VALUES (2184, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::cancelPost', '', '取消邮寄', '', 922, 0, '', 1, '{\"CN\":\"取消邮寄\",\"HK\":\"取消郵寄\",\"US\":\"Cancel mailing\"}');
INSERT INTO `shd_auth_rule` VALUES (2185, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::check', '', '审核通过', '', 922, 0, '', 1, '{\"CN\":\"审核通过\",\"HK\":\"稽核通過\",\"US\":\"Approved\"}');
INSERT INTO `shd_auth_rule` VALUES (2186, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::delete', '', '删除合同', '', 922, 0, '', 1, '{\"CN\":\"删除合同\",\"HK\":\"删除契约\",\"US\":\"Delete contract\"}');
INSERT INTO `shd_auth_rule` VALUES (2187, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ContractController::contractPost', '', '合同邮寄管理', '', 922, 0, '', 1, '{\"CN\":\"合同邮寄管理\",\"HK\":\"契约郵寄管理\",\"US\":\"Contract mailing management\"}');
INSERT INTO `shd_auth_rule` VALUES (2188, 1, 'admin', 'admin_url', 'app\\admin\\controller\\SystemController::getAuthorize', '', '更换授权码', '', 0, 0, '', 1, '{\"CN\":\"更换授权码\",\"HK\":\"更換授權碼\",\"US\":\"Replace authorization code\"}');
INSERT INTO `shd_auth_rule` VALUES (2189, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::allLinks', '', '友情连接列表', '', 2149, 0, '', 1, '{\"CN\":\"友情连接列表\",\"HK\":\"友情連接清單\",\"US\":\"Friendship connection list\"}');
INSERT INTO `shd_auth_rule` VALUES (2190, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::saveLinks', '', '友情连接保存', '', 2149, 0, '', 1, '{\"CN\":\"友情连接保存\",\"HK\":\"友情連接保存\",\"US\":\"Friendship connection preservation\"}');
INSERT INTO `shd_auth_rule` VALUES (2191, 1, 'admin', 'admin_url', 'app\\admin\\controller\\MenusController::deleteLinks', '', '友情连接删除', '', 2149, 0, '', 1, '{\"CN\":\"友情连接删除\",\"HK\":\"友情連接删除\",\"US\":\"Friendship connection deletion\"}');
INSERT INTO `shd_auth_rule` VALUES (2200, 1, 'admin', 'admin_url', '', '', '续费订单', '', 2110, 1, '/supplier-renewal-order', 2110, '{\"CN\":\"续费订单\",\"HK\":\"續費訂單\",\"US\":\"Renewal order\"}');
INSERT INTO `shd_auth_rule` VALUES (5, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ProductController', '', '商品设置', '', 6, 1, '/product-server', 359, '{\"CN\":\"商品设置\",\"HK\":\"商品設置\",\"US\":\"Commodity Set\"}');
INSERT INTO `shd_auth_rule` VALUES (6, 1, 'admin', 'admin_url', 'set', '', '设置', '', 0, 1, '/set', 359, '{\"CN\":\"设置\",\"HK\":\"設置\",\"US\":\"Set\"}');
INSERT INTO `shd_auth_rule` VALUES (7, 1, 'admin', 'admin_url', 'set', '', '基础设置', '', 6, 1, '/set', 357, '{\"CN\":\"基础设置\",\"HK\":\"基础设置\",\"US\":\"Basic Settings\"}');
INSERT INTO `shd_auth_rule` VALUES (8, 1, 'admin', 'admin_url', 'zw', '', '站务设置', '', 6, 1, '/base-info', 497, '{\"CN\":\"站务设置\",\"HK\":\"站務設置\",\"US\":\"Station Service Set\"}');
INSERT INTO `shd_auth_rule` VALUES (1909, 1, 'admin', 'admin_url', 'System', '', '系统设置', '', 6, 1, '/general-settings/general', 358, '{\"CN\":\"系统设置\",\"HK\":\"系統設置\",\"US\":\"System Set\"}');
INSERT INTO `shd_auth_rule` VALUES (2201, 1, 'admin', 'admin_url', 'app\\admin\\controller\\ClientsServicesController::suspend', '', '暂停', '', 1397, 0, '', 156, '{\"CN\":\"暂停\",\"HK\":\"暫停\",\"US\":\"Pause\"}');
INSERT INTO `shd_auth_rule` VALUES (2202, 1, 'admin', 'admin_url', 'app\\admin\\controller\\InvoiceController::applycreditlimit', '', '向账单使用信用额', '', 1342, 0, '', 230, '{\"CN\":\"向账单使用信用额\",\"HK\":\"向帳單使用信用額\",\"US\":\"Credit amount used for statement\"}');