# 智简魔方财务系统第三方登录插件开发

#### 1、文件命名

1）、新建目录，在“modules/oauth/”下新建你要开发的登录插件目录名。
2）、新建文件，在新建的目录下，创建文件，文件的名称和新建目录要一致。例如要开发微信登录就在oauth目录下创建weixin文件夹，在weixin文件夹下创建weixin.php

#### 2、文件中写代码（以微信登录开发为例）

1)、创建命名空间  namespace oauth\weixin; 
2)、创建类名   weixin   (类名和文件名一致)
3)、类中配置函数 (下面四个函数名是固定，不能改也不能缺失，其它需要的功能自己写函数) 
	插件信息函数  meta()
	插件接口配置信息  config()
	生成授权地址函数  url($params)
	回调地址函数  callback($params)

#### 3、插件信息函数  meta()	

参数

| 键名（固定不能修改） | 是否必填 | 描述                                                         |
| :------------------- | -------- | ------------------------------------------------------------ |
| name                 | 是       | 插件名称                                                     |
| description          | 否       | 插件描述                                                     |
| author               | 否       | 开发者                                                       |
| logo_url             | 是       | 接口图片地址，会在后台设置/客户登录页，绑定账号页面显示这个图片。 |
| version              | 是       | 版本号                                                       |

	格式如下：
	return [
		'name'        => '微信登录',//插件名称
		'description' => '微信登录',//描述
		'author'      => '智简魔方',//开发者
		'logo_url'=> 'weixin.svg',//接口图片地址，会在后台设置/客户登录页，绑定账号页面显示这个图片。
		'version'=> '1.0.0',//版本号
	];

**备注：meta() 返回的是一维数组**

#### 4、插件接口配置信息  config() 

参数

| 键名（固定不能改） | 是否必填 | 描述                                             |
| ------------------ | -------- | ------------------------------------------------ |
| type               | 是       | type值  有 text ,textarea（只能这两种类型）      |
| name               | 是       | name 的值自定义，在下面的url和callback中会使用到 |
| desc               | 否       | 描述信息                                         |

```
格式如下：
return [
	'App Key'=> [
		'type' => 'text',
		'name' => 'appid',
		'desc' => '应用唯一标识，在微信开放平台提交应用审核通过后获得'
	],
	'App Secret'=> [
		'type' => 'text',
		'name' => 'appSecret',
		'desc' => '应用密钥AppSecret，在微信开放平台提交应用审核通过后获得'
	],
];
```
**备注：config() 返回的是二维数组** 上面的例子中的 App Key 和 App Secret不是固定的，自定义

#### 5、生成授权地址函数  url($params)

接收参数$params ，$params是数组，包含了下面两种信息
①数组包含了 config()函数中的所有参数(config函数中name的值就是数组键，
②外加一个$params['callback']回调地址
	

返回的类型：string
返回的数据：三方登录地址

#### 6、回调地址函数  callback($params)

接收参数$params ，$params是数组，包含了下面三种信息
①数组包含了 config()函数中的所有参数（就是config()函数中的name的值是这里的键）
②外加一个$params['callback']回调地址
③三方登录成功后跳转返回的参数
	
返回的类型：array
返回的数据：

| 键名         | 是否必填 | 描述                                                         |
| ------------ | -------- | ------------------------------------------------------------ |
| openid       | 是       | 三方登录授权成功后返回的用户唯一标识                         |
| callbackBind | 否       | all，邮箱和手机号任选绑定。<br/>bind_mobile，输入手机号绑定，<br/>bind_email，输入邮箱绑定<br/>login，三方授权登录后跳转到会员中心，直接登录，会创建一个邮箱和手机号是空的用户并绑定该插件模块。<br/>不返回这个参数就会默认是all，（如果是在会员中心绑定账号，该参数会忽略，只有在第一次用相应的三方登录的时候才会判断这个参数） |
| data         | 否       | 'username'=>'用户昵称',<br/>'sex'=>’性别1男2女，只能是这2个值，不是需要转换‘,<br/>'province'=>'省份',<br/>'city'=>'城市',<br/>'avatar'=>'头像图片', |

```
return [
    'openid'=>$openid['openid'],//必须
    'data'=>[
        'username'=>'用户昵称',
        'sex'=>’性别1男2女，只能是这2个值，不是需要转换‘,
        'province'=>'省份',
        'city'=>'城市',
        'avatar'=>'头像图片',
        ],
    'callbackBind'=>'all',
];
```



#### 说明：

1）、在申请第三方登录API的时候，有的会要求填回调地址 回调地址就是（当前的域名/oauth/callback/当前开发的插件文件名，例如微信扫码登陆，的回调地址

http://www.xxx.com/oauth/callback/weixin）。有的要求填回调域，就填当前域名网址（例如http://www.xxx.com/）。

2）、插件目录名和文件名和类名要一致。

3）、没有安装markdown编辑器的，可以去论坛查看，

论坛文档地址：https://bbs.idcsmart.com/forum.php?mod=viewthread&tid=818&page=1&extra=#pid1906

